/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudwatchlogs.transform.MetricFilterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metric filters express how CloudWatch Logs would extract metric observations from ingested log events and transform
 * them into metric data in a CloudWatch metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MetricFilter implements StructuredPojo, ToCopyableBuilder<MetricFilter.Builder, MetricFilter> {
    private final String filterName;

    private final String filterPattern;

    private final List<MetricTransformation> metricTransformations;

    private final Long creationTime;

    private final String logGroupName;

    private MetricFilter(BuilderImpl builder) {
        this.filterName = builder.filterName;
        this.filterPattern = builder.filterPattern;
        this.metricTransformations = builder.metricTransformations;
        this.creationTime = builder.creationTime;
        this.logGroupName = builder.logGroupName;
    }

    /**
     * <p>
     * The name of the metric filter.
     * </p>
     * 
     * @return The name of the metric filter.
     */
    public String filterName() {
        return filterName;
    }

    /**
     *
     * @return
     */
    public String filterPattern() {
        return filterPattern;
    }

    /**
     * <p>
     * The metric transformations.
     * </p>
     * 
     * @return The metric transformations.
     */
    public List<MetricTransformation> metricTransformations() {
        return metricTransformations;
    }

    /**
     * <p>
     * The creation time of the metric filter, expressed as the number of milliseconds since Jan 1, 1970 00:00:00 UTC.
     * </p>
     * 
     * @return The creation time of the metric filter, expressed as the number of milliseconds since Jan 1, 1970
     *         00:00:00 UTC.
     */
    public Long creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public String logGroupName() {
        return logGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filterName() == null) ? 0 : filterName().hashCode());
        hashCode = 31 * hashCode + ((filterPattern() == null) ? 0 : filterPattern().hashCode());
        hashCode = 31 * hashCode + ((metricTransformations() == null) ? 0 : metricTransformations().hashCode());
        hashCode = 31 * hashCode + ((creationTime() == null) ? 0 : creationTime().hashCode());
        hashCode = 31 * hashCode + ((logGroupName() == null) ? 0 : logGroupName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricFilter)) {
            return false;
        }
        MetricFilter other = (MetricFilter) obj;
        if (other.filterName() == null ^ this.filterName() == null) {
            return false;
        }
        if (other.filterName() != null && !other.filterName().equals(this.filterName())) {
            return false;
        }
        if (other.filterPattern() == null ^ this.filterPattern() == null) {
            return false;
        }
        if (other.filterPattern() != null && !other.filterPattern().equals(this.filterPattern())) {
            return false;
        }
        if (other.metricTransformations() == null ^ this.metricTransformations() == null) {
            return false;
        }
        if (other.metricTransformations() != null && !other.metricTransformations().equals(this.metricTransformations())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filterName() != null) {
            sb.append("FilterName: ").append(filterName()).append(",");
        }
        if (filterPattern() != null) {
            sb.append("FilterPattern: ").append(filterPattern()).append(",");
        }
        if (metricTransformations() != null) {
            sb.append("MetricTransformations: ").append(metricTransformations()).append(",");
        }
        if (creationTime() != null) {
            sb.append("CreationTime: ").append(creationTime()).append(",");
        }
        if (logGroupName() != null) {
            sb.append("LogGroupName: ").append(logGroupName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MetricFilter> {
        /**
         * <p>
         * The name of the metric filter.
         * </p>
         * 
         * @param filterName
         *        The name of the metric filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterName(String filterName);

        /**
         *
         * @param filterPattern
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterPattern(String filterPattern);

        /**
         * <p>
         * The metric transformations.
         * </p>
         * 
         * @param metricTransformations
         *        The metric transformations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricTransformations(Collection<MetricTransformation> metricTransformations);

        /**
         * <p>
         * The metric transformations.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setMetricTransformations(java.util.Collection)} or
         * {@link #withMetricTransformations(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param metricTransformations
         *        The metric transformations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricTransformations(MetricTransformation... metricTransformations);

        /**
         * <p>
         * The creation time of the metric filter, expressed as the number of milliseconds since Jan 1, 1970 00:00:00
         * UTC.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the metric filter, expressed as the number of milliseconds since Jan 1, 1970
         *        00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Long creationTime);

        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);
    }

    private static final class BuilderImpl implements Builder {
        private String filterName;

        private String filterPattern;

        private List<MetricTransformation> metricTransformations = new SdkInternalList<>();

        private Long creationTime;

        private String logGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricFilter model) {
            setFilterName(model.filterName);
            setFilterPattern(model.filterPattern);
            setMetricTransformations(model.metricTransformations);
            setCreationTime(model.creationTime);
            setLogGroupName(model.logGroupName);
        }

        public final String getFilterName() {
            return filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        public final String getFilterPattern() {
            return filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        public final Collection<MetricTransformation> getMetricTransformations() {
            return metricTransformations;
        }

        @Override
        public final Builder metricTransformations(Collection<MetricTransformation> metricTransformations) {
            this.metricTransformations = MetricTransformationsCopier.copy(metricTransformations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricTransformations(MetricTransformation... metricTransformations) {
            if (this.metricTransformations == null) {
                this.metricTransformations = new SdkInternalList<>(metricTransformations.length);
            }
            for (MetricTransformation e : metricTransformations) {
                this.metricTransformations.add(e);
            }
            return this;
        }

        public final void setMetricTransformations(Collection<MetricTransformation> metricTransformations) {
            this.metricTransformations = MetricTransformationsCopier.copy(metricTransformations);
        }

        @SafeVarargs
        public final void setMetricTransformations(MetricTransformation... metricTransformations) {
            if (this.metricTransformations == null) {
                this.metricTransformations = new SdkInternalList<>(metricTransformations.length);
            }
            for (MetricTransformation e : metricTransformations) {
                this.metricTransformations.add(e);
            }
        }

        public final Long getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public MetricFilter build() {
            return new MetricFilter(this);
        }
    }
}
