/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.services.cloudwatchlogs.transform.MetricFilterMatchRecordMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a matched event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MetricFilterMatchRecord implements StructuredPojo,
        ToCopyableBuilder<MetricFilterMatchRecord.Builder, MetricFilterMatchRecord> {
    private final Long eventNumber;

    private final String eventMessage;

    private final Map<String, String> extractedValues;

    private MetricFilterMatchRecord(BuilderImpl builder) {
        this.eventNumber = builder.eventNumber;
        this.eventMessage = builder.eventMessage;
        this.extractedValues = builder.extractedValues;
    }

    /**
     * <p>
     * The event number.
     * </p>
     * 
     * @return The event number.
     */
    public Long eventNumber() {
        return eventNumber;
    }

    /**
     * <p>
     * The raw event data.
     * </p>
     * 
     * @return The raw event data.
     */
    public String eventMessage() {
        return eventMessage;
    }

    /**
     * <p>
     * The values extracted from the event data by the filter.
     * </p>
     * 
     * @return The values extracted from the event data by the filter.
     */
    public Map<String, String> extractedValues() {
        return extractedValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((eventNumber() == null) ? 0 : eventNumber().hashCode());
        hashCode = 31 * hashCode + ((eventMessage() == null) ? 0 : eventMessage().hashCode());
        hashCode = 31 * hashCode + ((extractedValues() == null) ? 0 : extractedValues().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricFilterMatchRecord)) {
            return false;
        }
        MetricFilterMatchRecord other = (MetricFilterMatchRecord) obj;
        if (other.eventNumber() == null ^ this.eventNumber() == null) {
            return false;
        }
        if (other.eventNumber() != null && !other.eventNumber().equals(this.eventNumber())) {
            return false;
        }
        if (other.eventMessage() == null ^ this.eventMessage() == null) {
            return false;
        }
        if (other.eventMessage() != null && !other.eventMessage().equals(this.eventMessage())) {
            return false;
        }
        if (other.extractedValues() == null ^ this.extractedValues() == null) {
            return false;
        }
        if (other.extractedValues() != null && !other.extractedValues().equals(this.extractedValues())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (eventNumber() != null) {
            sb.append("EventNumber: ").append(eventNumber()).append(",");
        }
        if (eventMessage() != null) {
            sb.append("EventMessage: ").append(eventMessage()).append(",");
        }
        if (extractedValues() != null) {
            sb.append("ExtractedValues: ").append(extractedValues()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricFilterMatchRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MetricFilterMatchRecord> {
        /**
         * <p>
         * The event number.
         * </p>
         * 
         * @param eventNumber
         *        The event number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventNumber(Long eventNumber);

        /**
         * <p>
         * The raw event data.
         * </p>
         * 
         * @param eventMessage
         *        The raw event data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventMessage(String eventMessage);

        /**
         * <p>
         * The values extracted from the event data by the filter.
         * </p>
         * 
         * @param extractedValues
         *        The values extracted from the event data by the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extractedValues(Map<String, String> extractedValues);
    }

    private static final class BuilderImpl implements Builder {
        private Long eventNumber;

        private String eventMessage;

        private Map<String, String> extractedValues = new SdkInternalMap<>();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricFilterMatchRecord model) {
            setEventNumber(model.eventNumber);
            setEventMessage(model.eventMessage);
            setExtractedValues(model.extractedValues);
        }

        public final Long getEventNumber() {
            return eventNumber;
        }

        @Override
        public final Builder eventNumber(Long eventNumber) {
            this.eventNumber = eventNumber;
            return this;
        }

        public final void setEventNumber(Long eventNumber) {
            this.eventNumber = eventNumber;
        }

        public final String getEventMessage() {
            return eventMessage;
        }

        @Override
        public final Builder eventMessage(String eventMessage) {
            this.eventMessage = eventMessage;
            return this;
        }

        public final void setEventMessage(String eventMessage) {
            this.eventMessage = eventMessage;
        }

        public final Map<String, String> getExtractedValues() {
            return extractedValues;
        }

        @Override
        public final Builder extractedValues(Map<String, String> extractedValues) {
            this.extractedValues = ExtractedValuesCopier.copy(extractedValues);
            return this;
        }

        public final void setExtractedValues(Map<String, String> extractedValues) {
            this.extractedValues = ExtractedValuesCopier.copy(extractedValues);
        }

        @Override
        public MetricFilterMatchRecord build() {
            return new MetricFilterMatchRecord(this);
        }
    }
}
