/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.MetricTransformationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates how to transform ingested log events into metric data in a CloudWatch metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MetricTransformation implements StructuredPojo,
        ToCopyableBuilder<MetricTransformation.Builder, MetricTransformation> {
    private final String metricName;

    private final String metricNamespace;

    private final String metricValue;

    private final Double defaultValue;

    private MetricTransformation(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.metricNamespace = builder.metricNamespace;
        this.metricValue = builder.metricValue;
        this.defaultValue = builder.defaultValue;
    }

    /**
     * <p>
     * The name of the CloudWatch metric.
     * </p>
     * 
     * @return The name of the CloudWatch metric.
     */
    public String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The namespace of the CloudWatch metric.
     * </p>
     * 
     * @return The namespace of the CloudWatch metric.
     */
    public String metricNamespace() {
        return metricNamespace;
    }

    /**
     * <p>
     * The value to publish to the CloudWatch metric when a filter pattern matches a log event.
     * </p>
     * 
     * @return The value to publish to the CloudWatch metric when a filter pattern matches a log event.
     */
    public String metricValue() {
        return metricValue;
    }

    /**
     * <p>
     * (Optional) The value to emit when a filter pattern does not match a log event. This value can be null.
     * </p>
     * 
     * @return (Optional) The value to emit when a filter pattern does not match a log event. This value can be null.
     */
    public Double defaultValue() {
        return defaultValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((metricName() == null) ? 0 : metricName().hashCode());
        hashCode = 31 * hashCode + ((metricNamespace() == null) ? 0 : metricNamespace().hashCode());
        hashCode = 31 * hashCode + ((metricValue() == null) ? 0 : metricValue().hashCode());
        hashCode = 31 * hashCode + ((defaultValue() == null) ? 0 : defaultValue().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricTransformation)) {
            return false;
        }
        MetricTransformation other = (MetricTransformation) obj;
        if (other.metricName() == null ^ this.metricName() == null) {
            return false;
        }
        if (other.metricName() != null && !other.metricName().equals(this.metricName())) {
            return false;
        }
        if (other.metricNamespace() == null ^ this.metricNamespace() == null) {
            return false;
        }
        if (other.metricNamespace() != null && !other.metricNamespace().equals(this.metricNamespace())) {
            return false;
        }
        if (other.metricValue() == null ^ this.metricValue() == null) {
            return false;
        }
        if (other.metricValue() != null && !other.metricValue().equals(this.metricValue())) {
            return false;
        }
        if (other.defaultValue() == null ^ this.defaultValue() == null) {
            return false;
        }
        if (other.defaultValue() != null && !other.defaultValue().equals(this.defaultValue())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (metricName() != null) {
            sb.append("MetricName: ").append(metricName()).append(",");
        }
        if (metricNamespace() != null) {
            sb.append("MetricNamespace: ").append(metricNamespace()).append(",");
        }
        if (metricValue() != null) {
            sb.append("MetricValue: ").append(metricValue()).append(",");
        }
        if (defaultValue() != null) {
            sb.append("DefaultValue: ").append(defaultValue()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricTransformationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MetricTransformation> {
        /**
         * <p>
         * The name of the CloudWatch metric.
         * </p>
         * 
         * @param metricName
         *        The name of the CloudWatch metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The namespace of the CloudWatch metric.
         * </p>
         * 
         * @param metricNamespace
         *        The namespace of the CloudWatch metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricNamespace(String metricNamespace);

        /**
         * <p>
         * The value to publish to the CloudWatch metric when a filter pattern matches a log event.
         * </p>
         * 
         * @param metricValue
         *        The value to publish to the CloudWatch metric when a filter pattern matches a log event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricValue(String metricValue);

        /**
         * <p>
         * (Optional) The value to emit when a filter pattern does not match a log event. This value can be null.
         * </p>
         * 
         * @param defaultValue
         *        (Optional) The value to emit when a filter pattern does not match a log event. This value can be null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(Double defaultValue);
    }

    private static final class BuilderImpl implements Builder {
        private String metricName;

        private String metricNamespace;

        private String metricValue;

        private Double defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricTransformation model) {
            setMetricName(model.metricName);
            setMetricNamespace(model.metricNamespace);
            setMetricValue(model.metricValue);
            setDefaultValue(model.defaultValue);
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getMetricNamespace() {
            return metricNamespace;
        }

        @Override
        public final Builder metricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
            return this;
        }

        public final void setMetricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
        }

        public final String getMetricValue() {
            return metricValue;
        }

        @Override
        public final Builder metricValue(String metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        public final void setMetricValue(String metricValue) {
            this.metricValue = metricValue;
        }

        public final Double getDefaultValue() {
            return defaultValue;
        }

        @Override
        public final Builder defaultValue(Double defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(Double defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public MetricTransformation build() {
            return new MetricTransformation(this);
        }
    }
}
