/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutDestinationPolicyRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutDestinationPolicyRequest.Builder, PutDestinationPolicyRequest> {
    private final String destinationName;

    private final String accessPolicy;

    private PutDestinationPolicyRequest(BuilderImpl builder) {
        this.destinationName = builder.destinationName;
        this.accessPolicy = builder.accessPolicy;
    }

    /**
     * <p>
     * A name for an existing destination.
     * </p>
     * 
     * @return A name for an existing destination.
     */
    public String destinationName() {
        return destinationName;
    }

    /**
     * <p>
     * An IAM policy document that authorizes cross-account users to deliver their log events to the associated
     * destination.
     * </p>
     * 
     * @return An IAM policy document that authorizes cross-account users to deliver their log events to the associated
     *         destination.
     */
    public String accessPolicy() {
        return accessPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((destinationName() == null) ? 0 : destinationName().hashCode());
        hashCode = 31 * hashCode + ((accessPolicy() == null) ? 0 : accessPolicy().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDestinationPolicyRequest)) {
            return false;
        }
        PutDestinationPolicyRequest other = (PutDestinationPolicyRequest) obj;
        if (other.destinationName() == null ^ this.destinationName() == null) {
            return false;
        }
        if (other.destinationName() != null && !other.destinationName().equals(this.destinationName())) {
            return false;
        }
        if (other.accessPolicy() == null ^ this.accessPolicy() == null) {
            return false;
        }
        if (other.accessPolicy() != null && !other.accessPolicy().equals(this.accessPolicy())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (destinationName() != null) {
            sb.append("DestinationName: ").append(destinationName()).append(",");
        }
        if (accessPolicy() != null) {
            sb.append("AccessPolicy: ").append(accessPolicy()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutDestinationPolicyRequest> {
        /**
         * <p>
         * A name for an existing destination.
         * </p>
         * 
         * @param destinationName
         *        A name for an existing destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationName(String destinationName);

        /**
         * <p>
         * An IAM policy document that authorizes cross-account users to deliver their log events to the associated
         * destination.
         * </p>
         * 
         * @param accessPolicy
         *        An IAM policy document that authorizes cross-account users to deliver their log events to the
         *        associated destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicy(String accessPolicy);
    }

    private static final class BuilderImpl implements Builder {
        private String destinationName;

        private String accessPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDestinationPolicyRequest model) {
            setDestinationName(model.destinationName);
            setAccessPolicy(model.accessPolicy);
        }

        public final String getDestinationName() {
            return destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        public final String getAccessPolicy() {
            return accessPolicy;
        }

        @Override
        public final Builder accessPolicy(String accessPolicy) {
            this.accessPolicy = accessPolicy;
            return this;
        }

        public final void setAccessPolicy(String accessPolicy) {
            this.accessPolicy = accessPolicy;
        }

        @Override
        public PutDestinationPolicyRequest build() {
            return new PutDestinationPolicyRequest(this);
        }
    }
}
