/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutDestinationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutDestinationRequest.Builder, PutDestinationRequest> {
    private final String destinationName;

    private final String targetArn;

    private final String roleArn;

    private PutDestinationRequest(BuilderImpl builder) {
        this.destinationName = builder.destinationName;
        this.targetArn = builder.targetArn;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * A name for the destination.
     * </p>
     * 
     * @return A name for the destination.
     */
    public String destinationName() {
        return destinationName;
    }

    /**
     * <p>
     * The ARN of an Amazon Kinesis stream to deliver matching log events to.
     * </p>
     * 
     * @return The ARN of an Amazon Kinesis stream to deliver matching log events to.
     */
    public String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The ARN of an IAM role that grants CloudWatch Logs permissions to call Amazon Kinesis PutRecord on the
     * destination stream.
     * </p>
     * 
     * @return The ARN of an IAM role that grants CloudWatch Logs permissions to call Amazon Kinesis PutRecord on the
     *         destination stream.
     */
    public String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((destinationName() == null) ? 0 : destinationName().hashCode());
        hashCode = 31 * hashCode + ((targetArn() == null) ? 0 : targetArn().hashCode());
        hashCode = 31 * hashCode + ((roleArn() == null) ? 0 : roleArn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDestinationRequest)) {
            return false;
        }
        PutDestinationRequest other = (PutDestinationRequest) obj;
        if (other.destinationName() == null ^ this.destinationName() == null) {
            return false;
        }
        if (other.destinationName() != null && !other.destinationName().equals(this.destinationName())) {
            return false;
        }
        if (other.targetArn() == null ^ this.targetArn() == null) {
            return false;
        }
        if (other.targetArn() != null && !other.targetArn().equals(this.targetArn())) {
            return false;
        }
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        if (other.roleArn() != null && !other.roleArn().equals(this.roleArn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (destinationName() != null) {
            sb.append("DestinationName: ").append(destinationName()).append(",");
        }
        if (targetArn() != null) {
            sb.append("TargetArn: ").append(targetArn()).append(",");
        }
        if (roleArn() != null) {
            sb.append("RoleArn: ").append(roleArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutDestinationRequest> {
        /**
         * <p>
         * A name for the destination.
         * </p>
         * 
         * @param destinationName
         *        A name for the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationName(String destinationName);

        /**
         * <p>
         * The ARN of an Amazon Kinesis stream to deliver matching log events to.
         * </p>
         * 
         * @param targetArn
         *        The ARN of an Amazon Kinesis stream to deliver matching log events to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The ARN of an IAM role that grants CloudWatch Logs permissions to call Amazon Kinesis PutRecord on the
         * destination stream.
         * </p>
         * 
         * @param roleArn
         *        The ARN of an IAM role that grants CloudWatch Logs permissions to call Amazon Kinesis PutRecord on the
         *        destination stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    private static final class BuilderImpl implements Builder {
        private String destinationName;

        private String targetArn;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDestinationRequest model) {
            setDestinationName(model.destinationName);
            setTargetArn(model.targetArn);
            setRoleArn(model.roleArn);
        }

        public final String getDestinationName() {
            return destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        public final String getTargetArn() {
            return targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public PutDestinationRequest build() {
            return new PutDestinationRequest(this);
        }
    }
}
