/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutDestinationResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<PutDestinationResponse.Builder, PutDestinationResponse> {
    private final Destination destination;

    private PutDestinationResponse(BuilderImpl builder) {
        this.destination = builder.destination;
    }

    /**
     * <p>
     * The destination.
     * </p>
     * 
     * @return The destination.
     */
    public Destination destination() {
        return destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((destination() == null) ? 0 : destination().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDestinationResponse)) {
            return false;
        }
        PutDestinationResponse other = (PutDestinationResponse) obj;
        if (other.destination() == null ^ this.destination() == null) {
            return false;
        }
        if (other.destination() != null && !other.destination().equals(this.destination())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (destination() != null) {
            sb.append("Destination: ").append(destination()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutDestinationResponse> {
        /**
         * <p>
         * The destination.
         * </p>
         * 
         * @param destination
         *        The destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Destination destination);
    }

    private static final class BuilderImpl implements Builder {
        private Destination destination;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDestinationResponse model) {
            setDestination(model.destination);
        }

        public final Destination getDestination() {
            return destination;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(Destination destination) {
            this.destination = destination;
        }

        @Override
        public PutDestinationResponse build() {
            return new PutDestinationResponse(this);
        }
    }
}
