/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutLogEventsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutLogEventsRequest.Builder, PutLogEventsRequest> {
    private final String logGroupName;

    private final String logStreamName;

    private final List<InputLogEvent> logEvents;

    private final String sequenceToken;

    private PutLogEventsRequest(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.logStreamName = builder.logStreamName;
        this.logEvents = builder.logEvents;
        this.sequenceToken = builder.sequenceToken;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * The name of the log stream.
     * </p>
     * 
     * @return The name of the log stream.
     */
    public String logStreamName() {
        return logStreamName;
    }

    /**
     * <p>
     * The log events.
     * </p>
     * 
     * @return The log events.
     */
    public List<InputLogEvent> logEvents() {
        return logEvents;
    }

    /**
     * <p>
     * The sequence token.
     * </p>
     * 
     * @return The sequence token.
     */
    public String sequenceToken() {
        return sequenceToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((logGroupName() == null) ? 0 : logGroupName().hashCode());
        hashCode = 31 * hashCode + ((logStreamName() == null) ? 0 : logStreamName().hashCode());
        hashCode = 31 * hashCode + ((logEvents() == null) ? 0 : logEvents().hashCode());
        hashCode = 31 * hashCode + ((sequenceToken() == null) ? 0 : sequenceToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutLogEventsRequest)) {
            return false;
        }
        PutLogEventsRequest other = (PutLogEventsRequest) obj;
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.logStreamName() == null ^ this.logStreamName() == null) {
            return false;
        }
        if (other.logStreamName() != null && !other.logStreamName().equals(this.logStreamName())) {
            return false;
        }
        if (other.logEvents() == null ^ this.logEvents() == null) {
            return false;
        }
        if (other.logEvents() != null && !other.logEvents().equals(this.logEvents())) {
            return false;
        }
        if (other.sequenceToken() == null ^ this.sequenceToken() == null) {
            return false;
        }
        if (other.sequenceToken() != null && !other.sequenceToken().equals(this.sequenceToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (logGroupName() != null) {
            sb.append("LogGroupName: ").append(logGroupName()).append(",");
        }
        if (logStreamName() != null) {
            sb.append("LogStreamName: ").append(logStreamName()).append(",");
        }
        if (logEvents() != null) {
            sb.append("LogEvents: ").append(logEvents()).append(",");
        }
        if (sequenceToken() != null) {
            sb.append("SequenceToken: ").append(sequenceToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutLogEventsRequest> {
        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The name of the log stream.
         * </p>
         * 
         * @param logStreamName
         *        The name of the log stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamName(String logStreamName);

        /**
         * <p>
         * The log events.
         * </p>
         * 
         * @param logEvents
         *        The log events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logEvents(Collection<InputLogEvent> logEvents);

        /**
         * <p>
         * The log events.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setLogEvents(java.util.Collection)} or {@link #withLogEvents(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param logEvents
         *        The log events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logEvents(InputLogEvent... logEvents);

        /**
         * <p>
         * The sequence token.
         * </p>
         * 
         * @param sequenceToken
         *        The sequence token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceToken(String sequenceToken);
    }

    private static final class BuilderImpl implements Builder {
        private String logGroupName;

        private String logStreamName;

        private List<InputLogEvent> logEvents = new SdkInternalList<>();

        private String sequenceToken;

        private BuilderImpl() {
        }

        private BuilderImpl(PutLogEventsRequest model) {
            setLogGroupName(model.logGroupName);
            setLogStreamName(model.logStreamName);
            setLogEvents(model.logEvents);
            setSequenceToken(model.sequenceToken);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getLogStreamName() {
            return logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        public final Collection<InputLogEvent> getLogEvents() {
            return logEvents;
        }

        @Override
        public final Builder logEvents(Collection<InputLogEvent> logEvents) {
            this.logEvents = InputLogEventsCopier.copy(logEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logEvents(InputLogEvent... logEvents) {
            if (this.logEvents == null) {
                this.logEvents = new SdkInternalList<>(logEvents.length);
            }
            for (InputLogEvent e : logEvents) {
                this.logEvents.add(e);
            }
            return this;
        }

        public final void setLogEvents(Collection<InputLogEvent> logEvents) {
            this.logEvents = InputLogEventsCopier.copy(logEvents);
        }

        @SafeVarargs
        public final void setLogEvents(InputLogEvent... logEvents) {
            if (this.logEvents == null) {
                this.logEvents = new SdkInternalList<>(logEvents.length);
            }
            for (InputLogEvent e : logEvents) {
                this.logEvents.add(e);
            }
        }

        public final String getSequenceToken() {
            return sequenceToken;
        }

        @Override
        public final Builder sequenceToken(String sequenceToken) {
            this.sequenceToken = sequenceToken;
            return this;
        }

        public final void setSequenceToken(String sequenceToken) {
            this.sequenceToken = sequenceToken;
        }

        @Override
        public PutLogEventsRequest build() {
            return new PutLogEventsRequest(this);
        }
    }
}
