/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutLogEventsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<PutLogEventsResponse.Builder, PutLogEventsResponse> {
    private final String nextSequenceToken;

    private final RejectedLogEventsInfo rejectedLogEventsInfo;

    private PutLogEventsResponse(BuilderImpl builder) {
        this.nextSequenceToken = builder.nextSequenceToken;
        this.rejectedLogEventsInfo = builder.rejectedLogEventsInfo;
    }

    /**
     * <p>
     * The next sequence token.
     * </p>
     * 
     * @return The next sequence token.
     */
    public String nextSequenceToken() {
        return nextSequenceToken;
    }

    /**
     * <p>
     * The rejected events.
     * </p>
     * 
     * @return The rejected events.
     */
    public RejectedLogEventsInfo rejectedLogEventsInfo() {
        return rejectedLogEventsInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((nextSequenceToken() == null) ? 0 : nextSequenceToken().hashCode());
        hashCode = 31 * hashCode + ((rejectedLogEventsInfo() == null) ? 0 : rejectedLogEventsInfo().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutLogEventsResponse)) {
            return false;
        }
        PutLogEventsResponse other = (PutLogEventsResponse) obj;
        if (other.nextSequenceToken() == null ^ this.nextSequenceToken() == null) {
            return false;
        }
        if (other.nextSequenceToken() != null && !other.nextSequenceToken().equals(this.nextSequenceToken())) {
            return false;
        }
        if (other.rejectedLogEventsInfo() == null ^ this.rejectedLogEventsInfo() == null) {
            return false;
        }
        if (other.rejectedLogEventsInfo() != null && !other.rejectedLogEventsInfo().equals(this.rejectedLogEventsInfo())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (nextSequenceToken() != null) {
            sb.append("NextSequenceToken: ").append(nextSequenceToken()).append(",");
        }
        if (rejectedLogEventsInfo() != null) {
            sb.append("RejectedLogEventsInfo: ").append(rejectedLogEventsInfo()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutLogEventsResponse> {
        /**
         * <p>
         * The next sequence token.
         * </p>
         * 
         * @param nextSequenceToken
         *        The next sequence token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextSequenceToken(String nextSequenceToken);

        /**
         * <p>
         * The rejected events.
         * </p>
         * 
         * @param rejectedLogEventsInfo
         *        The rejected events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectedLogEventsInfo(RejectedLogEventsInfo rejectedLogEventsInfo);
    }

    private static final class BuilderImpl implements Builder {
        private String nextSequenceToken;

        private RejectedLogEventsInfo rejectedLogEventsInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(PutLogEventsResponse model) {
            setNextSequenceToken(model.nextSequenceToken);
            setRejectedLogEventsInfo(model.rejectedLogEventsInfo);
        }

        public final String getNextSequenceToken() {
            return nextSequenceToken;
        }

        @Override
        public final Builder nextSequenceToken(String nextSequenceToken) {
            this.nextSequenceToken = nextSequenceToken;
            return this;
        }

        public final void setNextSequenceToken(String nextSequenceToken) {
            this.nextSequenceToken = nextSequenceToken;
        }

        public final RejectedLogEventsInfo getRejectedLogEventsInfo() {
            return rejectedLogEventsInfo;
        }

        @Override
        public final Builder rejectedLogEventsInfo(RejectedLogEventsInfo rejectedLogEventsInfo) {
            this.rejectedLogEventsInfo = rejectedLogEventsInfo;
            return this;
        }

        public final void setRejectedLogEventsInfo(RejectedLogEventsInfo rejectedLogEventsInfo) {
            this.rejectedLogEventsInfo = rejectedLogEventsInfo;
        }

        @Override
        public PutLogEventsResponse build() {
            return new PutLogEventsResponse(this);
        }
    }
}
