/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutSubscriptionFilterRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutSubscriptionFilterRequest.Builder, PutSubscriptionFilterRequest> {
    private final String logGroupName;

    private final String filterName;

    private final String filterPattern;

    private final String destinationArn;

    private final String roleArn;

    private final String distribution;

    private PutSubscriptionFilterRequest(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.filterName = builder.filterName;
        this.filterPattern = builder.filterPattern;
        this.destinationArn = builder.destinationArn;
        this.roleArn = builder.roleArn;
        this.distribution = builder.distribution;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * A name for the subscription filter. If you are updating an existing filter, you must specify the correct name in
     * <code>filterName</code>. Otherwise, the call will fail because you cannot associate a second filter with a log
     * group. To find the name of the filter currently associated with a log group, use
     * <a>DescribeSubscriptionFilters</a>.
     * </p>
     * 
     * @return A name for the subscription filter. If you are updating an existing filter, you must specify the correct
     *         name in <code>filterName</code>. Otherwise, the call will fail because you cannot associate a second
     *         filter with a log group. To find the name of the filter currently associated with a log group, use
     *         <a>DescribeSubscriptionFilters</a>.
     */
    public String filterName() {
        return filterName;
    }

    /**
     * <p>
     * A filter pattern for subscribing to a filtered stream of log events.
     * </p>
     * 
     * @return A filter pattern for subscribing to a filtered stream of log events.
     */
    public String filterPattern() {
        return filterPattern;
    }

    /**
     * <p>
     * The ARN of the destination to deliver matching log events to. Currently, the supported destinations are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An Amazon Kinesis stream belonging to the same account as the subscription filter, for same-account delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * A logical destination (specified using an ARN) belonging to a different account, for cross-account delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * An Amazon Kinesis Firehose stream belonging to the same account as the subscription filter, for same-account
     * delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * An AWS Lambda function belonging to the same account as the subscription filter, for same-account delivery.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The ARN of the destination to deliver matching log events to. Currently, the supported destinations
     *         are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         An Amazon Kinesis stream belonging to the same account as the subscription filter, for same-account
     *         delivery.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A logical destination (specified using an ARN) belonging to a different account, for cross-account
     *         delivery.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An Amazon Kinesis Firehose stream belonging to the same account as the subscription filter, for
     *         same-account delivery.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An AWS Lambda function belonging to the same account as the subscription filter, for same-account
     *         delivery.
     *         </p>
     *         </li>
     */
    public String destinationArn() {
        return destinationArn;
    }

    /**
     * <p>
     * The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the destination
     * stream. You don't need to provide the ARN when you are working with a logical destination for cross-account
     * delivery.
     * </p>
     * 
     * @return The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the
     *         destination stream. You don't need to provide the ARN when you are working with a logical destination for
     *         cross-account delivery.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The method used to distribute log data to the destination, when the destination is an Amazon Kinesis stream. By
     * default, log data is grouped by log stream. For a more even distribution, you can group log data randomly.
     * </p>
     * 
     * @return The method used to distribute log data to the destination, when the destination is an Amazon Kinesis
     *         stream. By default, log data is grouped by log stream. For a more even distribution, you can group log
     *         data randomly.
     * @see Distribution
     */
    public String distribution() {
        return distribution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((logGroupName() == null) ? 0 : logGroupName().hashCode());
        hashCode = 31 * hashCode + ((filterName() == null) ? 0 : filterName().hashCode());
        hashCode = 31 * hashCode + ((filterPattern() == null) ? 0 : filterPattern().hashCode());
        hashCode = 31 * hashCode + ((destinationArn() == null) ? 0 : destinationArn().hashCode());
        hashCode = 31 * hashCode + ((roleArn() == null) ? 0 : roleArn().hashCode());
        hashCode = 31 * hashCode + ((distribution() == null) ? 0 : distribution().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSubscriptionFilterRequest)) {
            return false;
        }
        PutSubscriptionFilterRequest other = (PutSubscriptionFilterRequest) obj;
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.filterName() == null ^ this.filterName() == null) {
            return false;
        }
        if (other.filterName() != null && !other.filterName().equals(this.filterName())) {
            return false;
        }
        if (other.filterPattern() == null ^ this.filterPattern() == null) {
            return false;
        }
        if (other.filterPattern() != null && !other.filterPattern().equals(this.filterPattern())) {
            return false;
        }
        if (other.destinationArn() == null ^ this.destinationArn() == null) {
            return false;
        }
        if (other.destinationArn() != null && !other.destinationArn().equals(this.destinationArn())) {
            return false;
        }
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        if (other.roleArn() != null && !other.roleArn().equals(this.roleArn())) {
            return false;
        }
        if (other.distribution() == null ^ this.distribution() == null) {
            return false;
        }
        if (other.distribution() != null && !other.distribution().equals(this.distribution())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (logGroupName() != null) {
            sb.append("LogGroupName: ").append(logGroupName()).append(",");
        }
        if (filterName() != null) {
            sb.append("FilterName: ").append(filterName()).append(",");
        }
        if (filterPattern() != null) {
            sb.append("FilterPattern: ").append(filterPattern()).append(",");
        }
        if (destinationArn() != null) {
            sb.append("DestinationArn: ").append(destinationArn()).append(",");
        }
        if (roleArn() != null) {
            sb.append("RoleArn: ").append(roleArn()).append(",");
        }
        if (distribution() != null) {
            sb.append("Distribution: ").append(distribution()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutSubscriptionFilterRequest> {
        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * A name for the subscription filter. If you are updating an existing filter, you must specify the correct name
         * in <code>filterName</code>. Otherwise, the call will fail because you cannot associate a second filter with a
         * log group. To find the name of the filter currently associated with a log group, use
         * <a>DescribeSubscriptionFilters</a>.
         * </p>
         * 
         * @param filterName
         *        A name for the subscription filter. If you are updating an existing filter, you must specify the
         *        correct name in <code>filterName</code>. Otherwise, the call will fail because you cannot associate a
         *        second filter with a log group. To find the name of the filter currently associated with a log group,
         *        use <a>DescribeSubscriptionFilters</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterName(String filterName);

        /**
         * <p>
         * A filter pattern for subscribing to a filtered stream of log events.
         * </p>
         * 
         * @param filterPattern
         *        A filter pattern for subscribing to a filtered stream of log events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterPattern(String filterPattern);

        /**
         * <p>
         * The ARN of the destination to deliver matching log events to. Currently, the supported destinations are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * An Amazon Kinesis stream belonging to the same account as the subscription filter, for same-account delivery.
         * </p>
         * </li>
         * <li>
         * <p>
         * A logical destination (specified using an ARN) belonging to a different account, for cross-account delivery.
         * </p>
         * </li>
         * <li>
         * <p>
         * An Amazon Kinesis Firehose stream belonging to the same account as the subscription filter, for same-account
         * delivery.
         * </p>
         * </li>
         * <li>
         * <p>
         * An AWS Lambda function belonging to the same account as the subscription filter, for same-account delivery.
         * </p>
         * </li>
         * </ul>
         * 
         * @param destinationArn
         *        The ARN of the destination to deliver matching log events to. Currently, the supported destinations
         *        are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        An Amazon Kinesis stream belonging to the same account as the subscription filter, for same-account
         *        delivery.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A logical destination (specified using an ARN) belonging to a different account, for cross-account
         *        delivery.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An Amazon Kinesis Firehose stream belonging to the same account as the subscription filter, for
         *        same-account delivery.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An AWS Lambda function belonging to the same account as the subscription filter, for same-account
         *        delivery.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);

        /**
         * <p>
         * The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the
         * destination stream. You don't need to provide the ARN when you are working with a logical destination for
         * cross-account delivery.
         * </p>
         * 
         * @param roleArn
         *        The ARN of an IAM role that grants CloudWatch Logs permissions to deliver ingested log events to the
         *        destination stream. You don't need to provide the ARN when you are working with a logical destination
         *        for cross-account delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The method used to distribute log data to the destination, when the destination is an Amazon Kinesis stream.
         * By default, log data is grouped by log stream. For a more even distribution, you can group log data randomly.
         * </p>
         * 
         * @param distribution
         *        The method used to distribute log data to the destination, when the destination is an Amazon Kinesis
         *        stream. By default, log data is grouped by log stream. For a more even distribution, you can group log
         *        data randomly.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Distribution
         */
        Builder distribution(String distribution);

        /**
         * <p>
         * The method used to distribute log data to the destination, when the destination is an Amazon Kinesis stream.
         * By default, log data is grouped by log stream. For a more even distribution, you can group log data randomly.
         * </p>
         * 
         * @param distribution
         *        The method used to distribute log data to the destination, when the destination is an Amazon Kinesis
         *        stream. By default, log data is grouped by log stream. For a more even distribution, you can group log
         *        data randomly.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Distribution
         */
        Builder distribution(Distribution distribution);
    }

    private static final class BuilderImpl implements Builder {
        private String logGroupName;

        private String filterName;

        private String filterPattern;

        private String destinationArn;

        private String roleArn;

        private String distribution;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSubscriptionFilterRequest model) {
            setLogGroupName(model.logGroupName);
            setFilterName(model.filterName);
            setFilterPattern(model.filterPattern);
            setDestinationArn(model.destinationArn);
            setRoleArn(model.roleArn);
            setDistribution(model.distribution);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getFilterName() {
            return filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        public final String getFilterPattern() {
            return filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getDistribution() {
            return distribution;
        }

        @Override
        public final Builder distribution(String distribution) {
            this.distribution = distribution;
            return this;
        }

        @Override
        public final Builder distribution(Distribution distribution) {
            this.distribution(distribution.toString());
            return this;
        }

        public final void setDistribution(String distribution) {
            this.distribution = distribution;
        }

        public final void setDistribution(Distribution distribution) {
            this.distribution(distribution.toString());
        }

        @Override
        public PutSubscriptionFilterRequest build() {
            return new PutSubscriptionFilterRequest(this);
        }
    }
}
