/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.RejectedLogEventsInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the rejected events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RejectedLogEventsInfo implements StructuredPojo,
        ToCopyableBuilder<RejectedLogEventsInfo.Builder, RejectedLogEventsInfo> {
    private final Integer tooNewLogEventStartIndex;

    private final Integer tooOldLogEventEndIndex;

    private final Integer expiredLogEventEndIndex;

    private RejectedLogEventsInfo(BuilderImpl builder) {
        this.tooNewLogEventStartIndex = builder.tooNewLogEventStartIndex;
        this.tooOldLogEventEndIndex = builder.tooOldLogEventEndIndex;
        this.expiredLogEventEndIndex = builder.expiredLogEventEndIndex;
    }

    /**
     * <p>
     * The log events that are too new.
     * </p>
     * 
     * @return The log events that are too new.
     */
    public Integer tooNewLogEventStartIndex() {
        return tooNewLogEventStartIndex;
    }

    /**
     * <p>
     * The log events that are too old.
     * </p>
     * 
     * @return The log events that are too old.
     */
    public Integer tooOldLogEventEndIndex() {
        return tooOldLogEventEndIndex;
    }

    /**
     * <p>
     * The expired log events.
     * </p>
     * 
     * @return The expired log events.
     */
    public Integer expiredLogEventEndIndex() {
        return expiredLogEventEndIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((tooNewLogEventStartIndex() == null) ? 0 : tooNewLogEventStartIndex().hashCode());
        hashCode = 31 * hashCode + ((tooOldLogEventEndIndex() == null) ? 0 : tooOldLogEventEndIndex().hashCode());
        hashCode = 31 * hashCode + ((expiredLogEventEndIndex() == null) ? 0 : expiredLogEventEndIndex().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectedLogEventsInfo)) {
            return false;
        }
        RejectedLogEventsInfo other = (RejectedLogEventsInfo) obj;
        if (other.tooNewLogEventStartIndex() == null ^ this.tooNewLogEventStartIndex() == null) {
            return false;
        }
        if (other.tooNewLogEventStartIndex() != null && !other.tooNewLogEventStartIndex().equals(this.tooNewLogEventStartIndex())) {
            return false;
        }
        if (other.tooOldLogEventEndIndex() == null ^ this.tooOldLogEventEndIndex() == null) {
            return false;
        }
        if (other.tooOldLogEventEndIndex() != null && !other.tooOldLogEventEndIndex().equals(this.tooOldLogEventEndIndex())) {
            return false;
        }
        if (other.expiredLogEventEndIndex() == null ^ this.expiredLogEventEndIndex() == null) {
            return false;
        }
        if (other.expiredLogEventEndIndex() != null && !other.expiredLogEventEndIndex().equals(this.expiredLogEventEndIndex())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (tooNewLogEventStartIndex() != null) {
            sb.append("TooNewLogEventStartIndex: ").append(tooNewLogEventStartIndex()).append(",");
        }
        if (tooOldLogEventEndIndex() != null) {
            sb.append("TooOldLogEventEndIndex: ").append(tooOldLogEventEndIndex()).append(",");
        }
        if (expiredLogEventEndIndex() != null) {
            sb.append("ExpiredLogEventEndIndex: ").append(expiredLogEventEndIndex()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RejectedLogEventsInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RejectedLogEventsInfo> {
        /**
         * <p>
         * The log events that are too new.
         * </p>
         * 
         * @param tooNewLogEventStartIndex
         *        The log events that are too new.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooNewLogEventStartIndex(Integer tooNewLogEventStartIndex);

        /**
         * <p>
         * The log events that are too old.
         * </p>
         * 
         * @param tooOldLogEventEndIndex
         *        The log events that are too old.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooOldLogEventEndIndex(Integer tooOldLogEventEndIndex);

        /**
         * <p>
         * The expired log events.
         * </p>
         * 
         * @param expiredLogEventEndIndex
         *        The expired log events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiredLogEventEndIndex(Integer expiredLogEventEndIndex);
    }

    private static final class BuilderImpl implements Builder {
        private Integer tooNewLogEventStartIndex;

        private Integer tooOldLogEventEndIndex;

        private Integer expiredLogEventEndIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectedLogEventsInfo model) {
            setTooNewLogEventStartIndex(model.tooNewLogEventStartIndex);
            setTooOldLogEventEndIndex(model.tooOldLogEventEndIndex);
            setExpiredLogEventEndIndex(model.expiredLogEventEndIndex);
        }

        public final Integer getTooNewLogEventStartIndex() {
            return tooNewLogEventStartIndex;
        }

        @Override
        public final Builder tooNewLogEventStartIndex(Integer tooNewLogEventStartIndex) {
            this.tooNewLogEventStartIndex = tooNewLogEventStartIndex;
            return this;
        }

        public final void setTooNewLogEventStartIndex(Integer tooNewLogEventStartIndex) {
            this.tooNewLogEventStartIndex = tooNewLogEventStartIndex;
        }

        public final Integer getTooOldLogEventEndIndex() {
            return tooOldLogEventEndIndex;
        }

        @Override
        public final Builder tooOldLogEventEndIndex(Integer tooOldLogEventEndIndex) {
            this.tooOldLogEventEndIndex = tooOldLogEventEndIndex;
            return this;
        }

        public final void setTooOldLogEventEndIndex(Integer tooOldLogEventEndIndex) {
            this.tooOldLogEventEndIndex = tooOldLogEventEndIndex;
        }

        public final Integer getExpiredLogEventEndIndex() {
            return expiredLogEventEndIndex;
        }

        @Override
        public final Builder expiredLogEventEndIndex(Integer expiredLogEventEndIndex) {
            this.expiredLogEventEndIndex = expiredLogEventEndIndex;
            return this;
        }

        public final void setExpiredLogEventEndIndex(Integer expiredLogEventEndIndex) {
            this.expiredLogEventEndIndex = expiredLogEventEndIndex;
        }

        @Override
        public RejectedLogEventsInfo build() {
            return new RejectedLogEventsInfo(this);
        }
    }
}
