/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.SearchedLogStreamMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the search status of a log stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SearchedLogStream implements StructuredPojo, ToCopyableBuilder<SearchedLogStream.Builder, SearchedLogStream> {
    private final String logStreamName;

    private final Boolean searchedCompletely;

    private SearchedLogStream(BuilderImpl builder) {
        this.logStreamName = builder.logStreamName;
        this.searchedCompletely = builder.searchedCompletely;
    }

    /**
     * <p>
     * The name of the log stream.
     * </p>
     * 
     * @return The name of the log stream.
     */
    public String logStreamName() {
        return logStreamName;
    }

    /**
     * <p>
     * Indicates whether all the events in this log stream were searched.
     * </p>
     * 
     * @return Indicates whether all the events in this log stream were searched.
     */
    public Boolean searchedCompletely() {
        return searchedCompletely;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((logStreamName() == null) ? 0 : logStreamName().hashCode());
        hashCode = 31 * hashCode + ((searchedCompletely() == null) ? 0 : searchedCompletely().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchedLogStream)) {
            return false;
        }
        SearchedLogStream other = (SearchedLogStream) obj;
        if (other.logStreamName() == null ^ this.logStreamName() == null) {
            return false;
        }
        if (other.logStreamName() != null && !other.logStreamName().equals(this.logStreamName())) {
            return false;
        }
        if (other.searchedCompletely() == null ^ this.searchedCompletely() == null) {
            return false;
        }
        if (other.searchedCompletely() != null && !other.searchedCompletely().equals(this.searchedCompletely())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (logStreamName() != null) {
            sb.append("LogStreamName: ").append(logStreamName()).append(",");
        }
        if (searchedCompletely() != null) {
            sb.append("SearchedCompletely: ").append(searchedCompletely()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SearchedLogStreamMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SearchedLogStream> {
        /**
         * <p>
         * The name of the log stream.
         * </p>
         * 
         * @param logStreamName
         *        The name of the log stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamName(String logStreamName);

        /**
         * <p>
         * Indicates whether all the events in this log stream were searched.
         * </p>
         * 
         * @param searchedCompletely
         *        Indicates whether all the events in this log stream were searched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchedCompletely(Boolean searchedCompletely);
    }

    private static final class BuilderImpl implements Builder {
        private String logStreamName;

        private Boolean searchedCompletely;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchedLogStream model) {
            setLogStreamName(model.logStreamName);
            setSearchedCompletely(model.searchedCompletely);
        }

        public final String getLogStreamName() {
            return logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        public final Boolean getSearchedCompletely() {
            return searchedCompletely;
        }

        @Override
        public final Builder searchedCompletely(Boolean searchedCompletely) {
            this.searchedCompletely = searchedCompletely;
            return this;
        }

        public final void setSearchedCompletely(Boolean searchedCompletely) {
            this.searchedCompletely = searchedCompletely;
        }

        @Override
        public SearchedLogStream build() {
            return new SearchedLogStream(this);
        }
    }
}
