/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchlogs.transform.SubscriptionFilterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a subscription filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SubscriptionFilter implements StructuredPojo, ToCopyableBuilder<SubscriptionFilter.Builder, SubscriptionFilter> {
    private final String filterName;

    private final String logGroupName;

    private final String filterPattern;

    private final String destinationArn;

    private final String roleArn;

    private final String distribution;

    private final Long creationTime;

    private SubscriptionFilter(BuilderImpl builder) {
        this.filterName = builder.filterName;
        this.logGroupName = builder.logGroupName;
        this.filterPattern = builder.filterPattern;
        this.destinationArn = builder.destinationArn;
        this.roleArn = builder.roleArn;
        this.distribution = builder.distribution;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The name of the subscription filter.
     * </p>
     * 
     * @return The name of the subscription filter.
     */
    public String filterName() {
        return filterName;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public String logGroupName() {
        return logGroupName;
    }

    /**
     *
     * @return
     */
    public String filterPattern() {
        return filterPattern;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the destination.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the destination.
     */
    public String destinationArn() {
        return destinationArn;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The method used to distribute log data to the destination, when the destination is an Amazon Kinesis stream.
     * </p>
     * 
     * @return The method used to distribute log data to the destination, when the destination is an Amazon Kinesis
     *         stream.
     * @see Distribution
     */
    public String distribution() {
        return distribution;
    }

    /**
     * <p>
     * The creation time of the subscription filter, expressed as the number of milliseconds since Jan 1, 1970 00:00:00
     * UTC.
     * </p>
     * 
     * @return The creation time of the subscription filter, expressed as the number of milliseconds since Jan 1, 1970
     *         00:00:00 UTC.
     */
    public Long creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filterName() == null) ? 0 : filterName().hashCode());
        hashCode = 31 * hashCode + ((logGroupName() == null) ? 0 : logGroupName().hashCode());
        hashCode = 31 * hashCode + ((filterPattern() == null) ? 0 : filterPattern().hashCode());
        hashCode = 31 * hashCode + ((destinationArn() == null) ? 0 : destinationArn().hashCode());
        hashCode = 31 * hashCode + ((roleArn() == null) ? 0 : roleArn().hashCode());
        hashCode = 31 * hashCode + ((distribution() == null) ? 0 : distribution().hashCode());
        hashCode = 31 * hashCode + ((creationTime() == null) ? 0 : creationTime().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscriptionFilter)) {
            return false;
        }
        SubscriptionFilter other = (SubscriptionFilter) obj;
        if (other.filterName() == null ^ this.filterName() == null) {
            return false;
        }
        if (other.filterName() != null && !other.filterName().equals(this.filterName())) {
            return false;
        }
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.filterPattern() == null ^ this.filterPattern() == null) {
            return false;
        }
        if (other.filterPattern() != null && !other.filterPattern().equals(this.filterPattern())) {
            return false;
        }
        if (other.destinationArn() == null ^ this.destinationArn() == null) {
            return false;
        }
        if (other.destinationArn() != null && !other.destinationArn().equals(this.destinationArn())) {
            return false;
        }
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        if (other.roleArn() != null && !other.roleArn().equals(this.roleArn())) {
            return false;
        }
        if (other.distribution() == null ^ this.distribution() == null) {
            return false;
        }
        if (other.distribution() != null && !other.distribution().equals(this.distribution())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filterName() != null) {
            sb.append("FilterName: ").append(filterName()).append(",");
        }
        if (logGroupName() != null) {
            sb.append("LogGroupName: ").append(logGroupName()).append(",");
        }
        if (filterPattern() != null) {
            sb.append("FilterPattern: ").append(filterPattern()).append(",");
        }
        if (destinationArn() != null) {
            sb.append("DestinationArn: ").append(destinationArn()).append(",");
        }
        if (roleArn() != null) {
            sb.append("RoleArn: ").append(roleArn()).append(",");
        }
        if (distribution() != null) {
            sb.append("Distribution: ").append(distribution()).append(",");
        }
        if (creationTime() != null) {
            sb.append("CreationTime: ").append(creationTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubscriptionFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SubscriptionFilter> {
        /**
         * <p>
         * The name of the subscription filter.
         * </p>
         * 
         * @param filterName
         *        The name of the subscription filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterName(String filterName);

        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         *
         * @param filterPattern
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterPattern(String filterPattern);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the destination.
         * </p>
         * 
         * @param destinationArn
         *        The Amazon Resource Name (ARN) of the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);

        /**
         * <p/>
         * 
         * @param roleArn
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The method used to distribute log data to the destination, when the destination is an Amazon Kinesis stream.
         * </p>
         * 
         * @param distribution
         *        The method used to distribute log data to the destination, when the destination is an Amazon Kinesis
         *        stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Distribution
         */
        Builder distribution(String distribution);

        /**
         * <p>
         * The method used to distribute log data to the destination, when the destination is an Amazon Kinesis stream.
         * </p>
         * 
         * @param distribution
         *        The method used to distribute log data to the destination, when the destination is an Amazon Kinesis
         *        stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Distribution
         */
        Builder distribution(Distribution distribution);

        /**
         * <p>
         * The creation time of the subscription filter, expressed as the number of milliseconds since Jan 1, 1970
         * 00:00:00 UTC.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the subscription filter, expressed as the number of milliseconds since Jan 1,
         *        1970 00:00:00 UTC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Long creationTime);
    }

    private static final class BuilderImpl implements Builder {
        private String filterName;

        private String logGroupName;

        private String filterPattern;

        private String destinationArn;

        private String roleArn;

        private String distribution;

        private Long creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscriptionFilter model) {
            setFilterName(model.filterName);
            setLogGroupName(model.logGroupName);
            setFilterPattern(model.filterPattern);
            setDestinationArn(model.destinationArn);
            setRoleArn(model.roleArn);
            setDistribution(model.distribution);
            setCreationTime(model.creationTime);
        }

        public final String getFilterName() {
            return filterName;
        }

        @Override
        public final Builder filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public final void setFilterName(String filterName) {
            this.filterName = filterName;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getFilterPattern() {
            return filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getDistribution() {
            return distribution;
        }

        @Override
        public final Builder distribution(String distribution) {
            this.distribution = distribution;
            return this;
        }

        @Override
        public final Builder distribution(Distribution distribution) {
            this.distribution(distribution.toString());
            return this;
        }

        public final void setDistribution(String distribution) {
            this.distribution = distribution;
        }

        public final void setDistribution(Distribution distribution) {
            this.distribution(distribution.toString());
        }

        public final Long getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public SubscriptionFilter build() {
            return new SubscriptionFilter(this);
        }
    }
}
