/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class TestMetricFilterRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<TestMetricFilterRequest.Builder, TestMetricFilterRequest> {
    private final String filterPattern;

    private final List<String> logEventMessages;

    private TestMetricFilterRequest(BuilderImpl builder) {
        this.filterPattern = builder.filterPattern;
        this.logEventMessages = builder.logEventMessages;
    }

    /**
     *
     * @return
     */
    public String filterPattern() {
        return filterPattern;
    }

    /**
     * <p>
     * The log event messages to test.
     * </p>
     * 
     * @return The log event messages to test.
     */
    public List<String> logEventMessages() {
        return logEventMessages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filterPattern() == null) ? 0 : filterPattern().hashCode());
        hashCode = 31 * hashCode + ((logEventMessages() == null) ? 0 : logEventMessages().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestMetricFilterRequest)) {
            return false;
        }
        TestMetricFilterRequest other = (TestMetricFilterRequest) obj;
        if (other.filterPattern() == null ^ this.filterPattern() == null) {
            return false;
        }
        if (other.filterPattern() != null && !other.filterPattern().equals(this.filterPattern())) {
            return false;
        }
        if (other.logEventMessages() == null ^ this.logEventMessages() == null) {
            return false;
        }
        if (other.logEventMessages() != null && !other.logEventMessages().equals(this.logEventMessages())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filterPattern() != null) {
            sb.append("FilterPattern: ").append(filterPattern()).append(",");
        }
        if (logEventMessages() != null) {
            sb.append("LogEventMessages: ").append(logEventMessages()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, TestMetricFilterRequest> {
        /**
         *
         * @param filterPattern
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterPattern(String filterPattern);

        /**
         * <p>
         * The log event messages to test.
         * </p>
         * 
         * @param logEventMessages
         *        The log event messages to test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logEventMessages(Collection<String> logEventMessages);

        /**
         * <p>
         * The log event messages to test.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setLogEventMessages(java.util.Collection)} or {@link #withLogEventMessages(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param logEventMessages
         *        The log event messages to test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logEventMessages(String... logEventMessages);
    }

    private static final class BuilderImpl implements Builder {
        private String filterPattern;

        private List<String> logEventMessages = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(TestMetricFilterRequest model) {
            setFilterPattern(model.filterPattern);
            setLogEventMessages(model.logEventMessages);
        }

        public final String getFilterPattern() {
            return filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        public final Collection<String> getLogEventMessages() {
            return logEventMessages;
        }

        @Override
        public final Builder logEventMessages(Collection<String> logEventMessages) {
            this.logEventMessages = TestEventMessagesCopier.copy(logEventMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logEventMessages(String... logEventMessages) {
            if (this.logEventMessages == null) {
                this.logEventMessages = new SdkInternalList<>(logEventMessages.length);
            }
            for (String e : logEventMessages) {
                this.logEventMessages.add(e);
            }
            return this;
        }

        public final void setLogEventMessages(Collection<String> logEventMessages) {
            this.logEventMessages = TestEventMessagesCopier.copy(logEventMessages);
        }

        @SafeVarargs
        public final void setLogEventMessages(String... logEventMessages) {
            if (this.logEventMessages == null) {
                this.logEventMessages = new SdkInternalList<>(logEventMessages.length);
            }
            for (String e : logEventMessages) {
                this.logEventMessages.add(e);
            }
        }

        @Override
        public TestMetricFilterRequest build() {
            return new TestMetricFilterRequest(this);
        }
    }
}
