/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class TestMetricFilterResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<TestMetricFilterResponse.Builder, TestMetricFilterResponse> {
    private final List<MetricFilterMatchRecord> matches;

    private TestMetricFilterResponse(BuilderImpl builder) {
        this.matches = builder.matches;
    }

    /**
     * <p>
     * The matched events.
     * </p>
     * 
     * @return The matched events.
     */
    public List<MetricFilterMatchRecord> matches() {
        return matches;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((matches() == null) ? 0 : matches().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestMetricFilterResponse)) {
            return false;
        }
        TestMetricFilterResponse other = (TestMetricFilterResponse) obj;
        if (other.matches() == null ^ this.matches() == null) {
            return false;
        }
        if (other.matches() != null && !other.matches().equals(this.matches())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (matches() != null) {
            sb.append("Matches: ").append(matches()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, TestMetricFilterResponse> {
        /**
         * <p>
         * The matched events.
         * </p>
         * 
         * @param matches
         *        The matched events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matches(Collection<MetricFilterMatchRecord> matches);

        /**
         * <p>
         * The matched events.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setMatches(java.util.Collection)} or {@link #withMatches(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param matches
         *        The matched events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matches(MetricFilterMatchRecord... matches);
    }

    private static final class BuilderImpl implements Builder {
        private List<MetricFilterMatchRecord> matches = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(TestMetricFilterResponse model) {
            setMatches(model.matches);
        }

        public final Collection<MetricFilterMatchRecord> getMatches() {
            return matches;
        }

        @Override
        public final Builder matches(Collection<MetricFilterMatchRecord> matches) {
            this.matches = MetricFilterMatchesCopier.copy(matches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matches(MetricFilterMatchRecord... matches) {
            if (this.matches == null) {
                this.matches = new SdkInternalList<>(matches.length);
            }
            for (MetricFilterMatchRecord e : matches) {
                this.matches.add(e);
            }
            return this;
        }

        public final void setMatches(Collection<MetricFilterMatchRecord> matches) {
            this.matches = MetricFilterMatchesCopier.copy(matches);
        }

        @SafeVarargs
        public final void setMatches(MetricFilterMatchRecord... matches) {
            if (this.matches == null) {
                this.matches = new SdkInternalList<>(matches.length);
            }
            for (MetricFilterMatchRecord e : matches) {
                this.matches.add(e);
            }
        }

        @Override
        public TestMetricFilterResponse build() {
            return new TestMetricFilterResponse(this);
        }
    }
}
