/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UntagLogGroupRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UntagLogGroupRequest.Builder, UntagLogGroupRequest> {
    private final String logGroupName;

    private final List<String> tags;

    private UntagLogGroupRequest(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * The tag keys. The corresponding tags are removed from the log group.
     * </p>
     * 
     * @return The tag keys. The corresponding tags are removed from the log group.
     */
    public List<String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((logGroupName() == null) ? 0 : logGroupName().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagLogGroupRequest)) {
            return false;
        }
        UntagLogGroupRequest other = (UntagLogGroupRequest) obj;
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (logGroupName() != null) {
            sb.append("LogGroupName: ").append(logGroupName()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UntagLogGroupRequest> {
        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The tag keys. The corresponding tags are removed from the log group.
         * </p>
         * 
         * @param tags
         *        The tag keys. The corresponding tags are removed from the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<String> tags);

        /**
         * <p>
         * The tag keys. The corresponding tags are removed from the log group.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
         * existing values.
         * </p>
         * 
         * @param tags
         *        The tag keys. The corresponding tags are removed from the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(String... tags);
    }

    private static final class BuilderImpl implements Builder {
        private String logGroupName;

        private List<String> tags = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(UntagLogGroupRequest model) {
            setLogGroupName(model.logGroupName);
            setTags(model.tags);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final Collection<String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<String> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(String... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList<>(tags.length);
            }
            for (String e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<String> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(String... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList<>(tags.length);
            }
            for (String e : tags) {
                this.tags.add(e);
            }
        }

        @Override
        public UntagLogGroupRequest build() {
            return new UntagLogGroupRequest(this);
        }
    }
}
