/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.cloudwatchlogs.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * LogStreamMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class LogStreamMarshaller {

    private static final MarshallingInfo<String> LOGSTREAMNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logStreamName").build();
    private static final MarshallingInfo<Long> CREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").build();
    private static final MarshallingInfo<Long> FIRSTEVENTTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("firstEventTimestamp").build();
    private static final MarshallingInfo<Long> LASTEVENTTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastEventTimestamp").build();
    private static final MarshallingInfo<Long> LASTINGESTIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastIngestionTime").build();
    private static final MarshallingInfo<String> UPLOADSEQUENCETOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("uploadSequenceToken").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<Long> STOREDBYTES_BINDING = MarshallingInfo.builder(MarshallingType.LONG)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("storedBytes").build();

    private static final LogStreamMarshaller instance = new LogStreamMarshaller();

    public static LogStreamMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(LogStream logStream, ProtocolMarshaller protocolMarshaller) {

        if (logStream == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(logStream.logStreamName(), LOGSTREAMNAME_BINDING);
            protocolMarshaller.marshall(logStream.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(logStream.firstEventTimestamp(), FIRSTEVENTTIMESTAMP_BINDING);
            protocolMarshaller.marshall(logStream.lastEventTimestamp(), LASTEVENTTIMESTAMP_BINDING);
            protocolMarshaller.marshall(logStream.lastIngestionTime(), LASTINGESTIONTIME_BINDING);
            protocolMarshaller.marshall(logStream.uploadSequenceToken(), UPLOADSEQUENCETOKEN_BINDING);
            protocolMarshaller.marshall(logStream.arn(), ARN_BINDING);
            protocolMarshaller.marshall(logStream.storedBytes(), STOREDBYTES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
