/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.cloudwatchlogs.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * MetricFilter JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class MetricFilterUnmarshaller implements Unmarshaller<MetricFilter, JsonUnmarshallerContext> {

    public MetricFilter unmarshall(JsonUnmarshallerContext context) throws Exception {
        MetricFilter.Builder metricFilterBuilder = MetricFilter.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("filterName", targetDepth)) {
                    context.nextToken();
                    metricFilterBuilder.filterName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("filterPattern", targetDepth)) {
                    context.nextToken();
                    metricFilterBuilder.filterPattern(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("metricTransformations", targetDepth)) {
                    context.nextToken();
                    metricFilterBuilder.metricTransformations(new ListUnmarshaller<MetricTransformation>(
                            MetricTransformationUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("creationTime", targetDepth)) {
                    context.nextToken();
                    metricFilterBuilder.creationTime(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("logGroupName", targetDepth)) {
                    context.nextToken();
                    metricFilterBuilder.logGroupName(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return metricFilterBuilder.build();
    }

    private static MetricFilterUnmarshaller INSTANCE;

    public static MetricFilterUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new MetricFilterUnmarshaller();
        return INSTANCE;
    }
}