/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.cloudwatchlogs.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * RejectedLogEventsInfoMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class RejectedLogEventsInfoMarshaller {

    private static final MarshallingInfo<Integer> TOONEWLOGEVENTSTARTINDEX_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("tooNewLogEventStartIndex").build();
    private static final MarshallingInfo<Integer> TOOOLDLOGEVENTENDINDEX_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("tooOldLogEventEndIndex").build();
    private static final MarshallingInfo<Integer> EXPIREDLOGEVENTENDINDEX_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("expiredLogEventEndIndex").build();

    private static final RejectedLogEventsInfoMarshaller instance = new RejectedLogEventsInfoMarshaller();

    public static RejectedLogEventsInfoMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(RejectedLogEventsInfo rejectedLogEventsInfo, ProtocolMarshaller protocolMarshaller) {

        if (rejectedLogEventsInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(rejectedLogEventsInfo.tooNewLogEventStartIndex(), TOONEWLOGEVENTSTARTINDEX_BINDING);
            protocolMarshaller.marshall(rejectedLogEventsInfo.tooOldLogEventEndIndex(), TOOOLDLOGEVENTENDINDEX_BINDING);
            protocolMarshaller.marshall(rejectedLogEventsInfo.expiredLogEventEndIndex(), EXPIREDLOGEVENTENDINDEX_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
