/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDatasetRequest extends LookoutEquipmentRequest implements
        ToCopyableBuilder<CreateDatasetRequest.Builder, CreateDatasetRequest> {
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetName").getter(getter(CreateDatasetRequest::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()).build();

    private static final SdkField<DatasetSchema> DATASET_SCHEMA_FIELD = SdkField
            .<DatasetSchema> builder(MarshallingType.SDK_POJO).memberName("DatasetSchema")
            .getter(getter(CreateDatasetRequest::datasetSchema)).setter(setter(Builder::datasetSchema))
            .constructor(DatasetSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetSchema").build()).build();

    private static final SdkField<String> SERVER_SIDE_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerSideKmsKeyId").getter(getter(CreateDatasetRequest::serverSideKmsKeyId))
            .setter(setter(Builder::serverSideKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideKmsKeyId").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateDatasetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDatasetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_NAME_FIELD,
            DATASET_SCHEMA_FIELD, SERVER_SIDE_KMS_KEY_ID_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private final String datasetName;

    private final DatasetSchema datasetSchema;

    private final String serverSideKmsKeyId;

    private final String clientToken;

    private final List<Tag> tags;

    private CreateDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.datasetName = builder.datasetName;
        this.datasetSchema = builder.datasetSchema;
        this.serverSideKmsKeyId = builder.serverSideKmsKeyId;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the dataset being created.
     * </p>
     * 
     * @return The name of the dataset being created.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * A JSON description of the data that is in each time series dataset, including names, column names, and data
     * types.
     * </p>
     * 
     * @return A JSON description of the data that is in each time series dataset, including names, column names, and
     *         data types.
     */
    public final DatasetSchema datasetSchema() {
        return datasetSchema;
    }

    /**
     * <p>
     * Provides the identifier of the AWS KMS customer master key (CMK) used to encrypt dataset data by Amazon Lookout
     * for Equipment.
     * </p>
     * 
     * @return Provides the identifier of the AWS KMS customer master key (CMK) used to encrypt dataset data by Amazon
     *         Lookout for Equipment.
     */
    public final String serverSideKmsKeyId() {
        return serverSideKmsKeyId;
    }

    /**
     * <p>
     * A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment
     * generates one.
     * </p>
     * 
     * @return A unique identifier for the request. If you do not set the client request token, Amazon Lookout for
     *         Equipment generates one.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags associated with the ingested data described in the dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any tags associated with the ingested data described in the dataset.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetSchema());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetRequest)) {
            return false;
        }
        CreateDatasetRequest other = (CreateDatasetRequest) obj;
        return Objects.equals(datasetName(), other.datasetName()) && Objects.equals(datasetSchema(), other.datasetSchema())
                && Objects.equals(serverSideKmsKeyId(), other.serverSideKmsKeyId())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDatasetRequest").add("DatasetName", datasetName()).add("DatasetSchema", datasetSchema())
                .add("ServerSideKmsKeyId", serverSideKmsKeyId()).add("ClientToken", clientToken())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "DatasetSchema":
            return Optional.ofNullable(clazz.cast(datasetSchema()));
        case "ServerSideKmsKeyId":
            return Optional.ofNullable(clazz.cast(serverSideKmsKeyId()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetRequest, T> g) {
        return obj -> g.apply((CreateDatasetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDatasetRequest> {
        /**
         * <p>
         * The name of the dataset being created.
         * </p>
         * 
         * @param datasetName
         *        The name of the dataset being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * A JSON description of the data that is in each time series dataset, including names, column names, and data
         * types.
         * </p>
         * 
         * @param datasetSchema
         *        A JSON description of the data that is in each time series dataset, including names, column names, and
         *        data types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetSchema(DatasetSchema datasetSchema);

        /**
         * <p>
         * A JSON description of the data that is in each time series dataset, including names, column names, and data
         * types.
         * </p>
         * This is a convenience that creates an instance of the {@link DatasetSchema.Builder} avoiding the need to
         * create one manually via {@link DatasetSchema#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatasetSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #datasetSchema(DatasetSchema)}.
         * 
         * @param datasetSchema
         *        a consumer that will call methods on {@link DatasetSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetSchema(DatasetSchema)
         */
        default Builder datasetSchema(Consumer<DatasetSchema.Builder> datasetSchema) {
            return datasetSchema(DatasetSchema.builder().applyMutation(datasetSchema).build());
        }

        /**
         * <p>
         * Provides the identifier of the AWS KMS customer master key (CMK) used to encrypt dataset data by Amazon
         * Lookout for Equipment.
         * </p>
         * 
         * @param serverSideKmsKeyId
         *        Provides the identifier of the AWS KMS customer master key (CMK) used to encrypt dataset data by
         *        Amazon Lookout for Equipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideKmsKeyId(String serverSideKmsKeyId);

        /**
         * <p>
         * A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment
         * generates one.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier for the request. If you do not set the client request token, Amazon Lookout for
         *        Equipment generates one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Any tags associated with the ingested data described in the dataset.
         * </p>
         * 
         * @param tags
         *        Any tags associated with the ingested data described in the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags associated with the ingested data described in the dataset.
         * </p>
         * 
         * @param tags
         *        Any tags associated with the ingested data described in the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags associated with the ingested data described in the dataset.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutEquipmentRequest.BuilderImpl implements Builder {
        private String datasetName;

        private DatasetSchema datasetSchema;

        private String serverSideKmsKeyId;

        private String clientToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetRequest model) {
            super(model);
            datasetName(model.datasetName);
            datasetSchema(model.datasetSchema);
            serverSideKmsKeyId(model.serverSideKmsKeyId);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getDatasetName() {
            return datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public final DatasetSchema.Builder getDatasetSchema() {
            return datasetSchema != null ? datasetSchema.toBuilder() : null;
        }

        @Override
        public final Builder datasetSchema(DatasetSchema datasetSchema) {
            this.datasetSchema = datasetSchema;
            return this;
        }

        public final void setDatasetSchema(DatasetSchema.BuilderImpl datasetSchema) {
            this.datasetSchema = datasetSchema != null ? datasetSchema.build() : null;
        }

        public final String getServerSideKmsKeyId() {
            return serverSideKmsKeyId;
        }

        @Override
        public final Builder serverSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
            return this;
        }

        public final void setServerSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatasetRequest build() {
            return new CreateDatasetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
