/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInferenceSchedulerRequest extends LookoutEquipmentRequest implements
        ToCopyableBuilder<CreateInferenceSchedulerRequest.Builder, CreateInferenceSchedulerRequest> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(CreateInferenceSchedulerRequest::modelName))
            .setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> INFERENCE_SCHEDULER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceSchedulerName").getter(getter(CreateInferenceSchedulerRequest::inferenceSchedulerName))
            .setter(setter(Builder::inferenceSchedulerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerName").build())
            .build();

    private static final SdkField<Long> DATA_DELAY_OFFSET_IN_MINUTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DataDelayOffsetInMinutes").getter(getter(CreateInferenceSchedulerRequest::dataDelayOffsetInMinutes))
            .setter(setter(Builder::dataDelayOffsetInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataDelayOffsetInMinutes").build())
            .build();

    private static final SdkField<String> DATA_UPLOAD_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataUploadFrequency").getter(getter(CreateInferenceSchedulerRequest::dataUploadFrequencyAsString))
            .setter(setter(Builder::dataUploadFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataUploadFrequency").build())
            .build();

    private static final SdkField<InferenceInputConfiguration> DATA_INPUT_CONFIGURATION_FIELD = SdkField
            .<InferenceInputConfiguration> builder(MarshallingType.SDK_POJO).memberName("DataInputConfiguration")
            .getter(getter(CreateInferenceSchedulerRequest::dataInputConfiguration))
            .setter(setter(Builder::dataInputConfiguration)).constructor(InferenceInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataInputConfiguration").build())
            .build();

    private static final SdkField<InferenceOutputConfiguration> DATA_OUTPUT_CONFIGURATION_FIELD = SdkField
            .<InferenceOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("DataOutputConfiguration")
            .getter(getter(CreateInferenceSchedulerRequest::dataOutputConfiguration))
            .setter(setter(Builder::dataOutputConfiguration)).constructor(InferenceOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataOutputConfiguration").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateInferenceSchedulerRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> SERVER_SIDE_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerSideKmsKeyId").getter(getter(CreateInferenceSchedulerRequest::serverSideKmsKeyId))
            .setter(setter(Builder::serverSideKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideKmsKeyId").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateInferenceSchedulerRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateInferenceSchedulerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            INFERENCE_SCHEDULER_NAME_FIELD, DATA_DELAY_OFFSET_IN_MINUTES_FIELD, DATA_UPLOAD_FREQUENCY_FIELD,
            DATA_INPUT_CONFIGURATION_FIELD, DATA_OUTPUT_CONFIGURATION_FIELD, ROLE_ARN_FIELD, SERVER_SIDE_KMS_KEY_ID_FIELD,
            CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private final String modelName;

    private final String inferenceSchedulerName;

    private final Long dataDelayOffsetInMinutes;

    private final String dataUploadFrequency;

    private final InferenceInputConfiguration dataInputConfiguration;

    private final InferenceOutputConfiguration dataOutputConfiguration;

    private final String roleArn;

    private final String serverSideKmsKeyId;

    private final String clientToken;

    private final List<Tag> tags;

    private CreateInferenceSchedulerRequest(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.inferenceSchedulerName = builder.inferenceSchedulerName;
        this.dataDelayOffsetInMinutes = builder.dataDelayOffsetInMinutes;
        this.dataUploadFrequency = builder.dataUploadFrequency;
        this.dataInputConfiguration = builder.dataInputConfiguration;
        this.dataOutputConfiguration = builder.dataOutputConfiguration;
        this.roleArn = builder.roleArn;
        this.serverSideKmsKeyId = builder.serverSideKmsKeyId;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the previously trained ML model being used to create the inference scheduler.
     * </p>
     * 
     * @return The name of the previously trained ML model being used to create the inference scheduler.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The name of the inference scheduler being created.
     * </p>
     * 
     * @return The name of the inference scheduler being created.
     */
    public final String inferenceSchedulerName() {
        return inferenceSchedulerName;
    }

    /**
     * <p>
     * A period of time (in minutes) by which inference on the data is delayed after the data starts. For instance, if
     * you select an offset delay time of five minutes, inference will not begin on the data until the first data
     * measurement after the five minute mark. For example, if five minutes is selected, the inference scheduler will
     * wake up at the configured frequency with the additional five minute delay time to check the customer S3 bucket.
     * The customer can upload data at the same frequency and they don't need to stop and restart the scheduler when
     * uploading new data.
     * </p>
     * 
     * @return A period of time (in minutes) by which inference on the data is delayed after the data starts. For
     *         instance, if you select an offset delay time of five minutes, inference will not begin on the data until
     *         the first data measurement after the five minute mark. For example, if five minutes is selected, the
     *         inference scheduler will wake up at the configured frequency with the additional five minute delay time
     *         to check the customer S3 bucket. The customer can upload data at the same frequency and they don't need
     *         to stop and restart the scheduler when uploading new data.
     */
    public final Long dataDelayOffsetInMinutes() {
        return dataDelayOffsetInMinutes;
    }

    /**
     * <p>
     * How often data is uploaded to the source S3 bucket for the input data. The value chosen is the length of time
     * between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the
     * real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon Lookout
     * for Equipment starts a scheduled inference on your data. In this example, it starts once every 5 minutes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataUploadFrequency} will return {@link DataUploadFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataUploadFrequencyAsString}.
     * </p>
     * 
     * @return How often data is uploaded to the source S3 bucket for the input data. The value chosen is the length of
     *         time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will
     *         upload the real-time data to the source bucket once every 5 minutes. This frequency also determines how
     *         often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it starts
     *         once every 5 minutes.
     * @see DataUploadFrequency
     */
    public final DataUploadFrequency dataUploadFrequency() {
        return DataUploadFrequency.fromValue(dataUploadFrequency);
    }

    /**
     * <p>
     * How often data is uploaded to the source S3 bucket for the input data. The value chosen is the length of time
     * between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the
     * real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon Lookout
     * for Equipment starts a scheduled inference on your data. In this example, it starts once every 5 minutes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataUploadFrequency} will return {@link DataUploadFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataUploadFrequencyAsString}.
     * </p>
     * 
     * @return How often data is uploaded to the source S3 bucket for the input data. The value chosen is the length of
     *         time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will
     *         upload the real-time data to the source bucket once every 5 minutes. This frequency also determines how
     *         often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it starts
     *         once every 5 minutes.
     * @see DataUploadFrequency
     */
    public final String dataUploadFrequencyAsString() {
        return dataUploadFrequency;
    }

    /**
     * <p>
     * Specifies configuration information for the input data for the inference scheduler, including delimiter, format,
     * and dataset location.
     * </p>
     * 
     * @return Specifies configuration information for the input data for the inference scheduler, including delimiter,
     *         format, and dataset location.
     */
    public final InferenceInputConfiguration dataInputConfiguration() {
        return dataInputConfiguration;
    }

    /**
     * <p>
     * Specifies configuration information for the output results for the inference scheduler, including the S3 location
     * for the output.
     * </p>
     * 
     * @return Specifies configuration information for the output results for the inference scheduler, including the S3
     *         location for the output.
     */
    public final InferenceOutputConfiguration dataOutputConfiguration() {
        return dataOutputConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a role with permission to access the data source being used for the inference.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a role with permission to access the data source being used for the
     *         inference.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Provides the identifier of the AWS KMS customer master key (CMK) used to encrypt inference scheduler data by
     * Amazon Lookout for Equipment.
     * </p>
     * 
     * @return Provides the identifier of the AWS KMS customer master key (CMK) used to encrypt inference scheduler data
     *         by Amazon Lookout for Equipment.
     */
    public final String serverSideKmsKeyId() {
        return serverSideKmsKeyId;
    }

    /**
     * <p>
     * A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment
     * generates one.
     * </p>
     * 
     * @return A unique identifier for the request. If you do not set the client request token, Amazon Lookout for
     *         Equipment generates one.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags associated with the inference scheduler.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any tags associated with the inference scheduler.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSchedulerName());
        hashCode = 31 * hashCode + Objects.hashCode(dataDelayOffsetInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(dataUploadFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dataOutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInferenceSchedulerRequest)) {
            return false;
        }
        CreateInferenceSchedulerRequest other = (CreateInferenceSchedulerRequest) obj;
        return Objects.equals(modelName(), other.modelName())
                && Objects.equals(inferenceSchedulerName(), other.inferenceSchedulerName())
                && Objects.equals(dataDelayOffsetInMinutes(), other.dataDelayOffsetInMinutes())
                && Objects.equals(dataUploadFrequencyAsString(), other.dataUploadFrequencyAsString())
                && Objects.equals(dataInputConfiguration(), other.dataInputConfiguration())
                && Objects.equals(dataOutputConfiguration(), other.dataOutputConfiguration())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(serverSideKmsKeyId(), other.serverSideKmsKeyId())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInferenceSchedulerRequest").add("ModelName", modelName())
                .add("InferenceSchedulerName", inferenceSchedulerName())
                .add("DataDelayOffsetInMinutes", dataDelayOffsetInMinutes())
                .add("DataUploadFrequency", dataUploadFrequencyAsString())
                .add("DataInputConfiguration", dataInputConfiguration())
                .add("DataOutputConfiguration", dataOutputConfiguration()).add("RoleArn", roleArn())
                .add("ServerSideKmsKeyId", serverSideKmsKeyId()).add("ClientToken", clientToken())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "InferenceSchedulerName":
            return Optional.ofNullable(clazz.cast(inferenceSchedulerName()));
        case "DataDelayOffsetInMinutes":
            return Optional.ofNullable(clazz.cast(dataDelayOffsetInMinutes()));
        case "DataUploadFrequency":
            return Optional.ofNullable(clazz.cast(dataUploadFrequencyAsString()));
        case "DataInputConfiguration":
            return Optional.ofNullable(clazz.cast(dataInputConfiguration()));
        case "DataOutputConfiguration":
            return Optional.ofNullable(clazz.cast(dataOutputConfiguration()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "ServerSideKmsKeyId":
            return Optional.ofNullable(clazz.cast(serverSideKmsKeyId()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateInferenceSchedulerRequest, T> g) {
        return obj -> g.apply((CreateInferenceSchedulerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateInferenceSchedulerRequest> {
        /**
         * <p>
         * The name of the previously trained ML model being used to create the inference scheduler.
         * </p>
         * 
         * @param modelName
         *        The name of the previously trained ML model being used to create the inference scheduler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The name of the inference scheduler being created.
         * </p>
         * 
         * @param inferenceSchedulerName
         *        The name of the inference scheduler being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSchedulerName(String inferenceSchedulerName);

        /**
         * <p>
         * A period of time (in minutes) by which inference on the data is delayed after the data starts. For instance,
         * if you select an offset delay time of five minutes, inference will not begin on the data until the first data
         * measurement after the five minute mark. For example, if five minutes is selected, the inference scheduler
         * will wake up at the configured frequency with the additional five minute delay time to check the customer S3
         * bucket. The customer can upload data at the same frequency and they don't need to stop and restart the
         * scheduler when uploading new data.
         * </p>
         * 
         * @param dataDelayOffsetInMinutes
         *        A period of time (in minutes) by which inference on the data is delayed after the data starts. For
         *        instance, if you select an offset delay time of five minutes, inference will not begin on the data
         *        until the first data measurement after the five minute mark. For example, if five minutes is selected,
         *        the inference scheduler will wake up at the configured frequency with the additional five minute delay
         *        time to check the customer S3 bucket. The customer can upload data at the same frequency and they
         *        don't need to stop and restart the scheduler when uploading new data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataDelayOffsetInMinutes(Long dataDelayOffsetInMinutes);

        /**
         * <p>
         * How often data is uploaded to the source S3 bucket for the input data. The value chosen is the length of time
         * between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the
         * real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon
         * Lookout for Equipment starts a scheduled inference on your data. In this example, it starts once every 5
         * minutes.
         * </p>
         * 
         * @param dataUploadFrequency
         *        How often data is uploaded to the source S3 bucket for the input data. The value chosen is the length
         *        of time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will
         *        upload the real-time data to the source bucket once every 5 minutes. This frequency also determines
         *        how often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it
         *        starts once every 5 minutes.
         * @see DataUploadFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataUploadFrequency
         */
        Builder dataUploadFrequency(String dataUploadFrequency);

        /**
         * <p>
         * How often data is uploaded to the source S3 bucket for the input data. The value chosen is the length of time
         * between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the
         * real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon
         * Lookout for Equipment starts a scheduled inference on your data. In this example, it starts once every 5
         * minutes.
         * </p>
         * 
         * @param dataUploadFrequency
         *        How often data is uploaded to the source S3 bucket for the input data. The value chosen is the length
         *        of time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will
         *        upload the real-time data to the source bucket once every 5 minutes. This frequency also determines
         *        how often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it
         *        starts once every 5 minutes.
         * @see DataUploadFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataUploadFrequency
         */
        Builder dataUploadFrequency(DataUploadFrequency dataUploadFrequency);

        /**
         * <p>
         * Specifies configuration information for the input data for the inference scheduler, including delimiter,
         * format, and dataset location.
         * </p>
         * 
         * @param dataInputConfiguration
         *        Specifies configuration information for the input data for the inference scheduler, including
         *        delimiter, format, and dataset location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataInputConfiguration(InferenceInputConfiguration dataInputConfiguration);

        /**
         * <p>
         * Specifies configuration information for the input data for the inference scheduler, including delimiter,
         * format, and dataset location.
         * </p>
         * This is a convenience that creates an instance of the {@link InferenceInputConfiguration.Builder} avoiding
         * the need to create one manually via {@link InferenceInputConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link InferenceInputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #dataInputConfiguration(InferenceInputConfiguration)}.
         * 
         * @param dataInputConfiguration
         *        a consumer that will call methods on {@link InferenceInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataInputConfiguration(InferenceInputConfiguration)
         */
        default Builder dataInputConfiguration(Consumer<InferenceInputConfiguration.Builder> dataInputConfiguration) {
            return dataInputConfiguration(InferenceInputConfiguration.builder().applyMutation(dataInputConfiguration).build());
        }

        /**
         * <p>
         * Specifies configuration information for the output results for the inference scheduler, including the S3
         * location for the output.
         * </p>
         * 
         * @param dataOutputConfiguration
         *        Specifies configuration information for the output results for the inference scheduler, including the
         *        S3 location for the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataOutputConfiguration(InferenceOutputConfiguration dataOutputConfiguration);

        /**
         * <p>
         * Specifies configuration information for the output results for the inference scheduler, including the S3
         * location for the output.
         * </p>
         * This is a convenience that creates an instance of the {@link InferenceOutputConfiguration.Builder} avoiding
         * the need to create one manually via {@link InferenceOutputConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link InferenceOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #dataOutputConfiguration(InferenceOutputConfiguration)}.
         * 
         * @param dataOutputConfiguration
         *        a consumer that will call methods on {@link InferenceOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataOutputConfiguration(InferenceOutputConfiguration)
         */
        default Builder dataOutputConfiguration(Consumer<InferenceOutputConfiguration.Builder> dataOutputConfiguration) {
            return dataOutputConfiguration(InferenceOutputConfiguration.builder().applyMutation(dataOutputConfiguration).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a role with permission to access the data source being used for the
         * inference.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of a role with permission to access the data source being used for the
         *        inference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Provides the identifier of the AWS KMS customer master key (CMK) used to encrypt inference scheduler data by
         * Amazon Lookout for Equipment.
         * </p>
         * 
         * @param serverSideKmsKeyId
         *        Provides the identifier of the AWS KMS customer master key (CMK) used to encrypt inference scheduler
         *        data by Amazon Lookout for Equipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideKmsKeyId(String serverSideKmsKeyId);

        /**
         * <p>
         * A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment
         * generates one.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier for the request. If you do not set the client request token, Amazon Lookout for
         *        Equipment generates one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Any tags associated with the inference scheduler.
         * </p>
         * 
         * @param tags
         *        Any tags associated with the inference scheduler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags associated with the inference scheduler.
         * </p>
         * 
         * @param tags
         *        Any tags associated with the inference scheduler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags associated with the inference scheduler.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutEquipmentRequest.BuilderImpl implements Builder {
        private String modelName;

        private String inferenceSchedulerName;

        private Long dataDelayOffsetInMinutes;

        private String dataUploadFrequency;

        private InferenceInputConfiguration dataInputConfiguration;

        private InferenceOutputConfiguration dataOutputConfiguration;

        private String roleArn;

        private String serverSideKmsKeyId;

        private String clientToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInferenceSchedulerRequest model) {
            super(model);
            modelName(model.modelName);
            inferenceSchedulerName(model.inferenceSchedulerName);
            dataDelayOffsetInMinutes(model.dataDelayOffsetInMinutes);
            dataUploadFrequency(model.dataUploadFrequency);
            dataInputConfiguration(model.dataInputConfiguration);
            dataOutputConfiguration(model.dataOutputConfiguration);
            roleArn(model.roleArn);
            serverSideKmsKeyId(model.serverSideKmsKeyId);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getModelName() {
            return modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public final String getInferenceSchedulerName() {
            return inferenceSchedulerName;
        }

        @Override
        public final Builder inferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
            return this;
        }

        public final void setInferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
        }

        public final Long getDataDelayOffsetInMinutes() {
            return dataDelayOffsetInMinutes;
        }

        @Override
        public final Builder dataDelayOffsetInMinutes(Long dataDelayOffsetInMinutes) {
            this.dataDelayOffsetInMinutes = dataDelayOffsetInMinutes;
            return this;
        }

        public final void setDataDelayOffsetInMinutes(Long dataDelayOffsetInMinutes) {
            this.dataDelayOffsetInMinutes = dataDelayOffsetInMinutes;
        }

        public final String getDataUploadFrequency() {
            return dataUploadFrequency;
        }

        @Override
        public final Builder dataUploadFrequency(String dataUploadFrequency) {
            this.dataUploadFrequency = dataUploadFrequency;
            return this;
        }

        @Override
        public final Builder dataUploadFrequency(DataUploadFrequency dataUploadFrequency) {
            this.dataUploadFrequency(dataUploadFrequency == null ? null : dataUploadFrequency.toString());
            return this;
        }

        public final void setDataUploadFrequency(String dataUploadFrequency) {
            this.dataUploadFrequency = dataUploadFrequency;
        }

        public final InferenceInputConfiguration.Builder getDataInputConfiguration() {
            return dataInputConfiguration != null ? dataInputConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder dataInputConfiguration(InferenceInputConfiguration dataInputConfiguration) {
            this.dataInputConfiguration = dataInputConfiguration;
            return this;
        }

        public final void setDataInputConfiguration(InferenceInputConfiguration.BuilderImpl dataInputConfiguration) {
            this.dataInputConfiguration = dataInputConfiguration != null ? dataInputConfiguration.build() : null;
        }

        public final InferenceOutputConfiguration.Builder getDataOutputConfiguration() {
            return dataOutputConfiguration != null ? dataOutputConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder dataOutputConfiguration(InferenceOutputConfiguration dataOutputConfiguration) {
            this.dataOutputConfiguration = dataOutputConfiguration;
            return this;
        }

        public final void setDataOutputConfiguration(InferenceOutputConfiguration.BuilderImpl dataOutputConfiguration) {
            this.dataOutputConfiguration = dataOutputConfiguration != null ? dataOutputConfiguration.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getServerSideKmsKeyId() {
            return serverSideKmsKeyId;
        }

        @Override
        public final Builder serverSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
            return this;
        }

        public final void setServerSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInferenceSchedulerRequest build() {
            return new CreateInferenceSchedulerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
