/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a specified data ingestion job, including dataset information, data ingestion
 * configuration, and status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataIngestionJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DataIngestionJobSummary.Builder, DataIngestionJobSummary> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(DataIngestionJobSummary::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetName").getter(getter(DataIngestionJobSummary::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()).build();

    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetArn").getter(getter(DataIngestionJobSummary::datasetArn)).setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()).build();

    private static final SdkField<IngestionInputConfiguration> INGESTION_INPUT_CONFIGURATION_FIELD = SdkField
            .<IngestionInputConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("IngestionInputConfiguration")
            .getter(getter(DataIngestionJobSummary::ingestionInputConfiguration))
            .setter(setter(Builder::ingestionInputConfiguration))
            .constructor(IngestionInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionInputConfiguration")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DataIngestionJobSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            DATASET_NAME_FIELD, DATASET_ARN_FIELD, INGESTION_INPUT_CONFIGURATION_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final String datasetName;

    private final String datasetArn;

    private final IngestionInputConfiguration ingestionInputConfiguration;

    private final String status;

    private DataIngestionJobSummary(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.datasetName = builder.datasetName;
        this.datasetArn = builder.datasetArn;
        this.ingestionInputConfiguration = builder.ingestionInputConfiguration;
        this.status = builder.status;
    }

    /**
     * <p>
     * Indicates the job ID of the data ingestion job.
     * </p>
     * 
     * @return Indicates the job ID of the data ingestion job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The name of the dataset used for the data ingestion job.
     * </p>
     * 
     * @return The name of the dataset used for the data ingestion job.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset used in the data ingestion job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset used in the data ingestion job.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * Specifies information for the input data for the data inference job, including data S3 location parameters.
     * </p>
     * 
     * @return Specifies information for the input data for the data inference job, including data S3 location
     *         parameters.
     */
    public final IngestionInputConfiguration ingestionInputConfiguration() {
        return ingestionInputConfiguration;
    }

    /**
     * <p>
     * Indicates the status of the data ingestion job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IngestionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the data ingestion job.
     * @see IngestionJobStatus
     */
    public final IngestionJobStatus status() {
        return IngestionJobStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates the status of the data ingestion job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IngestionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the data ingestion job.
     * @see IngestionJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataIngestionJobSummary)) {
            return false;
        }
        DataIngestionJobSummary other = (DataIngestionJobSummary) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(datasetName(), other.datasetName())
                && Objects.equals(datasetArn(), other.datasetArn())
                && Objects.equals(ingestionInputConfiguration(), other.ingestionInputConfiguration())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataIngestionJobSummary").add("JobId", jobId()).add("DatasetName", datasetName())
                .add("DatasetArn", datasetArn()).add("IngestionInputConfiguration", ingestionInputConfiguration())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "DatasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "IngestionInputConfiguration":
            return Optional.ofNullable(clazz.cast(ingestionInputConfiguration()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataIngestionJobSummary, T> g) {
        return obj -> g.apply((DataIngestionJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataIngestionJobSummary> {
        /**
         * <p>
         * Indicates the job ID of the data ingestion job.
         * </p>
         * 
         * @param jobId
         *        Indicates the job ID of the data ingestion job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The name of the dataset used for the data ingestion job.
         * </p>
         * 
         * @param datasetName
         *        The name of the dataset used for the data ingestion job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset used in the data ingestion job.
         * </p>
         * 
         * @param datasetArn
         *        The Amazon Resource Name (ARN) of the dataset used in the data ingestion job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * Specifies information for the input data for the data inference job, including data S3 location parameters.
         * </p>
         * 
         * @param ingestionInputConfiguration
         *        Specifies information for the input data for the data inference job, including data S3 location
         *        parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionInputConfiguration(IngestionInputConfiguration ingestionInputConfiguration);

        /**
         * <p>
         * Specifies information for the input data for the data inference job, including data S3 location parameters.
         * </p>
         * This is a convenience that creates an instance of the {@link IngestionInputConfiguration.Builder} avoiding
         * the need to create one manually via {@link IngestionInputConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link IngestionInputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #ingestionInputConfiguration(IngestionInputConfiguration)}.
         * 
         * @param ingestionInputConfiguration
         *        a consumer that will call methods on {@link IngestionInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingestionInputConfiguration(IngestionInputConfiguration)
         */
        default Builder ingestionInputConfiguration(Consumer<IngestionInputConfiguration.Builder> ingestionInputConfiguration) {
            return ingestionInputConfiguration(IngestionInputConfiguration.builder().applyMutation(ingestionInputConfiguration)
                    .build());
        }

        /**
         * <p>
         * Indicates the status of the data ingestion job.
         * </p>
         * 
         * @param status
         *        Indicates the status of the data ingestion job.
         * @see IngestionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates the status of the data ingestion job.
         * </p>
         * 
         * @param status
         *        Indicates the status of the data ingestion job.
         * @see IngestionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IngestionJobStatus
         */
        Builder status(IngestionJobStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private String datasetName;

        private String datasetArn;

        private IngestionInputConfiguration ingestionInputConfiguration;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DataIngestionJobSummary model) {
            jobId(model.jobId);
            datasetName(model.datasetName);
            datasetArn(model.datasetArn);
            ingestionInputConfiguration(model.ingestionInputConfiguration);
            status(model.status);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getDatasetName() {
            return datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        public final IngestionInputConfiguration.Builder getIngestionInputConfiguration() {
            return ingestionInputConfiguration != null ? ingestionInputConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder ingestionInputConfiguration(IngestionInputConfiguration ingestionInputConfiguration) {
            this.ingestionInputConfiguration = ingestionInputConfiguration;
            return this;
        }

        public final void setIngestionInputConfiguration(IngestionInputConfiguration.BuilderImpl ingestionInputConfiguration) {
            this.ingestionInputConfiguration = ingestionInputConfiguration != null ? ingestionInputConfiguration.build() : null;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IngestionJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public DataIngestionJobSummary build() {
            return new DataIngestionJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
