/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the data schema used with the given dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetSchema implements SdkPojo, Serializable, ToCopyableBuilder<DatasetSchema.Builder, DatasetSchema> {
    private static final SdkField<String> INLINE_DATA_SCHEMA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InlineDataSchema")
            .getter(getter(DatasetSchema::inlineDataSchema))
            .setter(setter(Builder::inlineDataSchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InlineDataSchema").build(),
                    JsonValueTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INLINE_DATA_SCHEMA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String inlineDataSchema;

    private DatasetSchema(BuilderImpl builder) {
        this.inlineDataSchema = builder.inlineDataSchema;
    }

    /**
     * <p>
     * </p>
     * 
     * @return
     */
    public final String inlineDataSchema() {
        return inlineDataSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inlineDataSchema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetSchema)) {
            return false;
        }
        DatasetSchema other = (DatasetSchema) obj;
        return Objects.equals(inlineDataSchema(), other.inlineDataSchema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetSchema").add("InlineDataSchema", inlineDataSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InlineDataSchema":
            return Optional.ofNullable(clazz.cast(inlineDataSchema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetSchema, T> g) {
        return obj -> g.apply((DatasetSchema) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetSchema> {
        /**
         * <p>
         * </p>
         * 
         * @param inlineDataSchema
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineDataSchema(String inlineDataSchema);
    }

    static final class BuilderImpl implements Builder {
        private String inlineDataSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetSchema model) {
            inlineDataSchema(model.inlineDataSchema);
        }

        public final String getInlineDataSchema() {
            return inlineDataSchema;
        }

        @Override
        public final Builder inlineDataSchema(String inlineDataSchema) {
            this.inlineDataSchema = inlineDataSchema;
            return this;
        }

        public final void setInlineDataSchema(String inlineDataSchema) {
            this.inlineDataSchema = inlineDataSchema;
        }

        @Override
        public DatasetSchema build() {
            return new DatasetSchema(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
