/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInferenceSchedulersResponse extends LookoutEquipmentResponse implements
        ToCopyableBuilder<ListInferenceSchedulersResponse.Builder, ListInferenceSchedulersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInferenceSchedulersResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<InferenceSchedulerSummary>> INFERENCE_SCHEDULER_SUMMARIES_FIELD = SdkField
            .<List<InferenceSchedulerSummary>> builder(MarshallingType.LIST)
            .memberName("InferenceSchedulerSummaries")
            .getter(getter(ListInferenceSchedulersResponse::inferenceSchedulerSummaries))
            .setter(setter(Builder::inferenceSchedulerSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InferenceSchedulerSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(InferenceSchedulerSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            INFERENCE_SCHEDULER_SUMMARIES_FIELD));

    private final String nextToken;

    private final List<InferenceSchedulerSummary> inferenceSchedulerSummaries;

    private ListInferenceSchedulersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.inferenceSchedulerSummaries = builder.inferenceSchedulerSummaries;
    }

    /**
     * <p>
     * An opaque pagination token indicating where to continue the listing of inference schedulers.
     * </p>
     * 
     * @return An opaque pagination token indicating where to continue the listing of inference schedulers.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the InferenceSchedulerSummaries property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasInferenceSchedulerSummaries() {
        return inferenceSchedulerSummaries != null && !(inferenceSchedulerSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides information about the specified inference scheduler, including data upload frequency, model name and
     * ARN, and status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInferenceSchedulerSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Provides information about the specified inference scheduler, including data upload frequency, model name
     *         and ARN, and status.
     */
    public final List<InferenceSchedulerSummary> inferenceSchedulerSummaries() {
        return inferenceSchedulerSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasInferenceSchedulerSummaries() ? inferenceSchedulerSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInferenceSchedulersResponse)) {
            return false;
        }
        ListInferenceSchedulersResponse other = (ListInferenceSchedulersResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasInferenceSchedulerSummaries() == other.hasInferenceSchedulerSummaries()
                && Objects.equals(inferenceSchedulerSummaries(), other.inferenceSchedulerSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInferenceSchedulersResponse").add("NextToken", nextToken())
                .add("InferenceSchedulerSummaries", hasInferenceSchedulerSummaries() ? inferenceSchedulerSummaries() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "InferenceSchedulerSummaries":
            return Optional.ofNullable(clazz.cast(inferenceSchedulerSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInferenceSchedulersResponse, T> g) {
        return obj -> g.apply((ListInferenceSchedulersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListInferenceSchedulersResponse> {
        /**
         * <p>
         * An opaque pagination token indicating where to continue the listing of inference schedulers.
         * </p>
         * 
         * @param nextToken
         *        An opaque pagination token indicating where to continue the listing of inference schedulers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Provides information about the specified inference scheduler, including data upload frequency, model name and
         * ARN, and status.
         * </p>
         * 
         * @param inferenceSchedulerSummaries
         *        Provides information about the specified inference scheduler, including data upload frequency, model
         *        name and ARN, and status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSchedulerSummaries(Collection<InferenceSchedulerSummary> inferenceSchedulerSummaries);

        /**
         * <p>
         * Provides information about the specified inference scheduler, including data upload frequency, model name and
         * ARN, and status.
         * </p>
         * 
         * @param inferenceSchedulerSummaries
         *        Provides information about the specified inference scheduler, including data upload frequency, model
         *        name and ARN, and status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSchedulerSummaries(InferenceSchedulerSummary... inferenceSchedulerSummaries);

        /**
         * <p>
         * Provides information about the specified inference scheduler, including data upload frequency, model name and
         * ARN, and status.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InferenceSchedulerSummary>.Builder}
         * avoiding the need to create one manually via {@link List<InferenceSchedulerSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InferenceSchedulerSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #inferenceSchedulerSummaries(List<InferenceSchedulerSummary>)}
         * .
         * 
         * @param inferenceSchedulerSummaries
         *        a consumer that will call methods on {@link List<InferenceSchedulerSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceSchedulerSummaries(List<InferenceSchedulerSummary>)
         */
        Builder inferenceSchedulerSummaries(Consumer<InferenceSchedulerSummary.Builder>... inferenceSchedulerSummaries);
    }

    static final class BuilderImpl extends LookoutEquipmentResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<InferenceSchedulerSummary> inferenceSchedulerSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListInferenceSchedulersResponse model) {
            super(model);
            nextToken(model.nextToken);
            inferenceSchedulerSummaries(model.inferenceSchedulerSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final List<InferenceSchedulerSummary.Builder> getInferenceSchedulerSummaries() {
            List<InferenceSchedulerSummary.Builder> result = InferenceSchedulerSummariesCopier
                    .copyToBuilder(this.inferenceSchedulerSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder inferenceSchedulerSummaries(Collection<InferenceSchedulerSummary> inferenceSchedulerSummaries) {
            this.inferenceSchedulerSummaries = InferenceSchedulerSummariesCopier.copy(inferenceSchedulerSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceSchedulerSummaries(InferenceSchedulerSummary... inferenceSchedulerSummaries) {
            inferenceSchedulerSummaries(Arrays.asList(inferenceSchedulerSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceSchedulerSummaries(
                Consumer<InferenceSchedulerSummary.Builder>... inferenceSchedulerSummaries) {
            inferenceSchedulerSummaries(Stream.of(inferenceSchedulerSummaries)
                    .map(c -> InferenceSchedulerSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInferenceSchedulerSummaries(
                Collection<InferenceSchedulerSummary.BuilderImpl> inferenceSchedulerSummaries) {
            this.inferenceSchedulerSummaries = InferenceSchedulerSummariesCopier.copyFromBuilder(inferenceSchedulerSummaries);
        }

        @Override
        public ListInferenceSchedulersResponse build() {
            return new ListInferenceSchedulersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
