/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDataIngestionJobRequest extends LookoutEquipmentRequest implements
        ToCopyableBuilder<StartDataIngestionJobRequest.Builder, StartDataIngestionJobRequest> {
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetName").getter(getter(StartDataIngestionJobRequest::datasetName))
            .setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()).build();

    private static final SdkField<IngestionInputConfiguration> INGESTION_INPUT_CONFIGURATION_FIELD = SdkField
            .<IngestionInputConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("IngestionInputConfiguration")
            .getter(getter(StartDataIngestionJobRequest::ingestionInputConfiguration))
            .setter(setter(Builder::ingestionInputConfiguration))
            .constructor(IngestionInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionInputConfiguration")
                    .build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(StartDataIngestionJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartDataIngestionJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_NAME_FIELD,
            INGESTION_INPUT_CONFIGURATION_FIELD, ROLE_ARN_FIELD, CLIENT_TOKEN_FIELD));

    private final String datasetName;

    private final IngestionInputConfiguration ingestionInputConfiguration;

    private final String roleArn;

    private final String clientToken;

    private StartDataIngestionJobRequest(BuilderImpl builder) {
        super(builder);
        this.datasetName = builder.datasetName;
        this.ingestionInputConfiguration = builder.ingestionInputConfiguration;
        this.roleArn = builder.roleArn;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the dataset being used by the data ingestion job.
     * </p>
     * 
     * @return The name of the dataset being used by the data ingestion job.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * Specifies information for the input data for the data ingestion job, including dataset S3 location.
     * </p>
     * 
     * @return Specifies information for the input data for the data ingestion job, including dataset S3 location.
     */
    public final IngestionInputConfiguration ingestionInputConfiguration() {
        return ingestionInputConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a role with permission to access the data source for the data ingestion job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a role with permission to access the data source for the data ingestion
     *         job.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment
     * generates one.
     * </p>
     * 
     * @return A unique identifier for the request. If you do not set the client request token, Amazon Lookout for
     *         Equipment generates one.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(ingestionInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDataIngestionJobRequest)) {
            return false;
        }
        StartDataIngestionJobRequest other = (StartDataIngestionJobRequest) obj;
        return Objects.equals(datasetName(), other.datasetName())
                && Objects.equals(ingestionInputConfiguration(), other.ingestionInputConfiguration())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDataIngestionJobRequest").add("DatasetName", datasetName())
                .add("IngestionInputConfiguration", ingestionInputConfiguration()).add("RoleArn", roleArn())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "IngestionInputConfiguration":
            return Optional.ofNullable(clazz.cast(ingestionInputConfiguration()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDataIngestionJobRequest, T> g) {
        return obj -> g.apply((StartDataIngestionJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartDataIngestionJobRequest> {
        /**
         * <p>
         * The name of the dataset being used by the data ingestion job.
         * </p>
         * 
         * @param datasetName
         *        The name of the dataset being used by the data ingestion job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * Specifies information for the input data for the data ingestion job, including dataset S3 location.
         * </p>
         * 
         * @param ingestionInputConfiguration
         *        Specifies information for the input data for the data ingestion job, including dataset S3 location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestionInputConfiguration(IngestionInputConfiguration ingestionInputConfiguration);

        /**
         * <p>
         * Specifies information for the input data for the data ingestion job, including dataset S3 location.
         * </p>
         * This is a convenience that creates an instance of the {@link IngestionInputConfiguration.Builder} avoiding
         * the need to create one manually via {@link IngestionInputConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link IngestionInputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #ingestionInputConfiguration(IngestionInputConfiguration)}.
         * 
         * @param ingestionInputConfiguration
         *        a consumer that will call methods on {@link IngestionInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingestionInputConfiguration(IngestionInputConfiguration)
         */
        default Builder ingestionInputConfiguration(Consumer<IngestionInputConfiguration.Builder> ingestionInputConfiguration) {
            return ingestionInputConfiguration(IngestionInputConfiguration.builder().applyMutation(ingestionInputConfiguration)
                    .build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a role with permission to access the data source for the data ingestion
         * job.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of a role with permission to access the data source for the data
         *        ingestion job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment
         * generates one.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier for the request. If you do not set the client request token, Amazon Lookout for
         *        Equipment generates one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutEquipmentRequest.BuilderImpl implements Builder {
        private String datasetName;

        private IngestionInputConfiguration ingestionInputConfiguration;

        private String roleArn;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDataIngestionJobRequest model) {
            super(model);
            datasetName(model.datasetName);
            ingestionInputConfiguration(model.ingestionInputConfiguration);
            roleArn(model.roleArn);
            clientToken(model.clientToken);
        }

        public final String getDatasetName() {
            return datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public final IngestionInputConfiguration.Builder getIngestionInputConfiguration() {
            return ingestionInputConfiguration != null ? ingestionInputConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder ingestionInputConfiguration(IngestionInputConfiguration ingestionInputConfiguration) {
            this.ingestionInputConfiguration = ingestionInputConfiguration;
            return this;
        }

        public final void setIngestionInputConfiguration(IngestionInputConfiguration.BuilderImpl ingestionInputConfiguration) {
            this.ingestionInputConfiguration = ingestionInputConfiguration != null ? ingestionInputConfiguration.build() : null;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDataIngestionJobRequest build() {
            return new StartDataIngestionJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
