/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateModelRequest extends LookoutEquipmentRequest implements
        ToCopyableBuilder<CreateModelRequest.Builder, CreateModelRequest> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(CreateModelRequest::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetName").getter(getter(CreateModelRequest::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()).build();

    private static final SdkField<DatasetSchema> DATASET_SCHEMA_FIELD = SdkField
            .<DatasetSchema> builder(MarshallingType.SDK_POJO).memberName("DatasetSchema")
            .getter(getter(CreateModelRequest::datasetSchema)).setter(setter(Builder::datasetSchema))
            .constructor(DatasetSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetSchema").build()).build();

    private static final SdkField<LabelsInputConfiguration> LABELS_INPUT_CONFIGURATION_FIELD = SdkField
            .<LabelsInputConfiguration> builder(MarshallingType.SDK_POJO).memberName("LabelsInputConfiguration")
            .getter(getter(CreateModelRequest::labelsInputConfiguration)).setter(setter(Builder::labelsInputConfiguration))
            .constructor(LabelsInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelsInputConfiguration").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateModelRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Instant> TRAINING_DATA_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TrainingDataStartTime").getter(getter(CreateModelRequest::trainingDataStartTime))
            .setter(setter(Builder::trainingDataStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingDataStartTime").build())
            .build();

    private static final SdkField<Instant> TRAINING_DATA_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TrainingDataEndTime").getter(getter(CreateModelRequest::trainingDataEndTime))
            .setter(setter(Builder::trainingDataEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingDataEndTime").build())
            .build();

    private static final SdkField<Instant> EVALUATION_DATA_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EvaluationDataStartTime").getter(getter(CreateModelRequest::evaluationDataStartTime))
            .setter(setter(Builder::evaluationDataStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationDataStartTime").build())
            .build();

    private static final SdkField<Instant> EVALUATION_DATA_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EvaluationDataEndTime").getter(getter(CreateModelRequest::evaluationDataEndTime))
            .setter(setter(Builder::evaluationDataEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationDataEndTime").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateModelRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<DataPreProcessingConfiguration> DATA_PRE_PROCESSING_CONFIGURATION_FIELD = SdkField
            .<DataPreProcessingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("DataPreProcessingConfiguration")
            .getter(getter(CreateModelRequest::dataPreProcessingConfiguration))
            .setter(setter(Builder::dataPreProcessingConfiguration))
            .constructor(DataPreProcessingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPreProcessingConfiguration")
                    .build()).build();

    private static final SdkField<String> SERVER_SIDE_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerSideKmsKeyId").getter(getter(CreateModelRequest::serverSideKmsKeyId))
            .setter(setter(Builder::serverSideKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideKmsKeyId").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateModelRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OFF_CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OffCondition").getter(getter(CreateModelRequest::offCondition)).setter(setter(Builder::offCondition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OffCondition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            DATASET_NAME_FIELD, DATASET_SCHEMA_FIELD, LABELS_INPUT_CONFIGURATION_FIELD, CLIENT_TOKEN_FIELD,
            TRAINING_DATA_START_TIME_FIELD, TRAINING_DATA_END_TIME_FIELD, EVALUATION_DATA_START_TIME_FIELD,
            EVALUATION_DATA_END_TIME_FIELD, ROLE_ARN_FIELD, DATA_PRE_PROCESSING_CONFIGURATION_FIELD,
            SERVER_SIDE_KMS_KEY_ID_FIELD, TAGS_FIELD, OFF_CONDITION_FIELD));

    private final String modelName;

    private final String datasetName;

    private final DatasetSchema datasetSchema;

    private final LabelsInputConfiguration labelsInputConfiguration;

    private final String clientToken;

    private final Instant trainingDataStartTime;

    private final Instant trainingDataEndTime;

    private final Instant evaluationDataStartTime;

    private final Instant evaluationDataEndTime;

    private final String roleArn;

    private final DataPreProcessingConfiguration dataPreProcessingConfiguration;

    private final String serverSideKmsKeyId;

    private final List<Tag> tags;

    private final String offCondition;

    private CreateModelRequest(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.datasetName = builder.datasetName;
        this.datasetSchema = builder.datasetSchema;
        this.labelsInputConfiguration = builder.labelsInputConfiguration;
        this.clientToken = builder.clientToken;
        this.trainingDataStartTime = builder.trainingDataStartTime;
        this.trainingDataEndTime = builder.trainingDataEndTime;
        this.evaluationDataStartTime = builder.evaluationDataStartTime;
        this.evaluationDataEndTime = builder.evaluationDataEndTime;
        this.roleArn = builder.roleArn;
        this.dataPreProcessingConfiguration = builder.dataPreProcessingConfiguration;
        this.serverSideKmsKeyId = builder.serverSideKmsKeyId;
        this.tags = builder.tags;
        this.offCondition = builder.offCondition;
    }

    /**
     * <p>
     * The name for the ML model to be created.
     * </p>
     * 
     * @return The name for the ML model to be created.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The name of the dataset for the ML model being created.
     * </p>
     * 
     * @return The name of the dataset for the ML model being created.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The data schema for the ML model being created.
     * </p>
     * 
     * @return The data schema for the ML model being created.
     */
    public final DatasetSchema datasetSchema() {
        return datasetSchema;
    }

    /**
     * <p>
     * The input configuration for the labels being used for the ML model that's being created.
     * </p>
     * 
     * @return The input configuration for the labels being used for the ML model that's being created.
     */
    public final LabelsInputConfiguration labelsInputConfiguration() {
        return labelsInputConfiguration;
    }

    /**
     * <p>
     * A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment
     * generates one.
     * </p>
     * 
     * @return A unique identifier for the request. If you do not set the client request token, Amazon Lookout for
     *         Equipment generates one.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Indicates the time reference in the dataset that should be used to begin the subset of training data for the ML
     * model.
     * </p>
     * 
     * @return Indicates the time reference in the dataset that should be used to begin the subset of training data for
     *         the ML model.
     */
    public final Instant trainingDataStartTime() {
        return trainingDataStartTime;
    }

    /**
     * <p>
     * Indicates the time reference in the dataset that should be used to end the subset of training data for the ML
     * model.
     * </p>
     * 
     * @return Indicates the time reference in the dataset that should be used to end the subset of training data for
     *         the ML model.
     */
    public final Instant trainingDataEndTime() {
        return trainingDataEndTime;
    }

    /**
     * <p>
     * Indicates the time reference in the dataset that should be used to begin the subset of evaluation data for the ML
     * model.
     * </p>
     * 
     * @return Indicates the time reference in the dataset that should be used to begin the subset of evaluation data
     *         for the ML model.
     */
    public final Instant evaluationDataStartTime() {
        return evaluationDataStartTime;
    }

    /**
     * <p>
     * Indicates the time reference in the dataset that should be used to end the subset of evaluation data for the ML
     * model.
     * </p>
     * 
     * @return Indicates the time reference in the dataset that should be used to end the subset of evaluation data for
     *         the ML model.
     */
    public final Instant evaluationDataEndTime() {
        return evaluationDataEndTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a role with permission to access the data source being used to create the ML
     * model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a role with permission to access the data source being used to create
     *         the ML model.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The configuration is the <code>TargetSamplingRate</code>, which is the sampling rate of the data after post
     * processing by Amazon Lookout for Equipment. For example, if you provide data that has been collected at a 1
     * second level and you want the system to resample the data at a 1 minute rate before training, the
     * <code>TargetSamplingRate</code> is 1 minute.
     * </p>
     * <p>
     * When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the rate you
     * want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate is <i>PT15M</i>, and
     * the value for a 1 hour rate is <i>PT1H</i>
     * </p>
     * 
     * @return The configuration is the <code>TargetSamplingRate</code>, which is the sampling rate of the data after
     *         post processing by Amazon Lookout for Equipment. For example, if you provide data that has been collected
     *         at a 1 second level and you want the system to resample the data at a 1 minute rate before training, the
     *         <code>TargetSamplingRate</code> is 1 minute.</p>
     *         <p>
     *         When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the
     *         rate you want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate is
     *         <i>PT15M</i>, and the value for a 1 hour rate is <i>PT1H</i>
     */
    public final DataPreProcessingConfiguration dataPreProcessingConfiguration() {
        return dataPreProcessingConfiguration;
    }

    /**
     * <p>
     * Provides the identifier of the KMS key used to encrypt model data by Amazon Lookout for Equipment.
     * </p>
     * 
     * @return Provides the identifier of the KMS key used to encrypt model data by Amazon Lookout for Equipment.
     */
    public final String serverSideKmsKeyId() {
        return serverSideKmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags associated with the ML model being created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Any tags associated with the ML model being created.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Indicates that the asset associated with this sensor has been shut off. As long as this condition is met, Lookout
     * for Equipment will not use data from this asset for training, evaluation, or inference.
     * </p>
     * 
     * @return Indicates that the asset associated with this sensor has been shut off. As long as this condition is met,
     *         Lookout for Equipment will not use data from this asset for training, evaluation, or inference.
     */
    public final String offCondition() {
        return offCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetSchema());
        hashCode = 31 * hashCode + Objects.hashCode(labelsInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationDataStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationDataEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataPreProcessingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(offCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelRequest)) {
            return false;
        }
        CreateModelRequest other = (CreateModelRequest) obj;
        return Objects.equals(modelName(), other.modelName()) && Objects.equals(datasetName(), other.datasetName())
                && Objects.equals(datasetSchema(), other.datasetSchema())
                && Objects.equals(labelsInputConfiguration(), other.labelsInputConfiguration())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(trainingDataStartTime(), other.trainingDataStartTime())
                && Objects.equals(trainingDataEndTime(), other.trainingDataEndTime())
                && Objects.equals(evaluationDataStartTime(), other.evaluationDataStartTime())
                && Objects.equals(evaluationDataEndTime(), other.evaluationDataEndTime())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(dataPreProcessingConfiguration(), other.dataPreProcessingConfiguration())
                && Objects.equals(serverSideKmsKeyId(), other.serverSideKmsKeyId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(offCondition(), other.offCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateModelRequest").add("ModelName", modelName()).add("DatasetName", datasetName())
                .add("DatasetSchema", datasetSchema()).add("LabelsInputConfiguration", labelsInputConfiguration())
                .add("ClientToken", clientToken()).add("TrainingDataStartTime", trainingDataStartTime())
                .add("TrainingDataEndTime", trainingDataEndTime()).add("EvaluationDataStartTime", evaluationDataStartTime())
                .add("EvaluationDataEndTime", evaluationDataEndTime()).add("RoleArn", roleArn())
                .add("DataPreProcessingConfiguration", dataPreProcessingConfiguration())
                .add("ServerSideKmsKeyId", serverSideKmsKeyId()).add("Tags", hasTags() ? tags() : null)
                .add("OffCondition", offCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "DatasetSchema":
            return Optional.ofNullable(clazz.cast(datasetSchema()));
        case "LabelsInputConfiguration":
            return Optional.ofNullable(clazz.cast(labelsInputConfiguration()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "TrainingDataStartTime":
            return Optional.ofNullable(clazz.cast(trainingDataStartTime()));
        case "TrainingDataEndTime":
            return Optional.ofNullable(clazz.cast(trainingDataEndTime()));
        case "EvaluationDataStartTime":
            return Optional.ofNullable(clazz.cast(evaluationDataStartTime()));
        case "EvaluationDataEndTime":
            return Optional.ofNullable(clazz.cast(evaluationDataEndTime()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "DataPreProcessingConfiguration":
            return Optional.ofNullable(clazz.cast(dataPreProcessingConfiguration()));
        case "ServerSideKmsKeyId":
            return Optional.ofNullable(clazz.cast(serverSideKmsKeyId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "OffCondition":
            return Optional.ofNullable(clazz.cast(offCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelRequest, T> g) {
        return obj -> g.apply((CreateModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateModelRequest> {
        /**
         * <p>
         * The name for the ML model to be created.
         * </p>
         * 
         * @param modelName
         *        The name for the ML model to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The name of the dataset for the ML model being created.
         * </p>
         * 
         * @param datasetName
         *        The name of the dataset for the ML model being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The data schema for the ML model being created.
         * </p>
         * 
         * @param datasetSchema
         *        The data schema for the ML model being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetSchema(DatasetSchema datasetSchema);

        /**
         * <p>
         * The data schema for the ML model being created.
         * </p>
         * This is a convenience that creates an instance of the {@link DatasetSchema.Builder} avoiding the need to
         * create one manually via {@link DatasetSchema#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatasetSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #datasetSchema(DatasetSchema)}.
         * 
         * @param datasetSchema
         *        a consumer that will call methods on {@link DatasetSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetSchema(DatasetSchema)
         */
        default Builder datasetSchema(Consumer<DatasetSchema.Builder> datasetSchema) {
            return datasetSchema(DatasetSchema.builder().applyMutation(datasetSchema).build());
        }

        /**
         * <p>
         * The input configuration for the labels being used for the ML model that's being created.
         * </p>
         * 
         * @param labelsInputConfiguration
         *        The input configuration for the labels being used for the ML model that's being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelsInputConfiguration(LabelsInputConfiguration labelsInputConfiguration);

        /**
         * <p>
         * The input configuration for the labels being used for the ML model that's being created.
         * </p>
         * This is a convenience that creates an instance of the {@link LabelsInputConfiguration.Builder} avoiding the
         * need to create one manually via {@link LabelsInputConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link LabelsInputConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #labelsInputConfiguration(LabelsInputConfiguration)}.
         * 
         * @param labelsInputConfiguration
         *        a consumer that will call methods on {@link LabelsInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelsInputConfiguration(LabelsInputConfiguration)
         */
        default Builder labelsInputConfiguration(Consumer<LabelsInputConfiguration.Builder> labelsInputConfiguration) {
            return labelsInputConfiguration(LabelsInputConfiguration.builder().applyMutation(labelsInputConfiguration).build());
        }

        /**
         * <p>
         * A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment
         * generates one.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier for the request. If you do not set the client request token, Amazon Lookout for
         *        Equipment generates one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Indicates the time reference in the dataset that should be used to begin the subset of training data for the
         * ML model.
         * </p>
         * 
         * @param trainingDataStartTime
         *        Indicates the time reference in the dataset that should be used to begin the subset of training data
         *        for the ML model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataStartTime(Instant trainingDataStartTime);

        /**
         * <p>
         * Indicates the time reference in the dataset that should be used to end the subset of training data for the ML
         * model.
         * </p>
         * 
         * @param trainingDataEndTime
         *        Indicates the time reference in the dataset that should be used to end the subset of training data for
         *        the ML model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataEndTime(Instant trainingDataEndTime);

        /**
         * <p>
         * Indicates the time reference in the dataset that should be used to begin the subset of evaluation data for
         * the ML model.
         * </p>
         * 
         * @param evaluationDataStartTime
         *        Indicates the time reference in the dataset that should be used to begin the subset of evaluation data
         *        for the ML model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationDataStartTime(Instant evaluationDataStartTime);

        /**
         * <p>
         * Indicates the time reference in the dataset that should be used to end the subset of evaluation data for the
         * ML model.
         * </p>
         * 
         * @param evaluationDataEndTime
         *        Indicates the time reference in the dataset that should be used to end the subset of evaluation data
         *        for the ML model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationDataEndTime(Instant evaluationDataEndTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a role with permission to access the data source being used to create the
         * ML model.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of a role with permission to access the data source being used to
         *        create the ML model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The configuration is the <code>TargetSamplingRate</code>, which is the sampling rate of the data after post
         * processing by Amazon Lookout for Equipment. For example, if you provide data that has been collected at a 1
         * second level and you want the system to resample the data at a 1 minute rate before training, the
         * <code>TargetSamplingRate</code> is 1 minute.
         * </p>
         * <p>
         * When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the rate
         * you want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate is
         * <i>PT15M</i>, and the value for a 1 hour rate is <i>PT1H</i>
         * </p>
         * 
         * @param dataPreProcessingConfiguration
         *        The configuration is the <code>TargetSamplingRate</code>, which is the sampling rate of the data after
         *        post processing by Amazon Lookout for Equipment. For example, if you provide data that has been
         *        collected at a 1 second level and you want the system to resample the data at a 1 minute rate before
         *        training, the <code>TargetSamplingRate</code> is 1 minute.</p>
         *        <p>
         *        When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the
         *        rate you want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate
         *        is <i>PT15M</i>, and the value for a 1 hour rate is <i>PT1H</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPreProcessingConfiguration(DataPreProcessingConfiguration dataPreProcessingConfiguration);

        /**
         * <p>
         * The configuration is the <code>TargetSamplingRate</code>, which is the sampling rate of the data after post
         * processing by Amazon Lookout for Equipment. For example, if you provide data that has been collected at a 1
         * second level and you want the system to resample the data at a 1 minute rate before training, the
         * <code>TargetSamplingRate</code> is 1 minute.
         * </p>
         * <p>
         * When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the rate
         * you want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate is
         * <i>PT15M</i>, and the value for a 1 hour rate is <i>PT1H</i>
         * </p>
         * This is a convenience that creates an instance of the {@link DataPreProcessingConfiguration.Builder} avoiding
         * the need to create one manually via {@link DataPreProcessingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataPreProcessingConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #dataPreProcessingConfiguration(DataPreProcessingConfiguration)}.
         * 
         * @param dataPreProcessingConfiguration
         *        a consumer that will call methods on {@link DataPreProcessingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataPreProcessingConfiguration(DataPreProcessingConfiguration)
         */
        default Builder dataPreProcessingConfiguration(
                Consumer<DataPreProcessingConfiguration.Builder> dataPreProcessingConfiguration) {
            return dataPreProcessingConfiguration(DataPreProcessingConfiguration.builder()
                    .applyMutation(dataPreProcessingConfiguration).build());
        }

        /**
         * <p>
         * Provides the identifier of the KMS key used to encrypt model data by Amazon Lookout for Equipment.
         * </p>
         * 
         * @param serverSideKmsKeyId
         *        Provides the identifier of the KMS key used to encrypt model data by Amazon Lookout for Equipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideKmsKeyId(String serverSideKmsKeyId);

        /**
         * <p>
         * Any tags associated with the ML model being created.
         * </p>
         * 
         * @param tags
         *        Any tags associated with the ML model being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags associated with the ML model being created.
         * </p>
         * 
         * @param tags
         *        Any tags associated with the ML model being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags associated with the ML model being created.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Indicates that the asset associated with this sensor has been shut off. As long as this condition is met,
         * Lookout for Equipment will not use data from this asset for training, evaluation, or inference.
         * </p>
         * 
         * @param offCondition
         *        Indicates that the asset associated with this sensor has been shut off. As long as this condition is
         *        met, Lookout for Equipment will not use data from this asset for training, evaluation, or inference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offCondition(String offCondition);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutEquipmentRequest.BuilderImpl implements Builder {
        private String modelName;

        private String datasetName;

        private DatasetSchema datasetSchema;

        private LabelsInputConfiguration labelsInputConfiguration;

        private String clientToken;

        private Instant trainingDataStartTime;

        private Instant trainingDataEndTime;

        private Instant evaluationDataStartTime;

        private Instant evaluationDataEndTime;

        private String roleArn;

        private DataPreProcessingConfiguration dataPreProcessingConfiguration;

        private String serverSideKmsKeyId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String offCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelRequest model) {
            super(model);
            modelName(model.modelName);
            datasetName(model.datasetName);
            datasetSchema(model.datasetSchema);
            labelsInputConfiguration(model.labelsInputConfiguration);
            clientToken(model.clientToken);
            trainingDataStartTime(model.trainingDataStartTime);
            trainingDataEndTime(model.trainingDataEndTime);
            evaluationDataStartTime(model.evaluationDataStartTime);
            evaluationDataEndTime(model.evaluationDataEndTime);
            roleArn(model.roleArn);
            dataPreProcessingConfiguration(model.dataPreProcessingConfiguration);
            serverSideKmsKeyId(model.serverSideKmsKeyId);
            tags(model.tags);
            offCondition(model.offCondition);
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        @Transient
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getDatasetName() {
            return datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        @Transient
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final DatasetSchema.Builder getDatasetSchema() {
            return datasetSchema != null ? datasetSchema.toBuilder() : null;
        }

        public final void setDatasetSchema(DatasetSchema.BuilderImpl datasetSchema) {
            this.datasetSchema = datasetSchema != null ? datasetSchema.build() : null;
        }

        @Override
        @Transient
        public final Builder datasetSchema(DatasetSchema datasetSchema) {
            this.datasetSchema = datasetSchema;
            return this;
        }

        public final LabelsInputConfiguration.Builder getLabelsInputConfiguration() {
            return labelsInputConfiguration != null ? labelsInputConfiguration.toBuilder() : null;
        }

        public final void setLabelsInputConfiguration(LabelsInputConfiguration.BuilderImpl labelsInputConfiguration) {
            this.labelsInputConfiguration = labelsInputConfiguration != null ? labelsInputConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder labelsInputConfiguration(LabelsInputConfiguration labelsInputConfiguration) {
            this.labelsInputConfiguration = labelsInputConfiguration;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Instant getTrainingDataStartTime() {
            return trainingDataStartTime;
        }

        public final void setTrainingDataStartTime(Instant trainingDataStartTime) {
            this.trainingDataStartTime = trainingDataStartTime;
        }

        @Override
        @Transient
        public final Builder trainingDataStartTime(Instant trainingDataStartTime) {
            this.trainingDataStartTime = trainingDataStartTime;
            return this;
        }

        public final Instant getTrainingDataEndTime() {
            return trainingDataEndTime;
        }

        public final void setTrainingDataEndTime(Instant trainingDataEndTime) {
            this.trainingDataEndTime = trainingDataEndTime;
        }

        @Override
        @Transient
        public final Builder trainingDataEndTime(Instant trainingDataEndTime) {
            this.trainingDataEndTime = trainingDataEndTime;
            return this;
        }

        public final Instant getEvaluationDataStartTime() {
            return evaluationDataStartTime;
        }

        public final void setEvaluationDataStartTime(Instant evaluationDataStartTime) {
            this.evaluationDataStartTime = evaluationDataStartTime;
        }

        @Override
        @Transient
        public final Builder evaluationDataStartTime(Instant evaluationDataStartTime) {
            this.evaluationDataStartTime = evaluationDataStartTime;
            return this;
        }

        public final Instant getEvaluationDataEndTime() {
            return evaluationDataEndTime;
        }

        public final void setEvaluationDataEndTime(Instant evaluationDataEndTime) {
            this.evaluationDataEndTime = evaluationDataEndTime;
        }

        @Override
        @Transient
        public final Builder evaluationDataEndTime(Instant evaluationDataEndTime) {
            this.evaluationDataEndTime = evaluationDataEndTime;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final DataPreProcessingConfiguration.Builder getDataPreProcessingConfiguration() {
            return dataPreProcessingConfiguration != null ? dataPreProcessingConfiguration.toBuilder() : null;
        }

        public final void setDataPreProcessingConfiguration(
                DataPreProcessingConfiguration.BuilderImpl dataPreProcessingConfiguration) {
            this.dataPreProcessingConfiguration = dataPreProcessingConfiguration != null ? dataPreProcessingConfiguration.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder dataPreProcessingConfiguration(DataPreProcessingConfiguration dataPreProcessingConfiguration) {
            this.dataPreProcessingConfiguration = dataPreProcessingConfiguration;
            return this;
        }

        public final String getServerSideKmsKeyId() {
            return serverSideKmsKeyId;
        }

        public final void setServerSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
        }

        @Override
        @Transient
        public final Builder serverSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOffCondition() {
            return offCondition;
        }

        public final void setOffCondition(String offCondition) {
            this.offCondition = offCondition;
        }

        @Override
        @Transient
        public final Builder offCondition(String offCondition) {
            this.offCondition = offCondition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelRequest build() {
            return new CreateModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
