/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the specific inference execution, including input and output data configuration, inference
 * scheduling information, status, and so on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceExecutionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceExecutionSummary.Builder, InferenceExecutionSummary> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(InferenceExecutionSummary::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelArn").getter(getter(InferenceExecutionSummary::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()).build();

    private static final SdkField<String> INFERENCE_SCHEDULER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceSchedulerName").getter(getter(InferenceExecutionSummary::inferenceSchedulerName))
            .setter(setter(Builder::inferenceSchedulerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerName").build())
            .build();

    private static final SdkField<String> INFERENCE_SCHEDULER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceSchedulerArn").getter(getter(InferenceExecutionSummary::inferenceSchedulerArn))
            .setter(setter(Builder::inferenceSchedulerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerArn").build())
            .build();

    private static final SdkField<Instant> SCHEDULED_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ScheduledStartTime").getter(getter(InferenceExecutionSummary::scheduledStartTime))
            .setter(setter(Builder::scheduledStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledStartTime").build())
            .build();

    private static final SdkField<Instant> DATA_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DataStartTime").getter(getter(InferenceExecutionSummary::dataStartTime))
            .setter(setter(Builder::dataStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStartTime").build()).build();

    private static final SdkField<Instant> DATA_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DataEndTime").getter(getter(InferenceExecutionSummary::dataEndTime))
            .setter(setter(Builder::dataEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataEndTime").build()).build();

    private static final SdkField<InferenceInputConfiguration> DATA_INPUT_CONFIGURATION_FIELD = SdkField
            .<InferenceInputConfiguration> builder(MarshallingType.SDK_POJO).memberName("DataInputConfiguration")
            .getter(getter(InferenceExecutionSummary::dataInputConfiguration)).setter(setter(Builder::dataInputConfiguration))
            .constructor(InferenceInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataInputConfiguration").build())
            .build();

    private static final SdkField<InferenceOutputConfiguration> DATA_OUTPUT_CONFIGURATION_FIELD = SdkField
            .<InferenceOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("DataOutputConfiguration")
            .getter(getter(InferenceExecutionSummary::dataOutputConfiguration)).setter(setter(Builder::dataOutputConfiguration))
            .constructor(InferenceOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataOutputConfiguration").build())
            .build();

    private static final SdkField<S3Object> CUSTOMER_RESULT_OBJECT_FIELD = SdkField.<S3Object> builder(MarshallingType.SDK_POJO)
            .memberName("CustomerResultObject").getter(getter(InferenceExecutionSummary::customerResultObject))
            .setter(setter(Builder::customerResultObject)).constructor(S3Object::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerResultObject").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(InferenceExecutionSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FAILED_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailedReason").getter(getter(InferenceExecutionSummary::failedReason))
            .setter(setter(Builder::failedReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            MODEL_ARN_FIELD, INFERENCE_SCHEDULER_NAME_FIELD, INFERENCE_SCHEDULER_ARN_FIELD, SCHEDULED_START_TIME_FIELD,
            DATA_START_TIME_FIELD, DATA_END_TIME_FIELD, DATA_INPUT_CONFIGURATION_FIELD, DATA_OUTPUT_CONFIGURATION_FIELD,
            CUSTOMER_RESULT_OBJECT_FIELD, STATUS_FIELD, FAILED_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String modelName;

    private final String modelArn;

    private final String inferenceSchedulerName;

    private final String inferenceSchedulerArn;

    private final Instant scheduledStartTime;

    private final Instant dataStartTime;

    private final Instant dataEndTime;

    private final InferenceInputConfiguration dataInputConfiguration;

    private final InferenceOutputConfiguration dataOutputConfiguration;

    private final S3Object customerResultObject;

    private final String status;

    private final String failedReason;

    private InferenceExecutionSummary(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.modelArn = builder.modelArn;
        this.inferenceSchedulerName = builder.inferenceSchedulerName;
        this.inferenceSchedulerArn = builder.inferenceSchedulerArn;
        this.scheduledStartTime = builder.scheduledStartTime;
        this.dataStartTime = builder.dataStartTime;
        this.dataEndTime = builder.dataEndTime;
        this.dataInputConfiguration = builder.dataInputConfiguration;
        this.dataOutputConfiguration = builder.dataOutputConfiguration;
        this.customerResultObject = builder.customerResultObject;
        this.status = builder.status;
        this.failedReason = builder.failedReason;
    }

    /**
     * <p>
     * The name of the ML model being used for the inference execution.
     * </p>
     * 
     * @return The name of the ML model being used for the inference execution.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the ML model used for the inference execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the ML model used for the inference execution.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * The name of the inference scheduler being used for the inference execution.
     * </p>
     * 
     * @return The name of the inference scheduler being used for the inference execution.
     */
    public final String inferenceSchedulerName() {
        return inferenceSchedulerName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the inference scheduler being used for the inference execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the inference scheduler being used for the inference execution.
     */
    public final String inferenceSchedulerArn() {
        return inferenceSchedulerArn;
    }

    /**
     * <p>
     * Indicates the start time at which the inference scheduler began the specific inference execution.
     * </p>
     * 
     * @return Indicates the start time at which the inference scheduler began the specific inference execution.
     */
    public final Instant scheduledStartTime() {
        return scheduledStartTime;
    }

    /**
     * <p>
     * Indicates the time reference in the dataset at which the inference execution began.
     * </p>
     * 
     * @return Indicates the time reference in the dataset at which the inference execution began.
     */
    public final Instant dataStartTime() {
        return dataStartTime;
    }

    /**
     * <p>
     * Indicates the time reference in the dataset at which the inference execution stopped.
     * </p>
     * 
     * @return Indicates the time reference in the dataset at which the inference execution stopped.
     */
    public final Instant dataEndTime() {
        return dataEndTime;
    }

    /**
     * <p>
     * Specifies configuration information for the input data for the inference scheduler, including delimiter, format,
     * and dataset location.
     * </p>
     * 
     * @return Specifies configuration information for the input data for the inference scheduler, including delimiter,
     *         format, and dataset location.
     */
    public final InferenceInputConfiguration dataInputConfiguration() {
        return dataInputConfiguration;
    }

    /**
     * <p>
     * Specifies configuration information for the output results from for the inference execution, including the output
     * S3 location.
     * </p>
     * 
     * @return Specifies configuration information for the output results from for the inference execution, including
     *         the output S3 location.
     */
    public final InferenceOutputConfiguration dataOutputConfiguration() {
        return dataOutputConfiguration;
    }

    /**
     * <p>
     * </p>
     * 
     * @return
     */
    public final S3Object customerResultObject() {
        return customerResultObject;
    }

    /**
     * <p>
     * Indicates the status of the inference execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InferenceExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the inference execution.
     * @see InferenceExecutionStatus
     */
    public final InferenceExecutionStatus status() {
        return InferenceExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates the status of the inference execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InferenceExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the inference execution.
     * @see InferenceExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Specifies the reason for failure when an inference execution has failed.
     * </p>
     * 
     * @return Specifies the reason for failure when an inference execution has failed.
     */
    public final String failedReason() {
        return failedReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSchedulerName());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSchedulerArn());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(dataStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(dataEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(dataInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dataOutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(customerResultObject());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failedReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceExecutionSummary)) {
            return false;
        }
        InferenceExecutionSummary other = (InferenceExecutionSummary) obj;
        return Objects.equals(modelName(), other.modelName()) && Objects.equals(modelArn(), other.modelArn())
                && Objects.equals(inferenceSchedulerName(), other.inferenceSchedulerName())
                && Objects.equals(inferenceSchedulerArn(), other.inferenceSchedulerArn())
                && Objects.equals(scheduledStartTime(), other.scheduledStartTime())
                && Objects.equals(dataStartTime(), other.dataStartTime()) && Objects.equals(dataEndTime(), other.dataEndTime())
                && Objects.equals(dataInputConfiguration(), other.dataInputConfiguration())
                && Objects.equals(dataOutputConfiguration(), other.dataOutputConfiguration())
                && Objects.equals(customerResultObject(), other.customerResultObject())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failedReason(), other.failedReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceExecutionSummary").add("ModelName", modelName()).add("ModelArn", modelArn())
                .add("InferenceSchedulerName", inferenceSchedulerName()).add("InferenceSchedulerArn", inferenceSchedulerArn())
                .add("ScheduledStartTime", scheduledStartTime()).add("DataStartTime", dataStartTime())
                .add("DataEndTime", dataEndTime()).add("DataInputConfiguration", dataInputConfiguration())
                .add("DataOutputConfiguration", dataOutputConfiguration()).add("CustomerResultObject", customerResultObject())
                .add("Status", statusAsString()).add("FailedReason", failedReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "ModelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "InferenceSchedulerName":
            return Optional.ofNullable(clazz.cast(inferenceSchedulerName()));
        case "InferenceSchedulerArn":
            return Optional.ofNullable(clazz.cast(inferenceSchedulerArn()));
        case "ScheduledStartTime":
            return Optional.ofNullable(clazz.cast(scheduledStartTime()));
        case "DataStartTime":
            return Optional.ofNullable(clazz.cast(dataStartTime()));
        case "DataEndTime":
            return Optional.ofNullable(clazz.cast(dataEndTime()));
        case "DataInputConfiguration":
            return Optional.ofNullable(clazz.cast(dataInputConfiguration()));
        case "DataOutputConfiguration":
            return Optional.ofNullable(clazz.cast(dataOutputConfiguration()));
        case "CustomerResultObject":
            return Optional.ofNullable(clazz.cast(customerResultObject()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "FailedReason":
            return Optional.ofNullable(clazz.cast(failedReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferenceExecutionSummary, T> g) {
        return obj -> g.apply((InferenceExecutionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceExecutionSummary> {
        /**
         * <p>
         * The name of the ML model being used for the inference execution.
         * </p>
         * 
         * @param modelName
         *        The name of the ML model being used for the inference execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the ML model used for the inference execution.
         * </p>
         * 
         * @param modelArn
         *        The Amazon Resource Name (ARN) of the ML model used for the inference execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The name of the inference scheduler being used for the inference execution.
         * </p>
         * 
         * @param inferenceSchedulerName
         *        The name of the inference scheduler being used for the inference execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSchedulerName(String inferenceSchedulerName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the inference scheduler being used for the inference execution.
         * </p>
         * 
         * @param inferenceSchedulerArn
         *        The Amazon Resource Name (ARN) of the inference scheduler being used for the inference execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSchedulerArn(String inferenceSchedulerArn);

        /**
         * <p>
         * Indicates the start time at which the inference scheduler began the specific inference execution.
         * </p>
         * 
         * @param scheduledStartTime
         *        Indicates the start time at which the inference scheduler began the specific inference execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledStartTime(Instant scheduledStartTime);

        /**
         * <p>
         * Indicates the time reference in the dataset at which the inference execution began.
         * </p>
         * 
         * @param dataStartTime
         *        Indicates the time reference in the dataset at which the inference execution began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataStartTime(Instant dataStartTime);

        /**
         * <p>
         * Indicates the time reference in the dataset at which the inference execution stopped.
         * </p>
         * 
         * @param dataEndTime
         *        Indicates the time reference in the dataset at which the inference execution stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataEndTime(Instant dataEndTime);

        /**
         * <p>
         * Specifies configuration information for the input data for the inference scheduler, including delimiter,
         * format, and dataset location.
         * </p>
         * 
         * @param dataInputConfiguration
         *        Specifies configuration information for the input data for the inference scheduler, including
         *        delimiter, format, and dataset location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataInputConfiguration(InferenceInputConfiguration dataInputConfiguration);

        /**
         * <p>
         * Specifies configuration information for the input data for the inference scheduler, including delimiter,
         * format, and dataset location.
         * </p>
         * This is a convenience that creates an instance of the {@link InferenceInputConfiguration.Builder} avoiding
         * the need to create one manually via {@link InferenceInputConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link InferenceInputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #dataInputConfiguration(InferenceInputConfiguration)}.
         * 
         * @param dataInputConfiguration
         *        a consumer that will call methods on {@link InferenceInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataInputConfiguration(InferenceInputConfiguration)
         */
        default Builder dataInputConfiguration(Consumer<InferenceInputConfiguration.Builder> dataInputConfiguration) {
            return dataInputConfiguration(InferenceInputConfiguration.builder().applyMutation(dataInputConfiguration).build());
        }

        /**
         * <p>
         * Specifies configuration information for the output results from for the inference execution, including the
         * output S3 location.
         * </p>
         * 
         * @param dataOutputConfiguration
         *        Specifies configuration information for the output results from for the inference execution, including
         *        the output S3 location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataOutputConfiguration(InferenceOutputConfiguration dataOutputConfiguration);

        /**
         * <p>
         * Specifies configuration information for the output results from for the inference execution, including the
         * output S3 location.
         * </p>
         * This is a convenience that creates an instance of the {@link InferenceOutputConfiguration.Builder} avoiding
         * the need to create one manually via {@link InferenceOutputConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link InferenceOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #dataOutputConfiguration(InferenceOutputConfiguration)}.
         * 
         * @param dataOutputConfiguration
         *        a consumer that will call methods on {@link InferenceOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataOutputConfiguration(InferenceOutputConfiguration)
         */
        default Builder dataOutputConfiguration(Consumer<InferenceOutputConfiguration.Builder> dataOutputConfiguration) {
            return dataOutputConfiguration(InferenceOutputConfiguration.builder().applyMutation(dataOutputConfiguration).build());
        }

        /**
         * <p>
         * </p>
         * 
         * @param customerResultObject
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerResultObject(S3Object customerResultObject);

        /**
         * <p>
         * </p>
         * This is a convenience that creates an instance of the {@link S3Object.Builder} avoiding the need to create
         * one manually via {@link S3Object#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Object.Builder#build()} is called immediately and its result is
         * passed to {@link #customerResultObject(S3Object)}.
         * 
         * @param customerResultObject
         *        a consumer that will call methods on {@link S3Object.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerResultObject(S3Object)
         */
        default Builder customerResultObject(Consumer<S3Object.Builder> customerResultObject) {
            return customerResultObject(S3Object.builder().applyMutation(customerResultObject).build());
        }

        /**
         * <p>
         * Indicates the status of the inference execution.
         * </p>
         * 
         * @param status
         *        Indicates the status of the inference execution.
         * @see InferenceExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates the status of the inference execution.
         * </p>
         * 
         * @param status
         *        Indicates the status of the inference execution.
         * @see InferenceExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceExecutionStatus
         */
        Builder status(InferenceExecutionStatus status);

        /**
         * <p>
         * Specifies the reason for failure when an inference execution has failed.
         * </p>
         * 
         * @param failedReason
         *        Specifies the reason for failure when an inference execution has failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedReason(String failedReason);
    }

    static final class BuilderImpl implements Builder {
        private String modelName;

        private String modelArn;

        private String inferenceSchedulerName;

        private String inferenceSchedulerArn;

        private Instant scheduledStartTime;

        private Instant dataStartTime;

        private Instant dataEndTime;

        private InferenceInputConfiguration dataInputConfiguration;

        private InferenceOutputConfiguration dataOutputConfiguration;

        private S3Object customerResultObject;

        private String status;

        private String failedReason;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceExecutionSummary model) {
            modelName(model.modelName);
            modelArn(model.modelArn);
            inferenceSchedulerName(model.inferenceSchedulerName);
            inferenceSchedulerArn(model.inferenceSchedulerArn);
            scheduledStartTime(model.scheduledStartTime);
            dataStartTime(model.dataStartTime);
            dataEndTime(model.dataEndTime);
            dataInputConfiguration(model.dataInputConfiguration);
            dataOutputConfiguration(model.dataOutputConfiguration);
            customerResultObject(model.customerResultObject);
            status(model.status);
            failedReason(model.failedReason);
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        @Transient
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        @Transient
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getInferenceSchedulerName() {
            return inferenceSchedulerName;
        }

        public final void setInferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
        }

        @Override
        @Transient
        public final Builder inferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
            return this;
        }

        public final String getInferenceSchedulerArn() {
            return inferenceSchedulerArn;
        }

        public final void setInferenceSchedulerArn(String inferenceSchedulerArn) {
            this.inferenceSchedulerArn = inferenceSchedulerArn;
        }

        @Override
        @Transient
        public final Builder inferenceSchedulerArn(String inferenceSchedulerArn) {
            this.inferenceSchedulerArn = inferenceSchedulerArn;
            return this;
        }

        public final Instant getScheduledStartTime() {
            return scheduledStartTime;
        }

        public final void setScheduledStartTime(Instant scheduledStartTime) {
            this.scheduledStartTime = scheduledStartTime;
        }

        @Override
        @Transient
        public final Builder scheduledStartTime(Instant scheduledStartTime) {
            this.scheduledStartTime = scheduledStartTime;
            return this;
        }

        public final Instant getDataStartTime() {
            return dataStartTime;
        }

        public final void setDataStartTime(Instant dataStartTime) {
            this.dataStartTime = dataStartTime;
        }

        @Override
        @Transient
        public final Builder dataStartTime(Instant dataStartTime) {
            this.dataStartTime = dataStartTime;
            return this;
        }

        public final Instant getDataEndTime() {
            return dataEndTime;
        }

        public final void setDataEndTime(Instant dataEndTime) {
            this.dataEndTime = dataEndTime;
        }

        @Override
        @Transient
        public final Builder dataEndTime(Instant dataEndTime) {
            this.dataEndTime = dataEndTime;
            return this;
        }

        public final InferenceInputConfiguration.Builder getDataInputConfiguration() {
            return dataInputConfiguration != null ? dataInputConfiguration.toBuilder() : null;
        }

        public final void setDataInputConfiguration(InferenceInputConfiguration.BuilderImpl dataInputConfiguration) {
            this.dataInputConfiguration = dataInputConfiguration != null ? dataInputConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder dataInputConfiguration(InferenceInputConfiguration dataInputConfiguration) {
            this.dataInputConfiguration = dataInputConfiguration;
            return this;
        }

        public final InferenceOutputConfiguration.Builder getDataOutputConfiguration() {
            return dataOutputConfiguration != null ? dataOutputConfiguration.toBuilder() : null;
        }

        public final void setDataOutputConfiguration(InferenceOutputConfiguration.BuilderImpl dataOutputConfiguration) {
            this.dataOutputConfiguration = dataOutputConfiguration != null ? dataOutputConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder dataOutputConfiguration(InferenceOutputConfiguration dataOutputConfiguration) {
            this.dataOutputConfiguration = dataOutputConfiguration;
            return this;
        }

        public final S3Object.Builder getCustomerResultObject() {
            return customerResultObject != null ? customerResultObject.toBuilder() : null;
        }

        public final void setCustomerResultObject(S3Object.BuilderImpl customerResultObject) {
            this.customerResultObject = customerResultObject != null ? customerResultObject.build() : null;
        }

        @Override
        @Transient
        public final Builder customerResultObject(S3Object customerResultObject) {
            this.customerResultObject = customerResultObject;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(InferenceExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailedReason() {
            return failedReason;
        }

        public final void setFailedReason(String failedReason) {
            this.failedReason = failedReason;
        }

        @Override
        @Transient
        public final Builder failedReason(String failedReason) {
            this.failedReason = failedReason;
            return this;
        }

        @Override
        public InferenceExecutionSummary build() {
            return new InferenceExecutionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
