/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies configuration information for the input data for the inference, including S3 location of input data..
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceInputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceInputConfiguration.Builder, InferenceInputConfiguration> {
    private static final SdkField<InferenceS3InputConfiguration> S3_INPUT_CONFIGURATION_FIELD = SdkField
            .<InferenceS3InputConfiguration> builder(MarshallingType.SDK_POJO).memberName("S3InputConfiguration")
            .getter(getter(InferenceInputConfiguration::s3InputConfiguration)).setter(setter(Builder::s3InputConfiguration))
            .constructor(InferenceS3InputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3InputConfiguration").build())
            .build();

    private static final SdkField<String> INPUT_TIME_ZONE_OFFSET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputTimeZoneOffset").getter(getter(InferenceInputConfiguration::inputTimeZoneOffset))
            .setter(setter(Builder::inputTimeZoneOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputTimeZoneOffset").build())
            .build();

    private static final SdkField<InferenceInputNameConfiguration> INFERENCE_INPUT_NAME_CONFIGURATION_FIELD = SdkField
            .<InferenceInputNameConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("InferenceInputNameConfiguration")
            .getter(getter(InferenceInputConfiguration::inferenceInputNameConfiguration))
            .setter(setter(Builder::inferenceInputNameConfiguration))
            .constructor(InferenceInputNameConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceInputNameConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_INPUT_CONFIGURATION_FIELD,
            INPUT_TIME_ZONE_OFFSET_FIELD, INFERENCE_INPUT_NAME_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final InferenceS3InputConfiguration s3InputConfiguration;

    private final String inputTimeZoneOffset;

    private final InferenceInputNameConfiguration inferenceInputNameConfiguration;

    private InferenceInputConfiguration(BuilderImpl builder) {
        this.s3InputConfiguration = builder.s3InputConfiguration;
        this.inputTimeZoneOffset = builder.inputTimeZoneOffset;
        this.inferenceInputNameConfiguration = builder.inferenceInputNameConfiguration;
    }

    /**
     * <p>
     * Specifies configuration information for the input data for the inference, including S3 location of input data..
     * </p>
     * 
     * @return Specifies configuration information for the input data for the inference, including S3 location of input
     *         data..
     */
    public final InferenceS3InputConfiguration s3InputConfiguration() {
        return s3InputConfiguration;
    }

    /**
     * <p>
     * Indicates the difference between your time zone and Greenwich Mean Time (GMT).
     * </p>
     * 
     * @return Indicates the difference between your time zone and Greenwich Mean Time (GMT).
     */
    public final String inputTimeZoneOffset() {
        return inputTimeZoneOffset;
    }

    /**
     * <p>
     * Specifies configuration information for the input data for the inference, including timestamp format and
     * delimiter.
     * </p>
     * 
     * @return Specifies configuration information for the input data for the inference, including timestamp format and
     *         delimiter.
     */
    public final InferenceInputNameConfiguration inferenceInputNameConfiguration() {
        return inferenceInputNameConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3InputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(inputTimeZoneOffset());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceInputNameConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceInputConfiguration)) {
            return false;
        }
        InferenceInputConfiguration other = (InferenceInputConfiguration) obj;
        return Objects.equals(s3InputConfiguration(), other.s3InputConfiguration())
                && Objects.equals(inputTimeZoneOffset(), other.inputTimeZoneOffset())
                && Objects.equals(inferenceInputNameConfiguration(), other.inferenceInputNameConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceInputConfiguration").add("S3InputConfiguration", s3InputConfiguration())
                .add("InputTimeZoneOffset", inputTimeZoneOffset())
                .add("InferenceInputNameConfiguration", inferenceInputNameConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3InputConfiguration":
            return Optional.ofNullable(clazz.cast(s3InputConfiguration()));
        case "InputTimeZoneOffset":
            return Optional.ofNullable(clazz.cast(inputTimeZoneOffset()));
        case "InferenceInputNameConfiguration":
            return Optional.ofNullable(clazz.cast(inferenceInputNameConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferenceInputConfiguration, T> g) {
        return obj -> g.apply((InferenceInputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceInputConfiguration> {
        /**
         * <p>
         * Specifies configuration information for the input data for the inference, including S3 location of input
         * data..
         * </p>
         * 
         * @param s3InputConfiguration
         *        Specifies configuration information for the input data for the inference, including S3 location of
         *        input data..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3InputConfiguration(InferenceS3InputConfiguration s3InputConfiguration);

        /**
         * <p>
         * Specifies configuration information for the input data for the inference, including S3 location of input
         * data..
         * </p>
         * This is a convenience that creates an instance of the {@link InferenceS3InputConfiguration.Builder} avoiding
         * the need to create one manually via {@link InferenceS3InputConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link InferenceS3InputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #s3InputConfiguration(InferenceS3InputConfiguration)}.
         * 
         * @param s3InputConfiguration
         *        a consumer that will call methods on {@link InferenceS3InputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3InputConfiguration(InferenceS3InputConfiguration)
         */
        default Builder s3InputConfiguration(Consumer<InferenceS3InputConfiguration.Builder> s3InputConfiguration) {
            return s3InputConfiguration(InferenceS3InputConfiguration.builder().applyMutation(s3InputConfiguration).build());
        }

        /**
         * <p>
         * Indicates the difference between your time zone and Greenwich Mean Time (GMT).
         * </p>
         * 
         * @param inputTimeZoneOffset
         *        Indicates the difference between your time zone and Greenwich Mean Time (GMT).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputTimeZoneOffset(String inputTimeZoneOffset);

        /**
         * <p>
         * Specifies configuration information for the input data for the inference, including timestamp format and
         * delimiter.
         * </p>
         * 
         * @param inferenceInputNameConfiguration
         *        Specifies configuration information for the input data for the inference, including timestamp format
         *        and delimiter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceInputNameConfiguration(InferenceInputNameConfiguration inferenceInputNameConfiguration);

        /**
         * <p>
         * Specifies configuration information for the input data for the inference, including timestamp format and
         * delimiter.
         * </p>
         * This is a convenience that creates an instance of the {@link InferenceInputNameConfiguration.Builder}
         * avoiding the need to create one manually via {@link InferenceInputNameConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link InferenceInputNameConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #inferenceInputNameConfiguration(InferenceInputNameConfiguration)}.
         * 
         * @param inferenceInputNameConfiguration
         *        a consumer that will call methods on {@link InferenceInputNameConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceInputNameConfiguration(InferenceInputNameConfiguration)
         */
        default Builder inferenceInputNameConfiguration(
                Consumer<InferenceInputNameConfiguration.Builder> inferenceInputNameConfiguration) {
            return inferenceInputNameConfiguration(InferenceInputNameConfiguration.builder()
                    .applyMutation(inferenceInputNameConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InferenceS3InputConfiguration s3InputConfiguration;

        private String inputTimeZoneOffset;

        private InferenceInputNameConfiguration inferenceInputNameConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceInputConfiguration model) {
            s3InputConfiguration(model.s3InputConfiguration);
            inputTimeZoneOffset(model.inputTimeZoneOffset);
            inferenceInputNameConfiguration(model.inferenceInputNameConfiguration);
        }

        public final InferenceS3InputConfiguration.Builder getS3InputConfiguration() {
            return s3InputConfiguration != null ? s3InputConfiguration.toBuilder() : null;
        }

        public final void setS3InputConfiguration(InferenceS3InputConfiguration.BuilderImpl s3InputConfiguration) {
            this.s3InputConfiguration = s3InputConfiguration != null ? s3InputConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder s3InputConfiguration(InferenceS3InputConfiguration s3InputConfiguration) {
            this.s3InputConfiguration = s3InputConfiguration;
            return this;
        }

        public final String getInputTimeZoneOffset() {
            return inputTimeZoneOffset;
        }

        public final void setInputTimeZoneOffset(String inputTimeZoneOffset) {
            this.inputTimeZoneOffset = inputTimeZoneOffset;
        }

        @Override
        @Transient
        public final Builder inputTimeZoneOffset(String inputTimeZoneOffset) {
            this.inputTimeZoneOffset = inputTimeZoneOffset;
            return this;
        }

        public final InferenceInputNameConfiguration.Builder getInferenceInputNameConfiguration() {
            return inferenceInputNameConfiguration != null ? inferenceInputNameConfiguration.toBuilder() : null;
        }

        public final void setInferenceInputNameConfiguration(
                InferenceInputNameConfiguration.BuilderImpl inferenceInputNameConfiguration) {
            this.inferenceInputNameConfiguration = inferenceInputNameConfiguration != null ? inferenceInputNameConfiguration
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder inferenceInputNameConfiguration(InferenceInputNameConfiguration inferenceInputNameConfiguration) {
            this.inferenceInputNameConfiguration = inferenceInputNameConfiguration;
            return this;
        }

        @Override
        public InferenceInputConfiguration build() {
            return new InferenceInputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
