/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateInferenceSchedulerRequest extends LookoutEquipmentRequest implements
        ToCopyableBuilder<UpdateInferenceSchedulerRequest.Builder, UpdateInferenceSchedulerRequest> {
    private static final SdkField<String> INFERENCE_SCHEDULER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceSchedulerName").getter(getter(UpdateInferenceSchedulerRequest::inferenceSchedulerName))
            .setter(setter(Builder::inferenceSchedulerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerName").build())
            .build();

    private static final SdkField<Long> DATA_DELAY_OFFSET_IN_MINUTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DataDelayOffsetInMinutes").getter(getter(UpdateInferenceSchedulerRequest::dataDelayOffsetInMinutes))
            .setter(setter(Builder::dataDelayOffsetInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataDelayOffsetInMinutes").build())
            .build();

    private static final SdkField<String> DATA_UPLOAD_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataUploadFrequency").getter(getter(UpdateInferenceSchedulerRequest::dataUploadFrequencyAsString))
            .setter(setter(Builder::dataUploadFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataUploadFrequency").build())
            .build();

    private static final SdkField<InferenceInputConfiguration> DATA_INPUT_CONFIGURATION_FIELD = SdkField
            .<InferenceInputConfiguration> builder(MarshallingType.SDK_POJO).memberName("DataInputConfiguration")
            .getter(getter(UpdateInferenceSchedulerRequest::dataInputConfiguration))
            .setter(setter(Builder::dataInputConfiguration)).constructor(InferenceInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataInputConfiguration").build())
            .build();

    private static final SdkField<InferenceOutputConfiguration> DATA_OUTPUT_CONFIGURATION_FIELD = SdkField
            .<InferenceOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("DataOutputConfiguration")
            .getter(getter(UpdateInferenceSchedulerRequest::dataOutputConfiguration))
            .setter(setter(Builder::dataOutputConfiguration)).constructor(InferenceOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataOutputConfiguration").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(UpdateInferenceSchedulerRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INFERENCE_SCHEDULER_NAME_FIELD, DATA_DELAY_OFFSET_IN_MINUTES_FIELD, DATA_UPLOAD_FREQUENCY_FIELD,
            DATA_INPUT_CONFIGURATION_FIELD, DATA_OUTPUT_CONFIGURATION_FIELD, ROLE_ARN_FIELD));

    private final String inferenceSchedulerName;

    private final Long dataDelayOffsetInMinutes;

    private final String dataUploadFrequency;

    private final InferenceInputConfiguration dataInputConfiguration;

    private final InferenceOutputConfiguration dataOutputConfiguration;

    private final String roleArn;

    private UpdateInferenceSchedulerRequest(BuilderImpl builder) {
        super(builder);
        this.inferenceSchedulerName = builder.inferenceSchedulerName;
        this.dataDelayOffsetInMinutes = builder.dataDelayOffsetInMinutes;
        this.dataUploadFrequency = builder.dataUploadFrequency;
        this.dataInputConfiguration = builder.dataInputConfiguration;
        this.dataOutputConfiguration = builder.dataOutputConfiguration;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The name of the inference scheduler to be updated.
     * </p>
     * 
     * @return The name of the inference scheduler to be updated.
     */
    public final String inferenceSchedulerName() {
        return inferenceSchedulerName;
    }

    /**
     * <p>
     * A period of time (in minutes) by which inference on the data is delayed after the data starts. For instance, if
     * you select an offset delay time of five minutes, inference will not begin on the data until the first data
     * measurement after the five minute mark. For example, if five minutes is selected, the inference scheduler will
     * wake up at the configured frequency with the additional five minute delay time to check the customer S3 bucket.
     * The customer can upload data at the same frequency and they don't need to stop and restart the scheduler when
     * uploading new data.
     * </p>
     * 
     * @return A period of time (in minutes) by which inference on the data is delayed after the data starts. For
     *         instance, if you select an offset delay time of five minutes, inference will not begin on the data until
     *         the first data measurement after the five minute mark. For example, if five minutes is selected, the
     *         inference scheduler will wake up at the configured frequency with the additional five minute delay time
     *         to check the customer S3 bucket. The customer can upload data at the same frequency and they don't need
     *         to stop and restart the scheduler when uploading new data.
     */
    public final Long dataDelayOffsetInMinutes() {
        return dataDelayOffsetInMinutes;
    }

    /**
     * <p>
     * How often data is uploaded to the source S3 bucket for the input data. The value chosen is the length of time
     * between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the
     * real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon Lookout
     * for Equipment starts a scheduled inference on your data. In this example, it starts once every 5 minutes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataUploadFrequency} will return {@link DataUploadFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataUploadFrequencyAsString}.
     * </p>
     * 
     * @return How often data is uploaded to the source S3 bucket for the input data. The value chosen is the length of
     *         time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will
     *         upload the real-time data to the source bucket once every 5 minutes. This frequency also determines how
     *         often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it starts
     *         once every 5 minutes.
     * @see DataUploadFrequency
     */
    public final DataUploadFrequency dataUploadFrequency() {
        return DataUploadFrequency.fromValue(dataUploadFrequency);
    }

    /**
     * <p>
     * How often data is uploaded to the source S3 bucket for the input data. The value chosen is the length of time
     * between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the
     * real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon Lookout
     * for Equipment starts a scheduled inference on your data. In this example, it starts once every 5 minutes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataUploadFrequency} will return {@link DataUploadFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataUploadFrequencyAsString}.
     * </p>
     * 
     * @return How often data is uploaded to the source S3 bucket for the input data. The value chosen is the length of
     *         time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will
     *         upload the real-time data to the source bucket once every 5 minutes. This frequency also determines how
     *         often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it starts
     *         once every 5 minutes.
     * @see DataUploadFrequency
     */
    public final String dataUploadFrequencyAsString() {
        return dataUploadFrequency;
    }

    /**
     * <p>
     * Specifies information for the input data for the inference scheduler, including delimiter, format, and dataset
     * location.
     * </p>
     * 
     * @return Specifies information for the input data for the inference scheduler, including delimiter, format, and
     *         dataset location.
     */
    public final InferenceInputConfiguration dataInputConfiguration() {
        return dataInputConfiguration;
    }

    /**
     * <p>
     * Specifies information for the output results from the inference scheduler, including the output S3 location.
     * </p>
     * 
     * @return Specifies information for the output results from the inference scheduler, including the output S3
     *         location.
     */
    public final InferenceOutputConfiguration dataOutputConfiguration() {
        return dataOutputConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a role with permission to access the data source for the inference scheduler.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a role with permission to access the data source for the inference
     *         scheduler.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSchedulerName());
        hashCode = 31 * hashCode + Objects.hashCode(dataDelayOffsetInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(dataUploadFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dataOutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInferenceSchedulerRequest)) {
            return false;
        }
        UpdateInferenceSchedulerRequest other = (UpdateInferenceSchedulerRequest) obj;
        return Objects.equals(inferenceSchedulerName(), other.inferenceSchedulerName())
                && Objects.equals(dataDelayOffsetInMinutes(), other.dataDelayOffsetInMinutes())
                && Objects.equals(dataUploadFrequencyAsString(), other.dataUploadFrequencyAsString())
                && Objects.equals(dataInputConfiguration(), other.dataInputConfiguration())
                && Objects.equals(dataOutputConfiguration(), other.dataOutputConfiguration())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateInferenceSchedulerRequest").add("InferenceSchedulerName", inferenceSchedulerName())
                .add("DataDelayOffsetInMinutes", dataDelayOffsetInMinutes())
                .add("DataUploadFrequency", dataUploadFrequencyAsString())
                .add("DataInputConfiguration", dataInputConfiguration())
                .add("DataOutputConfiguration", dataOutputConfiguration()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InferenceSchedulerName":
            return Optional.ofNullable(clazz.cast(inferenceSchedulerName()));
        case "DataDelayOffsetInMinutes":
            return Optional.ofNullable(clazz.cast(dataDelayOffsetInMinutes()));
        case "DataUploadFrequency":
            return Optional.ofNullable(clazz.cast(dataUploadFrequencyAsString()));
        case "DataInputConfiguration":
            return Optional.ofNullable(clazz.cast(dataInputConfiguration()));
        case "DataOutputConfiguration":
            return Optional.ofNullable(clazz.cast(dataOutputConfiguration()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInferenceSchedulerRequest, T> g) {
        return obj -> g.apply((UpdateInferenceSchedulerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateInferenceSchedulerRequest> {
        /**
         * <p>
         * The name of the inference scheduler to be updated.
         * </p>
         * 
         * @param inferenceSchedulerName
         *        The name of the inference scheduler to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSchedulerName(String inferenceSchedulerName);

        /**
         * <p>
         * A period of time (in minutes) by which inference on the data is delayed after the data starts. For instance,
         * if you select an offset delay time of five minutes, inference will not begin on the data until the first data
         * measurement after the five minute mark. For example, if five minutes is selected, the inference scheduler
         * will wake up at the configured frequency with the additional five minute delay time to check the customer S3
         * bucket. The customer can upload data at the same frequency and they don't need to stop and restart the
         * scheduler when uploading new data.
         * </p>
         * 
         * @param dataDelayOffsetInMinutes
         *        A period of time (in minutes) by which inference on the data is delayed after the data starts. For
         *        instance, if you select an offset delay time of five minutes, inference will not begin on the data
         *        until the first data measurement after the five minute mark. For example, if five minutes is selected,
         *        the inference scheduler will wake up at the configured frequency with the additional five minute delay
         *        time to check the customer S3 bucket. The customer can upload data at the same frequency and they
         *        don't need to stop and restart the scheduler when uploading new data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataDelayOffsetInMinutes(Long dataDelayOffsetInMinutes);

        /**
         * <p>
         * How often data is uploaded to the source S3 bucket for the input data. The value chosen is the length of time
         * between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the
         * real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon
         * Lookout for Equipment starts a scheduled inference on your data. In this example, it starts once every 5
         * minutes.
         * </p>
         * 
         * @param dataUploadFrequency
         *        How often data is uploaded to the source S3 bucket for the input data. The value chosen is the length
         *        of time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will
         *        upload the real-time data to the source bucket once every 5 minutes. This frequency also determines
         *        how often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it
         *        starts once every 5 minutes.
         * @see DataUploadFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataUploadFrequency
         */
        Builder dataUploadFrequency(String dataUploadFrequency);

        /**
         * <p>
         * How often data is uploaded to the source S3 bucket for the input data. The value chosen is the length of time
         * between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the
         * real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon
         * Lookout for Equipment starts a scheduled inference on your data. In this example, it starts once every 5
         * minutes.
         * </p>
         * 
         * @param dataUploadFrequency
         *        How often data is uploaded to the source S3 bucket for the input data. The value chosen is the length
         *        of time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will
         *        upload the real-time data to the source bucket once every 5 minutes. This frequency also determines
         *        how often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it
         *        starts once every 5 minutes.
         * @see DataUploadFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataUploadFrequency
         */
        Builder dataUploadFrequency(DataUploadFrequency dataUploadFrequency);

        /**
         * <p>
         * Specifies information for the input data for the inference scheduler, including delimiter, format, and
         * dataset location.
         * </p>
         * 
         * @param dataInputConfiguration
         *        Specifies information for the input data for the inference scheduler, including delimiter, format, and
         *        dataset location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataInputConfiguration(InferenceInputConfiguration dataInputConfiguration);

        /**
         * <p>
         * Specifies information for the input data for the inference scheduler, including delimiter, format, and
         * dataset location.
         * </p>
         * This is a convenience that creates an instance of the {@link InferenceInputConfiguration.Builder} avoiding
         * the need to create one manually via {@link InferenceInputConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link InferenceInputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #dataInputConfiguration(InferenceInputConfiguration)}.
         * 
         * @param dataInputConfiguration
         *        a consumer that will call methods on {@link InferenceInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataInputConfiguration(InferenceInputConfiguration)
         */
        default Builder dataInputConfiguration(Consumer<InferenceInputConfiguration.Builder> dataInputConfiguration) {
            return dataInputConfiguration(InferenceInputConfiguration.builder().applyMutation(dataInputConfiguration).build());
        }

        /**
         * <p>
         * Specifies information for the output results from the inference scheduler, including the output S3 location.
         * </p>
         * 
         * @param dataOutputConfiguration
         *        Specifies information for the output results from the inference scheduler, including the output S3
         *        location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataOutputConfiguration(InferenceOutputConfiguration dataOutputConfiguration);

        /**
         * <p>
         * Specifies information for the output results from the inference scheduler, including the output S3 location.
         * </p>
         * This is a convenience that creates an instance of the {@link InferenceOutputConfiguration.Builder} avoiding
         * the need to create one manually via {@link InferenceOutputConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link InferenceOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #dataOutputConfiguration(InferenceOutputConfiguration)}.
         * 
         * @param dataOutputConfiguration
         *        a consumer that will call methods on {@link InferenceOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataOutputConfiguration(InferenceOutputConfiguration)
         */
        default Builder dataOutputConfiguration(Consumer<InferenceOutputConfiguration.Builder> dataOutputConfiguration) {
            return dataOutputConfiguration(InferenceOutputConfiguration.builder().applyMutation(dataOutputConfiguration).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a role with permission to access the data source for the inference
         * scheduler.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of a role with permission to access the data source for the inference
         *        scheduler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutEquipmentRequest.BuilderImpl implements Builder {
        private String inferenceSchedulerName;

        private Long dataDelayOffsetInMinutes;

        private String dataUploadFrequency;

        private InferenceInputConfiguration dataInputConfiguration;

        private InferenceOutputConfiguration dataOutputConfiguration;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInferenceSchedulerRequest model) {
            super(model);
            inferenceSchedulerName(model.inferenceSchedulerName);
            dataDelayOffsetInMinutes(model.dataDelayOffsetInMinutes);
            dataUploadFrequency(model.dataUploadFrequency);
            dataInputConfiguration(model.dataInputConfiguration);
            dataOutputConfiguration(model.dataOutputConfiguration);
            roleArn(model.roleArn);
        }

        public final String getInferenceSchedulerName() {
            return inferenceSchedulerName;
        }

        public final void setInferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
        }

        @Override
        @Transient
        public final Builder inferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
            return this;
        }

        public final Long getDataDelayOffsetInMinutes() {
            return dataDelayOffsetInMinutes;
        }

        public final void setDataDelayOffsetInMinutes(Long dataDelayOffsetInMinutes) {
            this.dataDelayOffsetInMinutes = dataDelayOffsetInMinutes;
        }

        @Override
        @Transient
        public final Builder dataDelayOffsetInMinutes(Long dataDelayOffsetInMinutes) {
            this.dataDelayOffsetInMinutes = dataDelayOffsetInMinutes;
            return this;
        }

        public final String getDataUploadFrequency() {
            return dataUploadFrequency;
        }

        public final void setDataUploadFrequency(String dataUploadFrequency) {
            this.dataUploadFrequency = dataUploadFrequency;
        }

        @Override
        @Transient
        public final Builder dataUploadFrequency(String dataUploadFrequency) {
            this.dataUploadFrequency = dataUploadFrequency;
            return this;
        }

        @Override
        @Transient
        public final Builder dataUploadFrequency(DataUploadFrequency dataUploadFrequency) {
            this.dataUploadFrequency(dataUploadFrequency == null ? null : dataUploadFrequency.toString());
            return this;
        }

        public final InferenceInputConfiguration.Builder getDataInputConfiguration() {
            return dataInputConfiguration != null ? dataInputConfiguration.toBuilder() : null;
        }

        public final void setDataInputConfiguration(InferenceInputConfiguration.BuilderImpl dataInputConfiguration) {
            this.dataInputConfiguration = dataInputConfiguration != null ? dataInputConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder dataInputConfiguration(InferenceInputConfiguration dataInputConfiguration) {
            this.dataInputConfiguration = dataInputConfiguration;
            return this;
        }

        public final InferenceOutputConfiguration.Builder getDataOutputConfiguration() {
            return dataOutputConfiguration != null ? dataOutputConfiguration.toBuilder() : null;
        }

        public final void setDataOutputConfiguration(InferenceOutputConfiguration.BuilderImpl dataOutputConfiguration) {
            this.dataOutputConfiguration = dataOutputConfiguration != null ? dataOutputConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder dataOutputConfiguration(InferenceOutputConfiguration dataOutputConfiguration) {
            this.dataOutputConfiguration = dataOutputConfiguration;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInferenceSchedulerRequest build() {
            return new UpdateInferenceSchedulerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
