/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ModelStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListModelsRequest
extends LookoutEquipmentRequest
implements ToCopyableBuilder<Builder, ListModelsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListModelsRequest.getter(ListModelsRequest::nextToken)).setter(ListModelsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListModelsRequest.getter(ListModelsRequest::maxResults)).setter(ListModelsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListModelsRequest.getter(ListModelsRequest::statusAsString)).setter(ListModelsRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MODEL_NAME_BEGINS_WITH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelNameBeginsWith").getter(ListModelsRequest.getter(ListModelsRequest::modelNameBeginsWith)).setter(ListModelsRequest.setter(Builder::modelNameBeginsWith)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelNameBeginsWith").build()}).build();
    private static final SdkField<String> DATASET_NAME_BEGINS_WITH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetNameBeginsWith").getter(ListModelsRequest.getter(ListModelsRequest::datasetNameBeginsWith)).setter(ListModelsRequest.setter(Builder::datasetNameBeginsWith)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetNameBeginsWith").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, STATUS_FIELD, MODEL_NAME_BEGINS_WITH_FIELD, DATASET_NAME_BEGINS_WITH_FIELD));
    private final String nextToken;
    private final Integer maxResults;
    private final String status;
    private final String modelNameBeginsWith;
    private final String datasetNameBeginsWith;

    private ListModelsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.status = builder.status;
        this.modelNameBeginsWith = builder.modelNameBeginsWith;
        this.datasetNameBeginsWith = builder.datasetNameBeginsWith;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final ModelStatus status() {
        return ModelStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String modelNameBeginsWith() {
        return this.modelNameBeginsWith;
    }

    public final String datasetNameBeginsWith() {
        return this.datasetNameBeginsWith;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelNameBeginsWith());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetNameBeginsWith());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelsRequest)) {
            return false;
        }
        ListModelsRequest other = (ListModelsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.modelNameBeginsWith(), other.modelNameBeginsWith()) && Objects.equals(this.datasetNameBeginsWith(), other.datasetNameBeginsWith());
    }

    public final String toString() {
        return ToString.builder((String)"ListModelsRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("Status", (Object)this.statusAsString()).add("ModelNameBeginsWith", (Object)this.modelNameBeginsWith()).add("DatasetNameBeginsWith", (Object)this.datasetNameBeginsWith()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ModelNameBeginsWith": {
                return Optional.ofNullable(clazz.cast(this.modelNameBeginsWith()));
            }
            case "DatasetNameBeginsWith": {
                return Optional.ofNullable(clazz.cast(this.datasetNameBeginsWith()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListModelsRequest, T> g) {
        return obj -> g.apply((ListModelsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String status;
        private String modelNameBeginsWith;
        private String datasetNameBeginsWith;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.status(model.status);
            this.modelNameBeginsWith(model.modelNameBeginsWith);
            this.datasetNameBeginsWith(model.datasetNameBeginsWith);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getModelNameBeginsWith() {
            return this.modelNameBeginsWith;
        }

        public final void setModelNameBeginsWith(String modelNameBeginsWith) {
            this.modelNameBeginsWith = modelNameBeginsWith;
        }

        @Override
        @Transient
        public final Builder modelNameBeginsWith(String modelNameBeginsWith) {
            this.modelNameBeginsWith = modelNameBeginsWith;
            return this;
        }

        public final String getDatasetNameBeginsWith() {
            return this.datasetNameBeginsWith;
        }

        public final void setDatasetNameBeginsWith(String datasetNameBeginsWith) {
            this.datasetNameBeginsWith = datasetNameBeginsWith;
        }

        @Override
        @Transient
        public final Builder datasetNameBeginsWith(String datasetNameBeginsWith) {
            this.datasetNameBeginsWith = datasetNameBeginsWith;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListModelsRequest build() {
            return new ListModelsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutEquipmentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListModelsRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder status(String var1);

        public Builder status(ModelStatus var1);

        public Builder modelNameBeginsWith(String var1);

        public Builder datasetNameBeginsWith(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

