/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ModelSummariesCopier;
import software.amazon.awssdk.services.lookoutequipment.model.ModelSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListModelsResponse
extends LookoutEquipmentResponse
implements ToCopyableBuilder<Builder, ListModelsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListModelsResponse.getter(ListModelsResponse::nextToken)).setter(ListModelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ModelSummary>> MODEL_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ModelSummaries").getter(ListModelsResponse.getter(ListModelsResponse::modelSummaries)).setter(ListModelsResponse.setter(Builder::modelSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MODEL_SUMMARIES_FIELD));
    private final String nextToken;
    private final List<ModelSummary> modelSummaries;

    private ListModelsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.modelSummaries = builder.modelSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasModelSummaries() {
        return this.modelSummaries != null && !(this.modelSummaries instanceof SdkAutoConstructList);
    }

    public final List<ModelSummary> modelSummaries() {
        return this.modelSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelSummaries() ? this.modelSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelsResponse)) {
            return false;
        }
        ListModelsResponse other = (ListModelsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasModelSummaries() == other.hasModelSummaries() && Objects.equals(this.modelSummaries(), other.modelSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListModelsResponse").add("NextToken", (Object)this.nextToken()).add("ModelSummaries", this.hasModelSummaries() ? this.modelSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ModelSummaries": {
                return Optional.ofNullable(clazz.cast(this.modelSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListModelsResponse, T> g) {
        return obj -> g.apply((ListModelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ModelSummary> modelSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.modelSummaries(model.modelSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ModelSummary.Builder> getModelSummaries() {
            List<ModelSummary.Builder> result = ModelSummariesCopier.copyToBuilder(this.modelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelSummaries(Collection<ModelSummary.BuilderImpl> modelSummaries) {
            this.modelSummaries = ModelSummariesCopier.copyFromBuilder(modelSummaries);
        }

        @Override
        @Transient
        public final Builder modelSummaries(Collection<ModelSummary> modelSummaries) {
            this.modelSummaries = ModelSummariesCopier.copy(modelSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder modelSummaries(ModelSummary ... modelSummaries) {
            this.modelSummaries(Arrays.asList(modelSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder modelSummaries(Consumer<ModelSummary.Builder> ... modelSummaries) {
            this.modelSummaries(Stream.of(modelSummaries).map(c -> (ModelSummary)((ModelSummary.Builder)ModelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListModelsResponse build() {
            return new ListModelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutEquipmentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListModelsResponse> {
        public Builder nextToken(String var1);

        public Builder modelSummaries(Collection<ModelSummary> var1);

        public Builder modelSummaries(ModelSummary ... var1);

        public Builder modelSummaries(Consumer<ModelSummary.Builder> ... var1);
    }
}

