/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInferenceSchedulerResponse extends LookoutEquipmentResponse implements
        ToCopyableBuilder<DescribeInferenceSchedulerResponse.Builder, DescribeInferenceSchedulerResponse> {
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelArn").getter(getter(DescribeInferenceSchedulerResponse::modelArn))
            .setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()).build();

    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(DescribeInferenceSchedulerResponse::modelName))
            .setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> INFERENCE_SCHEDULER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceSchedulerName").getter(getter(DescribeInferenceSchedulerResponse::inferenceSchedulerName))
            .setter(setter(Builder::inferenceSchedulerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerName").build())
            .build();

    private static final SdkField<String> INFERENCE_SCHEDULER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceSchedulerArn").getter(getter(DescribeInferenceSchedulerResponse::inferenceSchedulerArn))
            .setter(setter(Builder::inferenceSchedulerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerArn").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeInferenceSchedulerResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Long> DATA_DELAY_OFFSET_IN_MINUTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DataDelayOffsetInMinutes").getter(getter(DescribeInferenceSchedulerResponse::dataDelayOffsetInMinutes))
            .setter(setter(Builder::dataDelayOffsetInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataDelayOffsetInMinutes").build())
            .build();

    private static final SdkField<String> DATA_UPLOAD_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataUploadFrequency").getter(getter(DescribeInferenceSchedulerResponse::dataUploadFrequencyAsString))
            .setter(setter(Builder::dataUploadFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataUploadFrequency").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(DescribeInferenceSchedulerResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(DescribeInferenceSchedulerResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<InferenceInputConfiguration> DATA_INPUT_CONFIGURATION_FIELD = SdkField
            .<InferenceInputConfiguration> builder(MarshallingType.SDK_POJO).memberName("DataInputConfiguration")
            .getter(getter(DescribeInferenceSchedulerResponse::dataInputConfiguration))
            .setter(setter(Builder::dataInputConfiguration)).constructor(InferenceInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataInputConfiguration").build())
            .build();

    private static final SdkField<InferenceOutputConfiguration> DATA_OUTPUT_CONFIGURATION_FIELD = SdkField
            .<InferenceOutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("DataOutputConfiguration")
            .getter(getter(DescribeInferenceSchedulerResponse::dataOutputConfiguration))
            .setter(setter(Builder::dataOutputConfiguration)).constructor(InferenceOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataOutputConfiguration").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeInferenceSchedulerResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> SERVER_SIDE_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerSideKmsKeyId").getter(getter(DescribeInferenceSchedulerResponse::serverSideKmsKeyId))
            .setter(setter(Builder::serverSideKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideKmsKeyId").build())
            .build();

    private static final SdkField<String> LATEST_INFERENCE_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestInferenceResult")
            .getter(getter(DescribeInferenceSchedulerResponse::latestInferenceResultAsString))
            .setter(setter(Builder::latestInferenceResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestInferenceResult").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ARN_FIELD,
            MODEL_NAME_FIELD, INFERENCE_SCHEDULER_NAME_FIELD, INFERENCE_SCHEDULER_ARN_FIELD, STATUS_FIELD,
            DATA_DELAY_OFFSET_IN_MINUTES_FIELD, DATA_UPLOAD_FREQUENCY_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD,
            DATA_INPUT_CONFIGURATION_FIELD, DATA_OUTPUT_CONFIGURATION_FIELD, ROLE_ARN_FIELD, SERVER_SIDE_KMS_KEY_ID_FIELD,
            LATEST_INFERENCE_RESULT_FIELD));

    private final String modelArn;

    private final String modelName;

    private final String inferenceSchedulerName;

    private final String inferenceSchedulerArn;

    private final String status;

    private final Long dataDelayOffsetInMinutes;

    private final String dataUploadFrequency;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final InferenceInputConfiguration dataInputConfiguration;

    private final InferenceOutputConfiguration dataOutputConfiguration;

    private final String roleArn;

    private final String serverSideKmsKeyId;

    private final String latestInferenceResult;

    private DescribeInferenceSchedulerResponse(BuilderImpl builder) {
        super(builder);
        this.modelArn = builder.modelArn;
        this.modelName = builder.modelName;
        this.inferenceSchedulerName = builder.inferenceSchedulerName;
        this.inferenceSchedulerArn = builder.inferenceSchedulerArn;
        this.status = builder.status;
        this.dataDelayOffsetInMinutes = builder.dataDelayOffsetInMinutes;
        this.dataUploadFrequency = builder.dataUploadFrequency;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.dataInputConfiguration = builder.dataInputConfiguration;
        this.dataOutputConfiguration = builder.dataOutputConfiguration;
        this.roleArn = builder.roleArn;
        this.serverSideKmsKeyId = builder.serverSideKmsKeyId;
        this.latestInferenceResult = builder.latestInferenceResult;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the ML model of the inference scheduler being described.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the ML model of the inference scheduler being described.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * The name of the ML model of the inference scheduler being described.
     * </p>
     * 
     * @return The name of the ML model of the inference scheduler being described.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The name of the inference scheduler being described.
     * </p>
     * 
     * @return The name of the inference scheduler being described.
     */
    public final String inferenceSchedulerName() {
        return inferenceSchedulerName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the inference scheduler being described.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the inference scheduler being described.
     */
    public final String inferenceSchedulerArn() {
        return inferenceSchedulerArn;
    }

    /**
     * <p>
     * Indicates the status of the inference scheduler.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InferenceSchedulerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the inference scheduler.
     * @see InferenceSchedulerStatus
     */
    public final InferenceSchedulerStatus status() {
        return InferenceSchedulerStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates the status of the inference scheduler.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InferenceSchedulerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the inference scheduler.
     * @see InferenceSchedulerStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A period of time (in minutes) by which inference on the data is delayed after the data starts. For instance, if
     * you select an offset delay time of five minutes, inference will not begin on the data until the first data
     * measurement after the five minute mark. For example, if five minutes is selected, the inference scheduler will
     * wake up at the configured frequency with the additional five minute delay time to check the customer S3 bucket.
     * The customer can upload data at the same frequency and they don't need to stop and restart the scheduler when
     * uploading new data.
     * </p>
     * 
     * @return A period of time (in minutes) by which inference on the data is delayed after the data starts. For
     *         instance, if you select an offset delay time of five minutes, inference will not begin on the data until
     *         the first data measurement after the five minute mark. For example, if five minutes is selected, the
     *         inference scheduler will wake up at the configured frequency with the additional five minute delay time
     *         to check the customer S3 bucket. The customer can upload data at the same frequency and they don't need
     *         to stop and restart the scheduler when uploading new data.
     */
    public final Long dataDelayOffsetInMinutes() {
        return dataDelayOffsetInMinutes;
    }

    /**
     * <p>
     * Specifies how often data is uploaded to the source S3 bucket for the input data. This value is the length of time
     * between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the
     * real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon Lookout
     * for Equipment starts a scheduled inference on your data. In this example, it starts once every 5 minutes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataUploadFrequency} will return {@link DataUploadFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataUploadFrequencyAsString}.
     * </p>
     * 
     * @return Specifies how often data is uploaded to the source S3 bucket for the input data. This value is the length
     *         of time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will
     *         upload the real-time data to the source bucket once every 5 minutes. This frequency also determines how
     *         often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it starts
     *         once every 5 minutes.
     * @see DataUploadFrequency
     */
    public final DataUploadFrequency dataUploadFrequency() {
        return DataUploadFrequency.fromValue(dataUploadFrequency);
    }

    /**
     * <p>
     * Specifies how often data is uploaded to the source S3 bucket for the input data. This value is the length of time
     * between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the
     * real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon Lookout
     * for Equipment starts a scheduled inference on your data. In this example, it starts once every 5 minutes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataUploadFrequency} will return {@link DataUploadFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataUploadFrequencyAsString}.
     * </p>
     * 
     * @return Specifies how often data is uploaded to the source S3 bucket for the input data. This value is the length
     *         of time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will
     *         upload the real-time data to the source bucket once every 5 minutes. This frequency also determines how
     *         often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it starts
     *         once every 5 minutes.
     * @see DataUploadFrequency
     */
    public final String dataUploadFrequencyAsString() {
        return dataUploadFrequency;
    }

    /**
     * <p>
     * Specifies the time at which the inference scheduler was created.
     * </p>
     * 
     * @return Specifies the time at which the inference scheduler was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Specifies the time at which the inference scheduler was last updated, if it was.
     * </p>
     * 
     * @return Specifies the time at which the inference scheduler was last updated, if it was.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * Specifies configuration information for the input data for the inference scheduler, including delimiter, format,
     * and dataset location.
     * </p>
     * 
     * @return Specifies configuration information for the input data for the inference scheduler, including delimiter,
     *         format, and dataset location.
     */
    public final InferenceInputConfiguration dataInputConfiguration() {
        return dataInputConfiguration;
    }

    /**
     * <p>
     * Specifies information for the output results for the inference scheduler, including the output S3 location.
     * </p>
     * 
     * @return Specifies information for the output results for the inference scheduler, including the output S3
     *         location.
     */
    public final InferenceOutputConfiguration dataOutputConfiguration() {
        return dataOutputConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a role with permission to access the data source for the inference scheduler
     * being described.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a role with permission to access the data source for the inference
     *         scheduler being described.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Provides the identifier of the KMS key used to encrypt inference scheduler data by Amazon Lookout for Equipment.
     * </p>
     * 
     * @return Provides the identifier of the KMS key used to encrypt inference scheduler data by Amazon Lookout for
     *         Equipment.
     */
    public final String serverSideKmsKeyId() {
        return serverSideKmsKeyId;
    }

    /**
     * <p>
     * Indicates whether the latest execution for the inference scheduler was Anomalous (anomalous events found) or
     * Normal (no anomalous events found).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #latestInferenceResult} will return {@link LatestInferenceResult#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #latestInferenceResultAsString}.
     * </p>
     * 
     * @return Indicates whether the latest execution for the inference scheduler was Anomalous (anomalous events found)
     *         or Normal (no anomalous events found).
     * @see LatestInferenceResult
     */
    public final LatestInferenceResult latestInferenceResult() {
        return LatestInferenceResult.fromValue(latestInferenceResult);
    }

    /**
     * <p>
     * Indicates whether the latest execution for the inference scheduler was Anomalous (anomalous events found) or
     * Normal (no anomalous events found).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #latestInferenceResult} will return {@link LatestInferenceResult#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #latestInferenceResultAsString}.
     * </p>
     * 
     * @return Indicates whether the latest execution for the inference scheduler was Anomalous (anomalous events found)
     *         or Normal (no anomalous events found).
     * @see LatestInferenceResult
     */
    public final String latestInferenceResultAsString() {
        return latestInferenceResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSchedulerName());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSchedulerArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataDelayOffsetInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(dataUploadFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(dataInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dataOutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(latestInferenceResultAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInferenceSchedulerResponse)) {
            return false;
        }
        DescribeInferenceSchedulerResponse other = (DescribeInferenceSchedulerResponse) obj;
        return Objects.equals(modelArn(), other.modelArn()) && Objects.equals(modelName(), other.modelName())
                && Objects.equals(inferenceSchedulerName(), other.inferenceSchedulerName())
                && Objects.equals(inferenceSchedulerArn(), other.inferenceSchedulerArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(dataDelayOffsetInMinutes(), other.dataDelayOffsetInMinutes())
                && Objects.equals(dataUploadFrequencyAsString(), other.dataUploadFrequencyAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(dataInputConfiguration(), other.dataInputConfiguration())
                && Objects.equals(dataOutputConfiguration(), other.dataOutputConfiguration())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(serverSideKmsKeyId(), other.serverSideKmsKeyId())
                && Objects.equals(latestInferenceResultAsString(), other.latestInferenceResultAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInferenceSchedulerResponse").add("ModelArn", modelArn()).add("ModelName", modelName())
                .add("InferenceSchedulerName", inferenceSchedulerName()).add("InferenceSchedulerArn", inferenceSchedulerArn())
                .add("Status", statusAsString()).add("DataDelayOffsetInMinutes", dataDelayOffsetInMinutes())
                .add("DataUploadFrequency", dataUploadFrequencyAsString()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).add("DataInputConfiguration", dataInputConfiguration())
                .add("DataOutputConfiguration", dataOutputConfiguration()).add("RoleArn", roleArn())
                .add("ServerSideKmsKeyId", serverSideKmsKeyId()).add("LatestInferenceResult", latestInferenceResultAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "InferenceSchedulerName":
            return Optional.ofNullable(clazz.cast(inferenceSchedulerName()));
        case "InferenceSchedulerArn":
            return Optional.ofNullable(clazz.cast(inferenceSchedulerArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "DataDelayOffsetInMinutes":
            return Optional.ofNullable(clazz.cast(dataDelayOffsetInMinutes()));
        case "DataUploadFrequency":
            return Optional.ofNullable(clazz.cast(dataUploadFrequencyAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "DataInputConfiguration":
            return Optional.ofNullable(clazz.cast(dataInputConfiguration()));
        case "DataOutputConfiguration":
            return Optional.ofNullable(clazz.cast(dataOutputConfiguration()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "ServerSideKmsKeyId":
            return Optional.ofNullable(clazz.cast(serverSideKmsKeyId()));
        case "LatestInferenceResult":
            return Optional.ofNullable(clazz.cast(latestInferenceResultAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInferenceSchedulerResponse, T> g) {
        return obj -> g.apply((DescribeInferenceSchedulerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInferenceSchedulerResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the ML model of the inference scheduler being described.
         * </p>
         * 
         * @param modelArn
         *        The Amazon Resource Name (ARN) of the ML model of the inference scheduler being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The name of the ML model of the inference scheduler being described.
         * </p>
         * 
         * @param modelName
         *        The name of the ML model of the inference scheduler being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The name of the inference scheduler being described.
         * </p>
         * 
         * @param inferenceSchedulerName
         *        The name of the inference scheduler being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSchedulerName(String inferenceSchedulerName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the inference scheduler being described.
         * </p>
         * 
         * @param inferenceSchedulerArn
         *        The Amazon Resource Name (ARN) of the inference scheduler being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSchedulerArn(String inferenceSchedulerArn);

        /**
         * <p>
         * Indicates the status of the inference scheduler.
         * </p>
         * 
         * @param status
         *        Indicates the status of the inference scheduler.
         * @see InferenceSchedulerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceSchedulerStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates the status of the inference scheduler.
         * </p>
         * 
         * @param status
         *        Indicates the status of the inference scheduler.
         * @see InferenceSchedulerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceSchedulerStatus
         */
        Builder status(InferenceSchedulerStatus status);

        /**
         * <p>
         * A period of time (in minutes) by which inference on the data is delayed after the data starts. For instance,
         * if you select an offset delay time of five minutes, inference will not begin on the data until the first data
         * measurement after the five minute mark. For example, if five minutes is selected, the inference scheduler
         * will wake up at the configured frequency with the additional five minute delay time to check the customer S3
         * bucket. The customer can upload data at the same frequency and they don't need to stop and restart the
         * scheduler when uploading new data.
         * </p>
         * 
         * @param dataDelayOffsetInMinutes
         *        A period of time (in minutes) by which inference on the data is delayed after the data starts. For
         *        instance, if you select an offset delay time of five minutes, inference will not begin on the data
         *        until the first data measurement after the five minute mark. For example, if five minutes is selected,
         *        the inference scheduler will wake up at the configured frequency with the additional five minute delay
         *        time to check the customer S3 bucket. The customer can upload data at the same frequency and they
         *        don't need to stop and restart the scheduler when uploading new data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataDelayOffsetInMinutes(Long dataDelayOffsetInMinutes);

        /**
         * <p>
         * Specifies how often data is uploaded to the source S3 bucket for the input data. This value is the length of
         * time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload
         * the real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon
         * Lookout for Equipment starts a scheduled inference on your data. In this example, it starts once every 5
         * minutes.
         * </p>
         * 
         * @param dataUploadFrequency
         *        Specifies how often data is uploaded to the source S3 bucket for the input data. This value is the
         *        length of time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for
         *        Equipment will upload the real-time data to the source bucket once every 5 minutes. This frequency
         *        also determines how often Amazon Lookout for Equipment starts a scheduled inference on your data. In
         *        this example, it starts once every 5 minutes.
         * @see DataUploadFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataUploadFrequency
         */
        Builder dataUploadFrequency(String dataUploadFrequency);

        /**
         * <p>
         * Specifies how often data is uploaded to the source S3 bucket for the input data. This value is the length of
         * time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload
         * the real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon
         * Lookout for Equipment starts a scheduled inference on your data. In this example, it starts once every 5
         * minutes.
         * </p>
         * 
         * @param dataUploadFrequency
         *        Specifies how often data is uploaded to the source S3 bucket for the input data. This value is the
         *        length of time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for
         *        Equipment will upload the real-time data to the source bucket once every 5 minutes. This frequency
         *        also determines how often Amazon Lookout for Equipment starts a scheduled inference on your data. In
         *        this example, it starts once every 5 minutes.
         * @see DataUploadFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataUploadFrequency
         */
        Builder dataUploadFrequency(DataUploadFrequency dataUploadFrequency);

        /**
         * <p>
         * Specifies the time at which the inference scheduler was created.
         * </p>
         * 
         * @param createdAt
         *        Specifies the time at which the inference scheduler was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Specifies the time at which the inference scheduler was last updated, if it was.
         * </p>
         * 
         * @param updatedAt
         *        Specifies the time at which the inference scheduler was last updated, if it was.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * Specifies configuration information for the input data for the inference scheduler, including delimiter,
         * format, and dataset location.
         * </p>
         * 
         * @param dataInputConfiguration
         *        Specifies configuration information for the input data for the inference scheduler, including
         *        delimiter, format, and dataset location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataInputConfiguration(InferenceInputConfiguration dataInputConfiguration);

        /**
         * <p>
         * Specifies configuration information for the input data for the inference scheduler, including delimiter,
         * format, and dataset location.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceInputConfiguration.Builder}
         * avoiding the need to create one manually via {@link InferenceInputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceInputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #dataInputConfiguration(InferenceInputConfiguration)}.
         * 
         * @param dataInputConfiguration
         *        a consumer that will call methods on {@link InferenceInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataInputConfiguration(InferenceInputConfiguration)
         */
        default Builder dataInputConfiguration(Consumer<InferenceInputConfiguration.Builder> dataInputConfiguration) {
            return dataInputConfiguration(InferenceInputConfiguration.builder().applyMutation(dataInputConfiguration).build());
        }

        /**
         * <p>
         * Specifies information for the output results for the inference scheduler, including the output S3 location.
         * </p>
         * 
         * @param dataOutputConfiguration
         *        Specifies information for the output results for the inference scheduler, including the output S3
         *        location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataOutputConfiguration(InferenceOutputConfiguration dataOutputConfiguration);

        /**
         * <p>
         * Specifies information for the output results for the inference scheduler, including the output S3 location.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceOutputConfiguration.Builder}
         * avoiding the need to create one manually via {@link InferenceOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #dataOutputConfiguration(InferenceOutputConfiguration)}.
         * 
         * @param dataOutputConfiguration
         *        a consumer that will call methods on {@link InferenceOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataOutputConfiguration(InferenceOutputConfiguration)
         */
        default Builder dataOutputConfiguration(Consumer<InferenceOutputConfiguration.Builder> dataOutputConfiguration) {
            return dataOutputConfiguration(InferenceOutputConfiguration.builder().applyMutation(dataOutputConfiguration).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a role with permission to access the data source for the inference
         * scheduler being described.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of a role with permission to access the data source for the inference
         *        scheduler being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Provides the identifier of the KMS key used to encrypt inference scheduler data by Amazon Lookout for
         * Equipment.
         * </p>
         * 
         * @param serverSideKmsKeyId
         *        Provides the identifier of the KMS key used to encrypt inference scheduler data by Amazon Lookout for
         *        Equipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideKmsKeyId(String serverSideKmsKeyId);

        /**
         * <p>
         * Indicates whether the latest execution for the inference scheduler was Anomalous (anomalous events found) or
         * Normal (no anomalous events found).
         * </p>
         * 
         * @param latestInferenceResult
         *        Indicates whether the latest execution for the inference scheduler was Anomalous (anomalous events
         *        found) or Normal (no anomalous events found).
         * @see LatestInferenceResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LatestInferenceResult
         */
        Builder latestInferenceResult(String latestInferenceResult);

        /**
         * <p>
         * Indicates whether the latest execution for the inference scheduler was Anomalous (anomalous events found) or
         * Normal (no anomalous events found).
         * </p>
         * 
         * @param latestInferenceResult
         *        Indicates whether the latest execution for the inference scheduler was Anomalous (anomalous events
         *        found) or Normal (no anomalous events found).
         * @see LatestInferenceResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LatestInferenceResult
         */
        Builder latestInferenceResult(LatestInferenceResult latestInferenceResult);
    }

    static final class BuilderImpl extends LookoutEquipmentResponse.BuilderImpl implements Builder {
        private String modelArn;

        private String modelName;

        private String inferenceSchedulerName;

        private String inferenceSchedulerArn;

        private String status;

        private Long dataDelayOffsetInMinutes;

        private String dataUploadFrequency;

        private Instant createdAt;

        private Instant updatedAt;

        private InferenceInputConfiguration dataInputConfiguration;

        private InferenceOutputConfiguration dataOutputConfiguration;

        private String roleArn;

        private String serverSideKmsKeyId;

        private String latestInferenceResult;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInferenceSchedulerResponse model) {
            super(model);
            modelArn(model.modelArn);
            modelName(model.modelName);
            inferenceSchedulerName(model.inferenceSchedulerName);
            inferenceSchedulerArn(model.inferenceSchedulerArn);
            status(model.status);
            dataDelayOffsetInMinutes(model.dataDelayOffsetInMinutes);
            dataUploadFrequency(model.dataUploadFrequency);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            dataInputConfiguration(model.dataInputConfiguration);
            dataOutputConfiguration(model.dataOutputConfiguration);
            roleArn(model.roleArn);
            serverSideKmsKeyId(model.serverSideKmsKeyId);
            latestInferenceResult(model.latestInferenceResult);
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getInferenceSchedulerName() {
            return inferenceSchedulerName;
        }

        public final void setInferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
        }

        @Override
        public final Builder inferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
            return this;
        }

        public final String getInferenceSchedulerArn() {
            return inferenceSchedulerArn;
        }

        public final void setInferenceSchedulerArn(String inferenceSchedulerArn) {
            this.inferenceSchedulerArn = inferenceSchedulerArn;
        }

        @Override
        public final Builder inferenceSchedulerArn(String inferenceSchedulerArn) {
            this.inferenceSchedulerArn = inferenceSchedulerArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InferenceSchedulerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Long getDataDelayOffsetInMinutes() {
            return dataDelayOffsetInMinutes;
        }

        public final void setDataDelayOffsetInMinutes(Long dataDelayOffsetInMinutes) {
            this.dataDelayOffsetInMinutes = dataDelayOffsetInMinutes;
        }

        @Override
        public final Builder dataDelayOffsetInMinutes(Long dataDelayOffsetInMinutes) {
            this.dataDelayOffsetInMinutes = dataDelayOffsetInMinutes;
            return this;
        }

        public final String getDataUploadFrequency() {
            return dataUploadFrequency;
        }

        public final void setDataUploadFrequency(String dataUploadFrequency) {
            this.dataUploadFrequency = dataUploadFrequency;
        }

        @Override
        public final Builder dataUploadFrequency(String dataUploadFrequency) {
            this.dataUploadFrequency = dataUploadFrequency;
            return this;
        }

        @Override
        public final Builder dataUploadFrequency(DataUploadFrequency dataUploadFrequency) {
            this.dataUploadFrequency(dataUploadFrequency == null ? null : dataUploadFrequency.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final InferenceInputConfiguration.Builder getDataInputConfiguration() {
            return dataInputConfiguration != null ? dataInputConfiguration.toBuilder() : null;
        }

        public final void setDataInputConfiguration(InferenceInputConfiguration.BuilderImpl dataInputConfiguration) {
            this.dataInputConfiguration = dataInputConfiguration != null ? dataInputConfiguration.build() : null;
        }

        @Override
        public final Builder dataInputConfiguration(InferenceInputConfiguration dataInputConfiguration) {
            this.dataInputConfiguration = dataInputConfiguration;
            return this;
        }

        public final InferenceOutputConfiguration.Builder getDataOutputConfiguration() {
            return dataOutputConfiguration != null ? dataOutputConfiguration.toBuilder() : null;
        }

        public final void setDataOutputConfiguration(InferenceOutputConfiguration.BuilderImpl dataOutputConfiguration) {
            this.dataOutputConfiguration = dataOutputConfiguration != null ? dataOutputConfiguration.build() : null;
        }

        @Override
        public final Builder dataOutputConfiguration(InferenceOutputConfiguration dataOutputConfiguration) {
            this.dataOutputConfiguration = dataOutputConfiguration;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getServerSideKmsKeyId() {
            return serverSideKmsKeyId;
        }

        public final void setServerSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
        }

        @Override
        public final Builder serverSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
            return this;
        }

        public final String getLatestInferenceResult() {
            return latestInferenceResult;
        }

        public final void setLatestInferenceResult(String latestInferenceResult) {
            this.latestInferenceResult = latestInferenceResult;
        }

        @Override
        public final Builder latestInferenceResult(String latestInferenceResult) {
            this.latestInferenceResult = latestInferenceResult;
            return this;
        }

        @Override
        public final Builder latestInferenceResult(LatestInferenceResult latestInferenceResult) {
            this.latestInferenceResult(latestInferenceResult == null ? null : latestInferenceResult.toString());
            return this;
        }

        @Override
        public DescribeInferenceSchedulerResponse build() {
            return new DescribeInferenceSchedulerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
