/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLabelsResponse extends LookoutEquipmentResponse implements
        ToCopyableBuilder<ListLabelsResponse.Builder, ListLabelsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLabelsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<LabelSummary>> LABEL_SUMMARIES_FIELD = SdkField
            .<List<LabelSummary>> builder(MarshallingType.LIST)
            .memberName("LabelSummaries")
            .getter(getter(ListLabelsResponse::labelSummaries))
            .setter(setter(Builder::labelSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LabelSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(LabelSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            LABEL_SUMMARIES_FIELD));

    private final String nextToken;

    private final List<LabelSummary> labelSummaries;

    private ListLabelsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.labelSummaries = builder.labelSummaries;
    }

    /**
     * <p>
     * An opaque pagination token indicating where to continue the listing of datasets.
     * </p>
     * 
     * @return An opaque pagination token indicating where to continue the listing of datasets.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LabelSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLabelSummaries() {
        return labelSummaries != null && !(labelSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A summary of the items in the label group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabelSummaries} method.
     * </p>
     * 
     * @return A summary of the items in the label group.
     */
    public final List<LabelSummary> labelSummaries() {
        return labelSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasLabelSummaries() ? labelSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLabelsResponse)) {
            return false;
        }
        ListLabelsResponse other = (ListLabelsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasLabelSummaries() == other.hasLabelSummaries()
                && Objects.equals(labelSummaries(), other.labelSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLabelsResponse").add("NextToken", nextToken())
                .add("LabelSummaries", hasLabelSummaries() ? labelSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "LabelSummaries":
            return Optional.ofNullable(clazz.cast(labelSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLabelsResponse, T> g) {
        return obj -> g.apply((ListLabelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListLabelsResponse> {
        /**
         * <p>
         * An opaque pagination token indicating where to continue the listing of datasets.
         * </p>
         * 
         * @param nextToken
         *        An opaque pagination token indicating where to continue the listing of datasets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A summary of the items in the label group.
         * </p>
         * 
         * @param labelSummaries
         *        A summary of the items in the label group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelSummaries(Collection<LabelSummary> labelSummaries);

        /**
         * <p>
         * A summary of the items in the label group.
         * </p>
         * 
         * @param labelSummaries
         *        A summary of the items in the label group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelSummaries(LabelSummary... labelSummaries);

        /**
         * <p>
         * A summary of the items in the label group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lookoutequipment.model.LabelSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.lookoutequipment.model.LabelSummary#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lookoutequipment.model.LabelSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #labelSummaries(List<LabelSummary>)}.
         * 
         * @param labelSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lookoutequipment.model.LabelSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelSummaries(java.util.Collection<LabelSummary>)
         */
        Builder labelSummaries(Consumer<LabelSummary.Builder>... labelSummaries);
    }

    static final class BuilderImpl extends LookoutEquipmentResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<LabelSummary> labelSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListLabelsResponse model) {
            super(model);
            nextToken(model.nextToken);
            labelSummaries(model.labelSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<LabelSummary.Builder> getLabelSummaries() {
            List<LabelSummary.Builder> result = LabelSummariesCopier.copyToBuilder(this.labelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLabelSummaries(Collection<LabelSummary.BuilderImpl> labelSummaries) {
            this.labelSummaries = LabelSummariesCopier.copyFromBuilder(labelSummaries);
        }

        @Override
        public final Builder labelSummaries(Collection<LabelSummary> labelSummaries) {
            this.labelSummaries = LabelSummariesCopier.copy(labelSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labelSummaries(LabelSummary... labelSummaries) {
            labelSummaries(Arrays.asList(labelSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labelSummaries(Consumer<LabelSummary.Builder>... labelSummaries) {
            labelSummaries(Stream.of(labelSummaries).map(c -> LabelSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListLabelsResponse build() {
            return new ListLabelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
