/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.lookoutequipment.DefaultLookoutEquipmentBaseClientBuilder;
import software.amazon.awssdk.services.lookoutequipment.DefaultLookoutEquipmentClient;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentClient;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentClientBuilder;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentServiceClientConfiguration;
import software.amazon.awssdk.services.lookoutequipment.endpoints.LookoutEquipmentEndpointProvider;

@SdkInternalApi
final class DefaultLookoutEquipmentClientBuilder
extends DefaultLookoutEquipmentBaseClientBuilder<LookoutEquipmentClientBuilder, LookoutEquipmentClient>
implements LookoutEquipmentClientBuilder {
    DefaultLookoutEquipmentClientBuilder() {
    }

    @Override
    public DefaultLookoutEquipmentClientBuilder endpointProvider(LookoutEquipmentEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final LookoutEquipmentClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultLookoutEquipmentClientBuilder.validateClientOptions(clientConfiguration);
        LookoutEquipmentServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultLookoutEquipmentClient client = new DefaultLookoutEquipmentClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private LookoutEquipmentServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return LookoutEquipmentServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

