/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.ModelStatus;
import software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus;
import software.amazon.awssdk.services.lookoutequipment.model.RetrainingSchedulerStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelSummary> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(ModelSummary.getter(ModelSummary::modelName)).setter(ModelSummary.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelArn").getter(ModelSummary.getter(ModelSummary::modelArn)).setter(ModelSummary.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()}).build();
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetName").getter(ModelSummary.getter(ModelSummary::datasetName)).setter(ModelSummary.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()}).build();
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetArn").getter(ModelSummary.getter(ModelSummary::datasetArn)).setter(ModelSummary.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ModelSummary.getter(ModelSummary::statusAsString)).setter(ModelSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(ModelSummary.getter(ModelSummary::createdAt)).setter(ModelSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Long> ACTIVE_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ActiveModelVersion").getter(ModelSummary.getter(ModelSummary::activeModelVersion)).setter(ModelSummary.setter(Builder::activeModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveModelVersion").build()}).build();
    private static final SdkField<String> ACTIVE_MODEL_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActiveModelVersionArn").getter(ModelSummary.getter(ModelSummary::activeModelVersionArn)).setter(ModelSummary.setter(Builder::activeModelVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveModelVersionArn").build()}).build();
    private static final SdkField<String> LATEST_SCHEDULED_RETRAINING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestScheduledRetrainingStatus").getter(ModelSummary.getter(ModelSummary::latestScheduledRetrainingStatusAsString)).setter(ModelSummary.setter(Builder::latestScheduledRetrainingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestScheduledRetrainingStatus").build()}).build();
    private static final SdkField<Long> LATEST_SCHEDULED_RETRAINING_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LatestScheduledRetrainingModelVersion").getter(ModelSummary.getter(ModelSummary::latestScheduledRetrainingModelVersion)).setter(ModelSummary.setter(Builder::latestScheduledRetrainingModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestScheduledRetrainingModelVersion").build()}).build();
    private static final SdkField<Instant> LATEST_SCHEDULED_RETRAINING_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LatestScheduledRetrainingStartTime").getter(ModelSummary.getter(ModelSummary::latestScheduledRetrainingStartTime)).setter(ModelSummary.setter(Builder::latestScheduledRetrainingStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestScheduledRetrainingStartTime").build()}).build();
    private static final SdkField<Instant> NEXT_SCHEDULED_RETRAINING_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("NextScheduledRetrainingStartDate").getter(ModelSummary.getter(ModelSummary::nextScheduledRetrainingStartDate)).setter(ModelSummary.setter(Builder::nextScheduledRetrainingStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextScheduledRetrainingStartDate").build()}).build();
    private static final SdkField<String> RETRAINING_SCHEDULER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RetrainingSchedulerStatus").getter(ModelSummary.getter(ModelSummary::retrainingSchedulerStatusAsString)).setter(ModelSummary.setter(Builder::retrainingSchedulerStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrainingSchedulerStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, MODEL_ARN_FIELD, DATASET_NAME_FIELD, DATASET_ARN_FIELD, STATUS_FIELD, CREATED_AT_FIELD, ACTIVE_MODEL_VERSION_FIELD, ACTIVE_MODEL_VERSION_ARN_FIELD, LATEST_SCHEDULED_RETRAINING_STATUS_FIELD, LATEST_SCHEDULED_RETRAINING_MODEL_VERSION_FIELD, LATEST_SCHEDULED_RETRAINING_START_TIME_FIELD, NEXT_SCHEDULED_RETRAINING_START_DATE_FIELD, RETRAINING_SCHEDULER_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String modelName;
    private final String modelArn;
    private final String datasetName;
    private final String datasetArn;
    private final String status;
    private final Instant createdAt;
    private final Long activeModelVersion;
    private final String activeModelVersionArn;
    private final String latestScheduledRetrainingStatus;
    private final Long latestScheduledRetrainingModelVersion;
    private final Instant latestScheduledRetrainingStartTime;
    private final Instant nextScheduledRetrainingStartDate;
    private final String retrainingSchedulerStatus;

    private ModelSummary(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.modelArn = builder.modelArn;
        this.datasetName = builder.datasetName;
        this.datasetArn = builder.datasetArn;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.activeModelVersion = builder.activeModelVersion;
        this.activeModelVersionArn = builder.activeModelVersionArn;
        this.latestScheduledRetrainingStatus = builder.latestScheduledRetrainingStatus;
        this.latestScheduledRetrainingModelVersion = builder.latestScheduledRetrainingModelVersion;
        this.latestScheduledRetrainingStartTime = builder.latestScheduledRetrainingStartTime;
        this.nextScheduledRetrainingStartDate = builder.nextScheduledRetrainingStartDate;
        this.retrainingSchedulerStatus = builder.retrainingSchedulerStatus;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final String datasetName() {
        return this.datasetName;
    }

    public final String datasetArn() {
        return this.datasetArn;
    }

    public final ModelStatus status() {
        return ModelStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Long activeModelVersion() {
        return this.activeModelVersion;
    }

    public final String activeModelVersionArn() {
        return this.activeModelVersionArn;
    }

    public final ModelVersionStatus latestScheduledRetrainingStatus() {
        return ModelVersionStatus.fromValue(this.latestScheduledRetrainingStatus);
    }

    public final String latestScheduledRetrainingStatusAsString() {
        return this.latestScheduledRetrainingStatus;
    }

    public final Long latestScheduledRetrainingModelVersion() {
        return this.latestScheduledRetrainingModelVersion;
    }

    public final Instant latestScheduledRetrainingStartTime() {
        return this.latestScheduledRetrainingStartTime;
    }

    public final Instant nextScheduledRetrainingStartDate() {
        return this.nextScheduledRetrainingStartDate;
    }

    public final RetrainingSchedulerStatus retrainingSchedulerStatus() {
        return RetrainingSchedulerStatus.fromValue(this.retrainingSchedulerStatus);
    }

    public final String retrainingSchedulerStatusAsString() {
        return this.retrainingSchedulerStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeModelVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestScheduledRetrainingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestScheduledRetrainingModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestScheduledRetrainingStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextScheduledRetrainingStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrainingSchedulerStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelSummary)) {
            return false;
        }
        ModelSummary other = (ModelSummary)obj;
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.datasetArn(), other.datasetArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.activeModelVersion(), other.activeModelVersion()) && Objects.equals(this.activeModelVersionArn(), other.activeModelVersionArn()) && Objects.equals(this.latestScheduledRetrainingStatusAsString(), other.latestScheduledRetrainingStatusAsString()) && Objects.equals(this.latestScheduledRetrainingModelVersion(), other.latestScheduledRetrainingModelVersion()) && Objects.equals(this.latestScheduledRetrainingStartTime(), other.latestScheduledRetrainingStartTime()) && Objects.equals(this.nextScheduledRetrainingStartDate(), other.nextScheduledRetrainingStartDate()) && Objects.equals(this.retrainingSchedulerStatusAsString(), other.retrainingSchedulerStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ModelSummary").add("ModelName", (Object)this.modelName()).add("ModelArn", (Object)this.modelArn()).add("DatasetName", (Object)this.datasetName()).add("DatasetArn", (Object)this.datasetArn()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("ActiveModelVersion", (Object)this.activeModelVersion()).add("ActiveModelVersionArn", (Object)this.activeModelVersionArn()).add("LatestScheduledRetrainingStatus", (Object)this.latestScheduledRetrainingStatusAsString()).add("LatestScheduledRetrainingModelVersion", (Object)this.latestScheduledRetrainingModelVersion()).add("LatestScheduledRetrainingStartTime", (Object)this.latestScheduledRetrainingStartTime()).add("NextScheduledRetrainingStartDate", (Object)this.nextScheduledRetrainingStartDate()).add("RetrainingSchedulerStatus", (Object)this.retrainingSchedulerStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "ModelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "DatasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "DatasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "ActiveModelVersion": {
                return Optional.ofNullable(clazz.cast(this.activeModelVersion()));
            }
            case "ActiveModelVersionArn": {
                return Optional.ofNullable(clazz.cast(this.activeModelVersionArn()));
            }
            case "LatestScheduledRetrainingStatus": {
                return Optional.ofNullable(clazz.cast(this.latestScheduledRetrainingStatusAsString()));
            }
            case "LatestScheduledRetrainingModelVersion": {
                return Optional.ofNullable(clazz.cast(this.latestScheduledRetrainingModelVersion()));
            }
            case "LatestScheduledRetrainingStartTime": {
                return Optional.ofNullable(clazz.cast(this.latestScheduledRetrainingStartTime()));
            }
            case "NextScheduledRetrainingStartDate": {
                return Optional.ofNullable(clazz.cast(this.nextScheduledRetrainingStartDate()));
            }
            case "RetrainingSchedulerStatus": {
                return Optional.ofNullable(clazz.cast(this.retrainingSchedulerStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelSummary, T> g) {
        return obj -> g.apply((ModelSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelName;
        private String modelArn;
        private String datasetName;
        private String datasetArn;
        private String status;
        private Instant createdAt;
        private Long activeModelVersion;
        private String activeModelVersionArn;
        private String latestScheduledRetrainingStatus;
        private Long latestScheduledRetrainingModelVersion;
        private Instant latestScheduledRetrainingStartTime;
        private Instant nextScheduledRetrainingStartDate;
        private String retrainingSchedulerStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelSummary model) {
            this.modelName(model.modelName);
            this.modelArn(model.modelArn);
            this.datasetName(model.datasetName);
            this.datasetArn(model.datasetArn);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.activeModelVersion(model.activeModelVersion);
            this.activeModelVersionArn(model.activeModelVersionArn);
            this.latestScheduledRetrainingStatus(model.latestScheduledRetrainingStatus);
            this.latestScheduledRetrainingModelVersion(model.latestScheduledRetrainingModelVersion);
            this.latestScheduledRetrainingStartTime(model.latestScheduledRetrainingStartTime);
            this.nextScheduledRetrainingStartDate(model.nextScheduledRetrainingStartDate);
            this.retrainingSchedulerStatus(model.retrainingSchedulerStatus);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Long getActiveModelVersion() {
            return this.activeModelVersion;
        }

        public final void setActiveModelVersion(Long activeModelVersion) {
            this.activeModelVersion = activeModelVersion;
        }

        @Override
        public final Builder activeModelVersion(Long activeModelVersion) {
            this.activeModelVersion = activeModelVersion;
            return this;
        }

        public final String getActiveModelVersionArn() {
            return this.activeModelVersionArn;
        }

        public final void setActiveModelVersionArn(String activeModelVersionArn) {
            this.activeModelVersionArn = activeModelVersionArn;
        }

        @Override
        public final Builder activeModelVersionArn(String activeModelVersionArn) {
            this.activeModelVersionArn = activeModelVersionArn;
            return this;
        }

        public final String getLatestScheduledRetrainingStatus() {
            return this.latestScheduledRetrainingStatus;
        }

        public final void setLatestScheduledRetrainingStatus(String latestScheduledRetrainingStatus) {
            this.latestScheduledRetrainingStatus = latestScheduledRetrainingStatus;
        }

        @Override
        public final Builder latestScheduledRetrainingStatus(String latestScheduledRetrainingStatus) {
            this.latestScheduledRetrainingStatus = latestScheduledRetrainingStatus;
            return this;
        }

        @Override
        public final Builder latestScheduledRetrainingStatus(ModelVersionStatus latestScheduledRetrainingStatus) {
            this.latestScheduledRetrainingStatus(latestScheduledRetrainingStatus == null ? null : latestScheduledRetrainingStatus.toString());
            return this;
        }

        public final Long getLatestScheduledRetrainingModelVersion() {
            return this.latestScheduledRetrainingModelVersion;
        }

        public final void setLatestScheduledRetrainingModelVersion(Long latestScheduledRetrainingModelVersion) {
            this.latestScheduledRetrainingModelVersion = latestScheduledRetrainingModelVersion;
        }

        @Override
        public final Builder latestScheduledRetrainingModelVersion(Long latestScheduledRetrainingModelVersion) {
            this.latestScheduledRetrainingModelVersion = latestScheduledRetrainingModelVersion;
            return this;
        }

        public final Instant getLatestScheduledRetrainingStartTime() {
            return this.latestScheduledRetrainingStartTime;
        }

        public final void setLatestScheduledRetrainingStartTime(Instant latestScheduledRetrainingStartTime) {
            this.latestScheduledRetrainingStartTime = latestScheduledRetrainingStartTime;
        }

        @Override
        public final Builder latestScheduledRetrainingStartTime(Instant latestScheduledRetrainingStartTime) {
            this.latestScheduledRetrainingStartTime = latestScheduledRetrainingStartTime;
            return this;
        }

        public final Instant getNextScheduledRetrainingStartDate() {
            return this.nextScheduledRetrainingStartDate;
        }

        public final void setNextScheduledRetrainingStartDate(Instant nextScheduledRetrainingStartDate) {
            this.nextScheduledRetrainingStartDate = nextScheduledRetrainingStartDate;
        }

        @Override
        public final Builder nextScheduledRetrainingStartDate(Instant nextScheduledRetrainingStartDate) {
            this.nextScheduledRetrainingStartDate = nextScheduledRetrainingStartDate;
            return this;
        }

        public final String getRetrainingSchedulerStatus() {
            return this.retrainingSchedulerStatus;
        }

        public final void setRetrainingSchedulerStatus(String retrainingSchedulerStatus) {
            this.retrainingSchedulerStatus = retrainingSchedulerStatus;
        }

        @Override
        public final Builder retrainingSchedulerStatus(String retrainingSchedulerStatus) {
            this.retrainingSchedulerStatus = retrainingSchedulerStatus;
            return this;
        }

        @Override
        public final Builder retrainingSchedulerStatus(RetrainingSchedulerStatus retrainingSchedulerStatus) {
            this.retrainingSchedulerStatus(retrainingSchedulerStatus == null ? null : retrainingSchedulerStatus.toString());
            return this;
        }

        public ModelSummary build() {
            return new ModelSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelSummary> {
        public Builder modelName(String var1);

        public Builder modelArn(String var1);

        public Builder datasetName(String var1);

        public Builder datasetArn(String var1);

        public Builder status(String var1);

        public Builder status(ModelStatus var1);

        public Builder createdAt(Instant var1);

        public Builder activeModelVersion(Long var1);

        public Builder activeModelVersionArn(String var1);

        public Builder latestScheduledRetrainingStatus(String var1);

        public Builder latestScheduledRetrainingStatus(ModelVersionStatus var1);

        public Builder latestScheduledRetrainingModelVersion(Long var1);

        public Builder latestScheduledRetrainingStartTime(Instant var1);

        public Builder nextScheduledRetrainingStartDate(Instant var1);

        public Builder retrainingSchedulerStatus(String var1);

        public Builder retrainingSchedulerStatus(RetrainingSchedulerStatus var1);
    }
}

