/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentClient;
import software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsResponse;

public class ListLabelGroupsIterable
implements SdkIterable<ListLabelGroupsResponse> {
    private final LookoutEquipmentClient client;
    private final ListLabelGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLabelGroupsIterable(LookoutEquipmentClient client, ListLabelGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLabelGroupsResponseFetcher();
    }

    public Iterator<ListLabelGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListLabelGroupsResponseFetcher
    implements SyncPageFetcher<ListLabelGroupsResponse> {
        private ListLabelGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListLabelGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLabelGroupsResponse nextPage(ListLabelGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListLabelGroupsIterable.this.client.listLabelGroups(ListLabelGroupsIterable.this.firstRequest);
            }
            return ListLabelGroupsIterable.this.client.listLabelGroups((ListLabelGroupsRequest)((Object)ListLabelGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

