/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the label.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelSummary implements SdkPojo, Serializable, ToCopyableBuilder<LabelSummary.Builder, LabelSummary> {
    private static final SdkField<String> LABEL_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelGroupName").getter(getter(LabelSummary::labelGroupName)).setter(setter(Builder::labelGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelGroupName").build()).build();

    private static final SdkField<String> LABEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelId").getter(getter(LabelSummary::labelId)).setter(setter(Builder::labelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelId").build()).build();

    private static final SdkField<String> LABEL_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelGroupArn").getter(getter(LabelSummary::labelGroupArn)).setter(setter(Builder::labelGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelGroupArn").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(LabelSummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(LabelSummary::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> RATING_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Rating")
            .getter(getter(LabelSummary::ratingAsString)).setter(setter(Builder::rating))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rating").build()).build();

    private static final SdkField<String> FAULT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FaultCode").getter(getter(LabelSummary::faultCode)).setter(setter(Builder::faultCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaultCode").build()).build();

    private static final SdkField<String> EQUIPMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Equipment").getter(getter(LabelSummary::equipment)).setter(setter(Builder::equipment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Equipment").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(LabelSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_GROUP_NAME_FIELD,
            LABEL_ID_FIELD, LABEL_GROUP_ARN_FIELD, START_TIME_FIELD, END_TIME_FIELD, RATING_FIELD, FAULT_CODE_FIELD,
            EQUIPMENT_FIELD, CREATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String labelGroupName;

    private final String labelId;

    private final String labelGroupArn;

    private final Instant startTime;

    private final Instant endTime;

    private final String rating;

    private final String faultCode;

    private final String equipment;

    private final Instant createdAt;

    private LabelSummary(BuilderImpl builder) {
        this.labelGroupName = builder.labelGroupName;
        this.labelId = builder.labelId;
        this.labelGroupArn = builder.labelGroupArn;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.rating = builder.rating;
        this.faultCode = builder.faultCode;
        this.equipment = builder.equipment;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The name of the label group.
     * </p>
     * 
     * @return The name of the label group.
     */
    public final String labelGroupName() {
        return labelGroupName;
    }

    /**
     * <p>
     * The ID of the label.
     * </p>
     * 
     * @return The ID of the label.
     */
    public final String labelId() {
        return labelId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the label group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the label group.
     */
    public final String labelGroupArn() {
        return labelGroupArn;
    }

    /**
     * <p>
     * The timestamp indicating the start of the label.
     * </p>
     * 
     * @return The timestamp indicating the start of the label.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The timestamp indicating the end of the label.
     * </p>
     * 
     * @return The timestamp indicating the end of the label.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Indicates whether a labeled event represents an anomaly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rating} will
     * return {@link LabelRating#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ratingAsString}.
     * </p>
     * 
     * @return Indicates whether a labeled event represents an anomaly.
     * @see LabelRating
     */
    public final LabelRating rating() {
        return LabelRating.fromValue(rating);
    }

    /**
     * <p>
     * Indicates whether a labeled event represents an anomaly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rating} will
     * return {@link LabelRating#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ratingAsString}.
     * </p>
     * 
     * @return Indicates whether a labeled event represents an anomaly.
     * @see LabelRating
     */
    public final String ratingAsString() {
        return rating;
    }

    /**
     * <p>
     * Indicates the type of anomaly associated with the label.
     * </p>
     * <p>
     * Data in this field will be retained for service usage. Follow best practices for the security of your data.
     * </p>
     * 
     * @return Indicates the type of anomaly associated with the label. </p>
     *         <p>
     *         Data in this field will be retained for service usage. Follow best practices for the security of your
     *         data.
     */
    public final String faultCode() {
        return faultCode;
    }

    /**
     * <p>
     * Indicates that a label pertains to a particular piece of equipment.
     * </p>
     * 
     * @return Indicates that a label pertains to a particular piece of equipment.
     */
    public final String equipment() {
        return equipment;
    }

    /**
     * <p>
     * The time at which the label was created.
     * </p>
     * 
     * @return The time at which the label was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(labelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(labelId());
        hashCode = 31 * hashCode + Objects.hashCode(labelGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(ratingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(faultCode());
        hashCode = 31 * hashCode + Objects.hashCode(equipment());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelSummary)) {
            return false;
        }
        LabelSummary other = (LabelSummary) obj;
        return Objects.equals(labelGroupName(), other.labelGroupName()) && Objects.equals(labelId(), other.labelId())
                && Objects.equals(labelGroupArn(), other.labelGroupArn()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(ratingAsString(), other.ratingAsString())
                && Objects.equals(faultCode(), other.faultCode()) && Objects.equals(equipment(), other.equipment())
                && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LabelSummary").add("LabelGroupName", labelGroupName()).add("LabelId", labelId())
                .add("LabelGroupArn", labelGroupArn()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("Rating", ratingAsString()).add("FaultCode", faultCode()).add("Equipment", equipment())
                .add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LabelGroupName":
            return Optional.ofNullable(clazz.cast(labelGroupName()));
        case "LabelId":
            return Optional.ofNullable(clazz.cast(labelId()));
        case "LabelGroupArn":
            return Optional.ofNullable(clazz.cast(labelGroupArn()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Rating":
            return Optional.ofNullable(clazz.cast(ratingAsString()));
        case "FaultCode":
            return Optional.ofNullable(clazz.cast(faultCode()));
        case "Equipment":
            return Optional.ofNullable(clazz.cast(equipment()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelSummary, T> g) {
        return obj -> g.apply((LabelSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LabelSummary> {
        /**
         * <p>
         * The name of the label group.
         * </p>
         * 
         * @param labelGroupName
         *        The name of the label group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelGroupName(String labelGroupName);

        /**
         * <p>
         * The ID of the label.
         * </p>
         * 
         * @param labelId
         *        The ID of the label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelId(String labelId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the label group.
         * </p>
         * 
         * @param labelGroupArn
         *        The Amazon Resource Name (ARN) of the label group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelGroupArn(String labelGroupArn);

        /**
         * <p>
         * The timestamp indicating the start of the label.
         * </p>
         * 
         * @param startTime
         *        The timestamp indicating the start of the label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The timestamp indicating the end of the label.
         * </p>
         * 
         * @param endTime
         *        The timestamp indicating the end of the label.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Indicates whether a labeled event represents an anomaly.
         * </p>
         * 
         * @param rating
         *        Indicates whether a labeled event represents an anomaly.
         * @see LabelRating
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LabelRating
         */
        Builder rating(String rating);

        /**
         * <p>
         * Indicates whether a labeled event represents an anomaly.
         * </p>
         * 
         * @param rating
         *        Indicates whether a labeled event represents an anomaly.
         * @see LabelRating
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LabelRating
         */
        Builder rating(LabelRating rating);

        /**
         * <p>
         * Indicates the type of anomaly associated with the label.
         * </p>
         * <p>
         * Data in this field will be retained for service usage. Follow best practices for the security of your data.
         * </p>
         * 
         * @param faultCode
         *        Indicates the type of anomaly associated with the label. </p>
         *        <p>
         *        Data in this field will be retained for service usage. Follow best practices for the security of your
         *        data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faultCode(String faultCode);

        /**
         * <p>
         * Indicates that a label pertains to a particular piece of equipment.
         * </p>
         * 
         * @param equipment
         *        Indicates that a label pertains to a particular piece of equipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equipment(String equipment);

        /**
         * <p>
         * The time at which the label was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the label was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl implements Builder {
        private String labelGroupName;

        private String labelId;

        private String labelGroupArn;

        private Instant startTime;

        private Instant endTime;

        private String rating;

        private String faultCode;

        private String equipment;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelSummary model) {
            labelGroupName(model.labelGroupName);
            labelId(model.labelId);
            labelGroupArn(model.labelGroupArn);
            startTime(model.startTime);
            endTime(model.endTime);
            rating(model.rating);
            faultCode(model.faultCode);
            equipment(model.equipment);
            createdAt(model.createdAt);
        }

        public final String getLabelGroupName() {
            return labelGroupName;
        }

        public final void setLabelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
        }

        @Override
        public final Builder labelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
            return this;
        }

        public final String getLabelId() {
            return labelId;
        }

        public final void setLabelId(String labelId) {
            this.labelId = labelId;
        }

        @Override
        public final Builder labelId(String labelId) {
            this.labelId = labelId;
            return this;
        }

        public final String getLabelGroupArn() {
            return labelGroupArn;
        }

        public final void setLabelGroupArn(String labelGroupArn) {
            this.labelGroupArn = labelGroupArn;
        }

        @Override
        public final Builder labelGroupArn(String labelGroupArn) {
            this.labelGroupArn = labelGroupArn;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getRating() {
            return rating;
        }

        public final void setRating(String rating) {
            this.rating = rating;
        }

        @Override
        public final Builder rating(String rating) {
            this.rating = rating;
            return this;
        }

        @Override
        public final Builder rating(LabelRating rating) {
            this.rating(rating == null ? null : rating.toString());
            return this;
        }

        public final String getFaultCode() {
            return faultCode;
        }

        public final void setFaultCode(String faultCode) {
            this.faultCode = faultCode;
        }

        @Override
        public final Builder faultCode(String faultCode) {
            this.faultCode = faultCode;
            return this;
        }

        public final String getEquipment() {
            return equipment;
        }

        public final void setEquipment(String equipment) {
            this.equipment = equipment;
        }

        @Override
        public final Builder equipment(String equipment) {
            this.equipment = equipment;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public LabelSummary build() {
            return new LabelSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
