/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.AutoPromotionResult;
import software.amazon.awssdk.services.lookoutequipment.model.DataPreProcessingConfiguration;
import software.amazon.awssdk.services.lookoutequipment.model.LabelsInputConfiguration;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ModelDiagnosticsOutputConfiguration;
import software.amazon.awssdk.services.lookoutequipment.model.ModelQuality;
import software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSourceType;
import software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus;
import software.amazon.awssdk.services.lookoutequipment.model.S3Object;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeModelVersionResponse
extends LookoutEquipmentResponse
implements ToCopyableBuilder<Builder, DescribeModelVersionResponse> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::modelName)).setter(DescribeModelVersionResponse.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelArn").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::modelArn)).setter(DescribeModelVersionResponse.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()}).build();
    private static final SdkField<Long> MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ModelVersion").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::modelVersion)).setter(DescribeModelVersionResponse.setter(Builder::modelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()}).build();
    private static final SdkField<String> MODEL_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelVersionArn").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::modelVersionArn)).setter(DescribeModelVersionResponse.setter(Builder::modelVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersionArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::statusAsString)).setter(DescribeModelVersionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceType").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::sourceTypeAsString)).setter(DescribeModelVersionResponse.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetName").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::datasetName)).setter(DescribeModelVersionResponse.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()}).build();
    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetArn").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::datasetArn)).setter(DescribeModelVersionResponse.setter(Builder::datasetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()}).build();
    private static final SdkField<String> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Schema").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::schema)).setter(DescribeModelVersionResponse.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()}).build();
    private static final SdkField<LabelsInputConfiguration> LABELS_INPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LabelsInputConfiguration").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::labelsInputConfiguration)).setter(DescribeModelVersionResponse.setter(Builder::labelsInputConfiguration)).constructor(LabelsInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelsInputConfiguration").build()}).build();
    private static final SdkField<Instant> TRAINING_DATA_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TrainingDataStartTime").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::trainingDataStartTime)).setter(DescribeModelVersionResponse.setter(Builder::trainingDataStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingDataStartTime").build()}).build();
    private static final SdkField<Instant> TRAINING_DATA_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TrainingDataEndTime").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::trainingDataEndTime)).setter(DescribeModelVersionResponse.setter(Builder::trainingDataEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingDataEndTime").build()}).build();
    private static final SdkField<Instant> EVALUATION_DATA_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EvaluationDataStartTime").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::evaluationDataStartTime)).setter(DescribeModelVersionResponse.setter(Builder::evaluationDataStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationDataStartTime").build()}).build();
    private static final SdkField<Instant> EVALUATION_DATA_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EvaluationDataEndTime").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::evaluationDataEndTime)).setter(DescribeModelVersionResponse.setter(Builder::evaluationDataEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationDataEndTime").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::roleArn)).setter(DescribeModelVersionResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<DataPreProcessingConfiguration> DATA_PRE_PROCESSING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataPreProcessingConfiguration").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::dataPreProcessingConfiguration)).setter(DescribeModelVersionResponse.setter(Builder::dataPreProcessingConfiguration)).constructor(DataPreProcessingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPreProcessingConfiguration").build()}).build();
    private static final SdkField<Instant> TRAINING_EXECUTION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TrainingExecutionStartTime").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::trainingExecutionStartTime)).setter(DescribeModelVersionResponse.setter(Builder::trainingExecutionStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingExecutionStartTime").build()}).build();
    private static final SdkField<Instant> TRAINING_EXECUTION_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TrainingExecutionEndTime").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::trainingExecutionEndTime)).setter(DescribeModelVersionResponse.setter(Builder::trainingExecutionEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingExecutionEndTime").build()}).build();
    private static final SdkField<String> FAILED_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailedReason").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::failedReason)).setter(DescribeModelVersionResponse.setter(Builder::failedReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedReason").build()}).build();
    private static final SdkField<String> MODEL_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelMetrics").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::modelMetrics)).setter(DescribeModelVersionResponse.setter(Builder::modelMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelMetrics").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::lastUpdatedTime)).setter(DescribeModelVersionResponse.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::createdAt)).setter(DescribeModelVersionResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> SERVER_SIDE_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerSideKmsKeyId").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::serverSideKmsKeyId)).setter(DescribeModelVersionResponse.setter(Builder::serverSideKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideKmsKeyId").build()}).build();
    private static final SdkField<String> OFF_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OffCondition").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::offCondition)).setter(DescribeModelVersionResponse.setter(Builder::offCondition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OffCondition").build()}).build();
    private static final SdkField<String> SOURCE_MODEL_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceModelVersionArn").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::sourceModelVersionArn)).setter(DescribeModelVersionResponse.setter(Builder::sourceModelVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceModelVersionArn").build()}).build();
    private static final SdkField<Instant> IMPORT_JOB_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ImportJobStartTime").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::importJobStartTime)).setter(DescribeModelVersionResponse.setter(Builder::importJobStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportJobStartTime").build()}).build();
    private static final SdkField<Instant> IMPORT_JOB_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ImportJobEndTime").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::importJobEndTime)).setter(DescribeModelVersionResponse.setter(Builder::importJobEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportJobEndTime").build()}).build();
    private static final SdkField<Long> IMPORTED_DATA_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ImportedDataSizeInBytes").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::importedDataSizeInBytes)).setter(DescribeModelVersionResponse.setter(Builder::importedDataSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedDataSizeInBytes").build()}).build();
    private static final SdkField<String> PRIOR_MODEL_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PriorModelMetrics").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::priorModelMetrics)).setter(DescribeModelVersionResponse.setter(Builder::priorModelMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriorModelMetrics").build()}).build();
    private static final SdkField<Integer> RETRAINING_AVAILABLE_DATA_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetrainingAvailableDataInDays").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::retrainingAvailableDataInDays)).setter(DescribeModelVersionResponse.setter(Builder::retrainingAvailableDataInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrainingAvailableDataInDays").build()}).build();
    private static final SdkField<String> AUTO_PROMOTION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoPromotionResult").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::autoPromotionResultAsString)).setter(DescribeModelVersionResponse.setter(Builder::autoPromotionResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoPromotionResult").build()}).build();
    private static final SdkField<String> AUTO_PROMOTION_RESULT_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoPromotionResultReason").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::autoPromotionResultReason)).setter(DescribeModelVersionResponse.setter(Builder::autoPromotionResultReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoPromotionResultReason").build()}).build();
    private static final SdkField<ModelDiagnosticsOutputConfiguration> MODEL_DIAGNOSTICS_OUTPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelDiagnosticsOutputConfiguration").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::modelDiagnosticsOutputConfiguration)).setter(DescribeModelVersionResponse.setter(Builder::modelDiagnosticsOutputConfiguration)).constructor(ModelDiagnosticsOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDiagnosticsOutputConfiguration").build()}).build();
    private static final SdkField<S3Object> MODEL_DIAGNOSTICS_RESULTS_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelDiagnosticsResultsObject").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::modelDiagnosticsResultsObject)).setter(DescribeModelVersionResponse.setter(Builder::modelDiagnosticsResultsObject)).constructor(S3Object::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDiagnosticsResultsObject").build()}).build();
    private static final SdkField<String> MODEL_QUALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelQuality").getter(DescribeModelVersionResponse.getter(DescribeModelVersionResponse::modelQualityAsString)).setter(DescribeModelVersionResponse.setter(Builder::modelQuality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQuality").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, MODEL_ARN_FIELD, MODEL_VERSION_FIELD, MODEL_VERSION_ARN_FIELD, STATUS_FIELD, SOURCE_TYPE_FIELD, DATASET_NAME_FIELD, DATASET_ARN_FIELD, SCHEMA_FIELD, LABELS_INPUT_CONFIGURATION_FIELD, TRAINING_DATA_START_TIME_FIELD, TRAINING_DATA_END_TIME_FIELD, EVALUATION_DATA_START_TIME_FIELD, EVALUATION_DATA_END_TIME_FIELD, ROLE_ARN_FIELD, DATA_PRE_PROCESSING_CONFIGURATION_FIELD, TRAINING_EXECUTION_START_TIME_FIELD, TRAINING_EXECUTION_END_TIME_FIELD, FAILED_REASON_FIELD, MODEL_METRICS_FIELD, LAST_UPDATED_TIME_FIELD, CREATED_AT_FIELD, SERVER_SIDE_KMS_KEY_ID_FIELD, OFF_CONDITION_FIELD, SOURCE_MODEL_VERSION_ARN_FIELD, IMPORT_JOB_START_TIME_FIELD, IMPORT_JOB_END_TIME_FIELD, IMPORTED_DATA_SIZE_IN_BYTES_FIELD, PRIOR_MODEL_METRICS_FIELD, RETRAINING_AVAILABLE_DATA_IN_DAYS_FIELD, AUTO_PROMOTION_RESULT_FIELD, AUTO_PROMOTION_RESULT_REASON_FIELD, MODEL_DIAGNOSTICS_OUTPUT_CONFIGURATION_FIELD, MODEL_DIAGNOSTICS_RESULTS_OBJECT_FIELD, MODEL_QUALITY_FIELD));
    private final String modelName;
    private final String modelArn;
    private final Long modelVersion;
    private final String modelVersionArn;
    private final String status;
    private final String sourceType;
    private final String datasetName;
    private final String datasetArn;
    private final String schema;
    private final LabelsInputConfiguration labelsInputConfiguration;
    private final Instant trainingDataStartTime;
    private final Instant trainingDataEndTime;
    private final Instant evaluationDataStartTime;
    private final Instant evaluationDataEndTime;
    private final String roleArn;
    private final DataPreProcessingConfiguration dataPreProcessingConfiguration;
    private final Instant trainingExecutionStartTime;
    private final Instant trainingExecutionEndTime;
    private final String failedReason;
    private final String modelMetrics;
    private final Instant lastUpdatedTime;
    private final Instant createdAt;
    private final String serverSideKmsKeyId;
    private final String offCondition;
    private final String sourceModelVersionArn;
    private final Instant importJobStartTime;
    private final Instant importJobEndTime;
    private final Long importedDataSizeInBytes;
    private final String priorModelMetrics;
    private final Integer retrainingAvailableDataInDays;
    private final String autoPromotionResult;
    private final String autoPromotionResultReason;
    private final ModelDiagnosticsOutputConfiguration modelDiagnosticsOutputConfiguration;
    private final S3Object modelDiagnosticsResultsObject;
    private final String modelQuality;

    private DescribeModelVersionResponse(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.modelArn = builder.modelArn;
        this.modelVersion = builder.modelVersion;
        this.modelVersionArn = builder.modelVersionArn;
        this.status = builder.status;
        this.sourceType = builder.sourceType;
        this.datasetName = builder.datasetName;
        this.datasetArn = builder.datasetArn;
        this.schema = builder.schema;
        this.labelsInputConfiguration = builder.labelsInputConfiguration;
        this.trainingDataStartTime = builder.trainingDataStartTime;
        this.trainingDataEndTime = builder.trainingDataEndTime;
        this.evaluationDataStartTime = builder.evaluationDataStartTime;
        this.evaluationDataEndTime = builder.evaluationDataEndTime;
        this.roleArn = builder.roleArn;
        this.dataPreProcessingConfiguration = builder.dataPreProcessingConfiguration;
        this.trainingExecutionStartTime = builder.trainingExecutionStartTime;
        this.trainingExecutionEndTime = builder.trainingExecutionEndTime;
        this.failedReason = builder.failedReason;
        this.modelMetrics = builder.modelMetrics;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdAt = builder.createdAt;
        this.serverSideKmsKeyId = builder.serverSideKmsKeyId;
        this.offCondition = builder.offCondition;
        this.sourceModelVersionArn = builder.sourceModelVersionArn;
        this.importJobStartTime = builder.importJobStartTime;
        this.importJobEndTime = builder.importJobEndTime;
        this.importedDataSizeInBytes = builder.importedDataSizeInBytes;
        this.priorModelMetrics = builder.priorModelMetrics;
        this.retrainingAvailableDataInDays = builder.retrainingAvailableDataInDays;
        this.autoPromotionResult = builder.autoPromotionResult;
        this.autoPromotionResultReason = builder.autoPromotionResultReason;
        this.modelDiagnosticsOutputConfiguration = builder.modelDiagnosticsOutputConfiguration;
        this.modelDiagnosticsResultsObject = builder.modelDiagnosticsResultsObject;
        this.modelQuality = builder.modelQuality;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final Long modelVersion() {
        return this.modelVersion;
    }

    public final String modelVersionArn() {
        return this.modelVersionArn;
    }

    public final ModelVersionStatus status() {
        return ModelVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ModelVersionSourceType sourceType() {
        return ModelVersionSourceType.fromValue(this.sourceType);
    }

    public final String sourceTypeAsString() {
        return this.sourceType;
    }

    public final String datasetName() {
        return this.datasetName;
    }

    public final String datasetArn() {
        return this.datasetArn;
    }

    public final String schema() {
        return this.schema;
    }

    public final LabelsInputConfiguration labelsInputConfiguration() {
        return this.labelsInputConfiguration;
    }

    public final Instant trainingDataStartTime() {
        return this.trainingDataStartTime;
    }

    public final Instant trainingDataEndTime() {
        return this.trainingDataEndTime;
    }

    public final Instant evaluationDataStartTime() {
        return this.evaluationDataStartTime;
    }

    public final Instant evaluationDataEndTime() {
        return this.evaluationDataEndTime;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final DataPreProcessingConfiguration dataPreProcessingConfiguration() {
        return this.dataPreProcessingConfiguration;
    }

    public final Instant trainingExecutionStartTime() {
        return this.trainingExecutionStartTime;
    }

    public final Instant trainingExecutionEndTime() {
        return this.trainingExecutionEndTime;
    }

    public final String failedReason() {
        return this.failedReason;
    }

    public final String modelMetrics() {
        return this.modelMetrics;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String serverSideKmsKeyId() {
        return this.serverSideKmsKeyId;
    }

    public final String offCondition() {
        return this.offCondition;
    }

    public final String sourceModelVersionArn() {
        return this.sourceModelVersionArn;
    }

    public final Instant importJobStartTime() {
        return this.importJobStartTime;
    }

    public final Instant importJobEndTime() {
        return this.importJobEndTime;
    }

    public final Long importedDataSizeInBytes() {
        return this.importedDataSizeInBytes;
    }

    public final String priorModelMetrics() {
        return this.priorModelMetrics;
    }

    public final Integer retrainingAvailableDataInDays() {
        return this.retrainingAvailableDataInDays;
    }

    public final AutoPromotionResult autoPromotionResult() {
        return AutoPromotionResult.fromValue(this.autoPromotionResult);
    }

    public final String autoPromotionResultAsString() {
        return this.autoPromotionResult;
    }

    public final String autoPromotionResultReason() {
        return this.autoPromotionResultReason;
    }

    public final ModelDiagnosticsOutputConfiguration modelDiagnosticsOutputConfiguration() {
        return this.modelDiagnosticsOutputConfiguration;
    }

    public final S3Object modelDiagnosticsResultsObject() {
        return this.modelDiagnosticsResultsObject;
    }

    public final ModelQuality modelQuality() {
        return ModelQuality.fromValue(this.modelQuality);
    }

    public final String modelQualityAsString() {
        return this.modelQuality;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelsInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingDataEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationDataStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationDataEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPreProcessingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingExecutionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingExecutionEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.offCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceModelVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.importJobStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.importJobEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.importedDataSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.priorModelMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrainingAvailableDataInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoPromotionResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoPromotionResultReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDiagnosticsOutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDiagnosticsResultsObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelQualityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelVersionResponse)) {
            return false;
        }
        DescribeModelVersionResponse other = (DescribeModelVersionResponse)((Object)obj);
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.modelVersion(), other.modelVersion()) && Objects.equals(this.modelVersionArn(), other.modelVersionArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.datasetArn(), other.datasetArn()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.labelsInputConfiguration(), other.labelsInputConfiguration()) && Objects.equals(this.trainingDataStartTime(), other.trainingDataStartTime()) && Objects.equals(this.trainingDataEndTime(), other.trainingDataEndTime()) && Objects.equals(this.evaluationDataStartTime(), other.evaluationDataStartTime()) && Objects.equals(this.evaluationDataEndTime(), other.evaluationDataEndTime()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.dataPreProcessingConfiguration(), other.dataPreProcessingConfiguration()) && Objects.equals(this.trainingExecutionStartTime(), other.trainingExecutionStartTime()) && Objects.equals(this.trainingExecutionEndTime(), other.trainingExecutionEndTime()) && Objects.equals(this.failedReason(), other.failedReason()) && Objects.equals(this.modelMetrics(), other.modelMetrics()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.serverSideKmsKeyId(), other.serverSideKmsKeyId()) && Objects.equals(this.offCondition(), other.offCondition()) && Objects.equals(this.sourceModelVersionArn(), other.sourceModelVersionArn()) && Objects.equals(this.importJobStartTime(), other.importJobStartTime()) && Objects.equals(this.importJobEndTime(), other.importJobEndTime()) && Objects.equals(this.importedDataSizeInBytes(), other.importedDataSizeInBytes()) && Objects.equals(this.priorModelMetrics(), other.priorModelMetrics()) && Objects.equals(this.retrainingAvailableDataInDays(), other.retrainingAvailableDataInDays()) && Objects.equals(this.autoPromotionResultAsString(), other.autoPromotionResultAsString()) && Objects.equals(this.autoPromotionResultReason(), other.autoPromotionResultReason()) && Objects.equals(this.modelDiagnosticsOutputConfiguration(), other.modelDiagnosticsOutputConfiguration()) && Objects.equals(this.modelDiagnosticsResultsObject(), other.modelDiagnosticsResultsObject()) && Objects.equals(this.modelQualityAsString(), other.modelQualityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeModelVersionResponse").add("ModelName", (Object)this.modelName()).add("ModelArn", (Object)this.modelArn()).add("ModelVersion", (Object)this.modelVersion()).add("ModelVersionArn", (Object)this.modelVersionArn()).add("Status", (Object)this.statusAsString()).add("SourceType", (Object)this.sourceTypeAsString()).add("DatasetName", (Object)this.datasetName()).add("DatasetArn", (Object)this.datasetArn()).add("Schema", (Object)this.schema()).add("LabelsInputConfiguration", (Object)this.labelsInputConfiguration()).add("TrainingDataStartTime", (Object)this.trainingDataStartTime()).add("TrainingDataEndTime", (Object)this.trainingDataEndTime()).add("EvaluationDataStartTime", (Object)this.evaluationDataStartTime()).add("EvaluationDataEndTime", (Object)this.evaluationDataEndTime()).add("RoleArn", (Object)this.roleArn()).add("DataPreProcessingConfiguration", (Object)this.dataPreProcessingConfiguration()).add("TrainingExecutionStartTime", (Object)this.trainingExecutionStartTime()).add("TrainingExecutionEndTime", (Object)this.trainingExecutionEndTime()).add("FailedReason", (Object)this.failedReason()).add("ModelMetrics", (Object)this.modelMetrics()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("CreatedAt", (Object)this.createdAt()).add("ServerSideKmsKeyId", (Object)this.serverSideKmsKeyId()).add("OffCondition", (Object)this.offCondition()).add("SourceModelVersionArn", (Object)this.sourceModelVersionArn()).add("ImportJobStartTime", (Object)this.importJobStartTime()).add("ImportJobEndTime", (Object)this.importJobEndTime()).add("ImportedDataSizeInBytes", (Object)this.importedDataSizeInBytes()).add("PriorModelMetrics", (Object)this.priorModelMetrics()).add("RetrainingAvailableDataInDays", (Object)this.retrainingAvailableDataInDays()).add("AutoPromotionResult", (Object)this.autoPromotionResultAsString()).add("AutoPromotionResultReason", (Object)this.autoPromotionResultReason()).add("ModelDiagnosticsOutputConfiguration", (Object)this.modelDiagnosticsOutputConfiguration()).add("ModelDiagnosticsResultsObject", (Object)this.modelDiagnosticsResultsObject()).add("ModelQuality", (Object)this.modelQualityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "ModelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "ModelVersion": {
                return Optional.ofNullable(clazz.cast(this.modelVersion()));
            }
            case "ModelVersionArn": {
                return Optional.ofNullable(clazz.cast(this.modelVersionArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
            case "DatasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "DatasetArn": {
                return Optional.ofNullable(clazz.cast(this.datasetArn()));
            }
            case "Schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "LabelsInputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.labelsInputConfiguration()));
            }
            case "TrainingDataStartTime": {
                return Optional.ofNullable(clazz.cast(this.trainingDataStartTime()));
            }
            case "TrainingDataEndTime": {
                return Optional.ofNullable(clazz.cast(this.trainingDataEndTime()));
            }
            case "EvaluationDataStartTime": {
                return Optional.ofNullable(clazz.cast(this.evaluationDataStartTime()));
            }
            case "EvaluationDataEndTime": {
                return Optional.ofNullable(clazz.cast(this.evaluationDataEndTime()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "DataPreProcessingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataPreProcessingConfiguration()));
            }
            case "TrainingExecutionStartTime": {
                return Optional.ofNullable(clazz.cast(this.trainingExecutionStartTime()));
            }
            case "TrainingExecutionEndTime": {
                return Optional.ofNullable(clazz.cast(this.trainingExecutionEndTime()));
            }
            case "FailedReason": {
                return Optional.ofNullable(clazz.cast(this.failedReason()));
            }
            case "ModelMetrics": {
                return Optional.ofNullable(clazz.cast(this.modelMetrics()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "ServerSideKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.serverSideKmsKeyId()));
            }
            case "OffCondition": {
                return Optional.ofNullable(clazz.cast(this.offCondition()));
            }
            case "SourceModelVersionArn": {
                return Optional.ofNullable(clazz.cast(this.sourceModelVersionArn()));
            }
            case "ImportJobStartTime": {
                return Optional.ofNullable(clazz.cast(this.importJobStartTime()));
            }
            case "ImportJobEndTime": {
                return Optional.ofNullable(clazz.cast(this.importJobEndTime()));
            }
            case "ImportedDataSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.importedDataSizeInBytes()));
            }
            case "PriorModelMetrics": {
                return Optional.ofNullable(clazz.cast(this.priorModelMetrics()));
            }
            case "RetrainingAvailableDataInDays": {
                return Optional.ofNullable(clazz.cast(this.retrainingAvailableDataInDays()));
            }
            case "AutoPromotionResult": {
                return Optional.ofNullable(clazz.cast(this.autoPromotionResultAsString()));
            }
            case "AutoPromotionResultReason": {
                return Optional.ofNullable(clazz.cast(this.autoPromotionResultReason()));
            }
            case "ModelDiagnosticsOutputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.modelDiagnosticsOutputConfiguration()));
            }
            case "ModelDiagnosticsResultsObject": {
                return Optional.ofNullable(clazz.cast(this.modelDiagnosticsResultsObject()));
            }
            case "ModelQuality": {
                return Optional.ofNullable(clazz.cast(this.modelQualityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelVersionResponse, T> g) {
        return obj -> g.apply((DescribeModelVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentResponse.BuilderImpl
    implements Builder {
        private String modelName;
        private String modelArn;
        private Long modelVersion;
        private String modelVersionArn;
        private String status;
        private String sourceType;
        private String datasetName;
        private String datasetArn;
        private String schema;
        private LabelsInputConfiguration labelsInputConfiguration;
        private Instant trainingDataStartTime;
        private Instant trainingDataEndTime;
        private Instant evaluationDataStartTime;
        private Instant evaluationDataEndTime;
        private String roleArn;
        private DataPreProcessingConfiguration dataPreProcessingConfiguration;
        private Instant trainingExecutionStartTime;
        private Instant trainingExecutionEndTime;
        private String failedReason;
        private String modelMetrics;
        private Instant lastUpdatedTime;
        private Instant createdAt;
        private String serverSideKmsKeyId;
        private String offCondition;
        private String sourceModelVersionArn;
        private Instant importJobStartTime;
        private Instant importJobEndTime;
        private Long importedDataSizeInBytes;
        private String priorModelMetrics;
        private Integer retrainingAvailableDataInDays;
        private String autoPromotionResult;
        private String autoPromotionResultReason;
        private ModelDiagnosticsOutputConfiguration modelDiagnosticsOutputConfiguration;
        private S3Object modelDiagnosticsResultsObject;
        private String modelQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelVersionResponse model) {
            super(model);
            this.modelName(model.modelName);
            this.modelArn(model.modelArn);
            this.modelVersion(model.modelVersion);
            this.modelVersionArn(model.modelVersionArn);
            this.status(model.status);
            this.sourceType(model.sourceType);
            this.datasetName(model.datasetName);
            this.datasetArn(model.datasetArn);
            this.schema(model.schema);
            this.labelsInputConfiguration(model.labelsInputConfiguration);
            this.trainingDataStartTime(model.trainingDataStartTime);
            this.trainingDataEndTime(model.trainingDataEndTime);
            this.evaluationDataStartTime(model.evaluationDataStartTime);
            this.evaluationDataEndTime(model.evaluationDataEndTime);
            this.roleArn(model.roleArn);
            this.dataPreProcessingConfiguration(model.dataPreProcessingConfiguration);
            this.trainingExecutionStartTime(model.trainingExecutionStartTime);
            this.trainingExecutionEndTime(model.trainingExecutionEndTime);
            this.failedReason(model.failedReason);
            this.modelMetrics(model.modelMetrics);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.createdAt(model.createdAt);
            this.serverSideKmsKeyId(model.serverSideKmsKeyId);
            this.offCondition(model.offCondition);
            this.sourceModelVersionArn(model.sourceModelVersionArn);
            this.importJobStartTime(model.importJobStartTime);
            this.importJobEndTime(model.importJobEndTime);
            this.importedDataSizeInBytes(model.importedDataSizeInBytes);
            this.priorModelMetrics(model.priorModelMetrics);
            this.retrainingAvailableDataInDays(model.retrainingAvailableDataInDays);
            this.autoPromotionResult(model.autoPromotionResult);
            this.autoPromotionResultReason(model.autoPromotionResultReason);
            this.modelDiagnosticsOutputConfiguration(model.modelDiagnosticsOutputConfiguration);
            this.modelDiagnosticsResultsObject(model.modelDiagnosticsResultsObject);
            this.modelQuality(model.modelQuality);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final Long getModelVersion() {
            return this.modelVersion;
        }

        public final void setModelVersion(Long modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(Long modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final String getModelVersionArn() {
            return this.modelVersionArn;
        }

        public final void setModelVersionArn(String modelVersionArn) {
            this.modelVersionArn = modelVersionArn;
        }

        @Override
        public final Builder modelVersionArn(String modelVersionArn) {
            this.modelVersionArn = modelVersionArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(ModelVersionSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getDatasetArn() {
            return this.datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getSchema() {
            return this.schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final LabelsInputConfiguration.Builder getLabelsInputConfiguration() {
            return this.labelsInputConfiguration != null ? this.labelsInputConfiguration.toBuilder() : null;
        }

        public final void setLabelsInputConfiguration(LabelsInputConfiguration.BuilderImpl labelsInputConfiguration) {
            this.labelsInputConfiguration = labelsInputConfiguration != null ? labelsInputConfiguration.build() : null;
        }

        @Override
        public final Builder labelsInputConfiguration(LabelsInputConfiguration labelsInputConfiguration) {
            this.labelsInputConfiguration = labelsInputConfiguration;
            return this;
        }

        public final Instant getTrainingDataStartTime() {
            return this.trainingDataStartTime;
        }

        public final void setTrainingDataStartTime(Instant trainingDataStartTime) {
            this.trainingDataStartTime = trainingDataStartTime;
        }

        @Override
        public final Builder trainingDataStartTime(Instant trainingDataStartTime) {
            this.trainingDataStartTime = trainingDataStartTime;
            return this;
        }

        public final Instant getTrainingDataEndTime() {
            return this.trainingDataEndTime;
        }

        public final void setTrainingDataEndTime(Instant trainingDataEndTime) {
            this.trainingDataEndTime = trainingDataEndTime;
        }

        @Override
        public final Builder trainingDataEndTime(Instant trainingDataEndTime) {
            this.trainingDataEndTime = trainingDataEndTime;
            return this;
        }

        public final Instant getEvaluationDataStartTime() {
            return this.evaluationDataStartTime;
        }

        public final void setEvaluationDataStartTime(Instant evaluationDataStartTime) {
            this.evaluationDataStartTime = evaluationDataStartTime;
        }

        @Override
        public final Builder evaluationDataStartTime(Instant evaluationDataStartTime) {
            this.evaluationDataStartTime = evaluationDataStartTime;
            return this;
        }

        public final Instant getEvaluationDataEndTime() {
            return this.evaluationDataEndTime;
        }

        public final void setEvaluationDataEndTime(Instant evaluationDataEndTime) {
            this.evaluationDataEndTime = evaluationDataEndTime;
        }

        @Override
        public final Builder evaluationDataEndTime(Instant evaluationDataEndTime) {
            this.evaluationDataEndTime = evaluationDataEndTime;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final DataPreProcessingConfiguration.Builder getDataPreProcessingConfiguration() {
            return this.dataPreProcessingConfiguration != null ? this.dataPreProcessingConfiguration.toBuilder() : null;
        }

        public final void setDataPreProcessingConfiguration(DataPreProcessingConfiguration.BuilderImpl dataPreProcessingConfiguration) {
            this.dataPreProcessingConfiguration = dataPreProcessingConfiguration != null ? dataPreProcessingConfiguration.build() : null;
        }

        @Override
        public final Builder dataPreProcessingConfiguration(DataPreProcessingConfiguration dataPreProcessingConfiguration) {
            this.dataPreProcessingConfiguration = dataPreProcessingConfiguration;
            return this;
        }

        public final Instant getTrainingExecutionStartTime() {
            return this.trainingExecutionStartTime;
        }

        public final void setTrainingExecutionStartTime(Instant trainingExecutionStartTime) {
            this.trainingExecutionStartTime = trainingExecutionStartTime;
        }

        @Override
        public final Builder trainingExecutionStartTime(Instant trainingExecutionStartTime) {
            this.trainingExecutionStartTime = trainingExecutionStartTime;
            return this;
        }

        public final Instant getTrainingExecutionEndTime() {
            return this.trainingExecutionEndTime;
        }

        public final void setTrainingExecutionEndTime(Instant trainingExecutionEndTime) {
            this.trainingExecutionEndTime = trainingExecutionEndTime;
        }

        @Override
        public final Builder trainingExecutionEndTime(Instant trainingExecutionEndTime) {
            this.trainingExecutionEndTime = trainingExecutionEndTime;
            return this;
        }

        public final String getFailedReason() {
            return this.failedReason;
        }

        public final void setFailedReason(String failedReason) {
            this.failedReason = failedReason;
        }

        @Override
        public final Builder failedReason(String failedReason) {
            this.failedReason = failedReason;
            return this;
        }

        public final String getModelMetrics() {
            return this.modelMetrics;
        }

        public final void setModelMetrics(String modelMetrics) {
            this.modelMetrics = modelMetrics;
        }

        @Override
        public final Builder modelMetrics(String modelMetrics) {
            this.modelMetrics = modelMetrics;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getServerSideKmsKeyId() {
            return this.serverSideKmsKeyId;
        }

        public final void setServerSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
        }

        @Override
        public final Builder serverSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
            return this;
        }

        public final String getOffCondition() {
            return this.offCondition;
        }

        public final void setOffCondition(String offCondition) {
            this.offCondition = offCondition;
        }

        @Override
        public final Builder offCondition(String offCondition) {
            this.offCondition = offCondition;
            return this;
        }

        public final String getSourceModelVersionArn() {
            return this.sourceModelVersionArn;
        }

        public final void setSourceModelVersionArn(String sourceModelVersionArn) {
            this.sourceModelVersionArn = sourceModelVersionArn;
        }

        @Override
        public final Builder sourceModelVersionArn(String sourceModelVersionArn) {
            this.sourceModelVersionArn = sourceModelVersionArn;
            return this;
        }

        public final Instant getImportJobStartTime() {
            return this.importJobStartTime;
        }

        public final void setImportJobStartTime(Instant importJobStartTime) {
            this.importJobStartTime = importJobStartTime;
        }

        @Override
        public final Builder importJobStartTime(Instant importJobStartTime) {
            this.importJobStartTime = importJobStartTime;
            return this;
        }

        public final Instant getImportJobEndTime() {
            return this.importJobEndTime;
        }

        public final void setImportJobEndTime(Instant importJobEndTime) {
            this.importJobEndTime = importJobEndTime;
        }

        @Override
        public final Builder importJobEndTime(Instant importJobEndTime) {
            this.importJobEndTime = importJobEndTime;
            return this;
        }

        public final Long getImportedDataSizeInBytes() {
            return this.importedDataSizeInBytes;
        }

        public final void setImportedDataSizeInBytes(Long importedDataSizeInBytes) {
            this.importedDataSizeInBytes = importedDataSizeInBytes;
        }

        @Override
        public final Builder importedDataSizeInBytes(Long importedDataSizeInBytes) {
            this.importedDataSizeInBytes = importedDataSizeInBytes;
            return this;
        }

        public final String getPriorModelMetrics() {
            return this.priorModelMetrics;
        }

        public final void setPriorModelMetrics(String priorModelMetrics) {
            this.priorModelMetrics = priorModelMetrics;
        }

        @Override
        public final Builder priorModelMetrics(String priorModelMetrics) {
            this.priorModelMetrics = priorModelMetrics;
            return this;
        }

        public final Integer getRetrainingAvailableDataInDays() {
            return this.retrainingAvailableDataInDays;
        }

        public final void setRetrainingAvailableDataInDays(Integer retrainingAvailableDataInDays) {
            this.retrainingAvailableDataInDays = retrainingAvailableDataInDays;
        }

        @Override
        public final Builder retrainingAvailableDataInDays(Integer retrainingAvailableDataInDays) {
            this.retrainingAvailableDataInDays = retrainingAvailableDataInDays;
            return this;
        }

        public final String getAutoPromotionResult() {
            return this.autoPromotionResult;
        }

        public final void setAutoPromotionResult(String autoPromotionResult) {
            this.autoPromotionResult = autoPromotionResult;
        }

        @Override
        public final Builder autoPromotionResult(String autoPromotionResult) {
            this.autoPromotionResult = autoPromotionResult;
            return this;
        }

        @Override
        public final Builder autoPromotionResult(AutoPromotionResult autoPromotionResult) {
            this.autoPromotionResult(autoPromotionResult == null ? null : autoPromotionResult.toString());
            return this;
        }

        public final String getAutoPromotionResultReason() {
            return this.autoPromotionResultReason;
        }

        public final void setAutoPromotionResultReason(String autoPromotionResultReason) {
            this.autoPromotionResultReason = autoPromotionResultReason;
        }

        @Override
        public final Builder autoPromotionResultReason(String autoPromotionResultReason) {
            this.autoPromotionResultReason = autoPromotionResultReason;
            return this;
        }

        public final ModelDiagnosticsOutputConfiguration.Builder getModelDiagnosticsOutputConfiguration() {
            return this.modelDiagnosticsOutputConfiguration != null ? this.modelDiagnosticsOutputConfiguration.toBuilder() : null;
        }

        public final void setModelDiagnosticsOutputConfiguration(ModelDiagnosticsOutputConfiguration.BuilderImpl modelDiagnosticsOutputConfiguration) {
            this.modelDiagnosticsOutputConfiguration = modelDiagnosticsOutputConfiguration != null ? modelDiagnosticsOutputConfiguration.build() : null;
        }

        @Override
        public final Builder modelDiagnosticsOutputConfiguration(ModelDiagnosticsOutputConfiguration modelDiagnosticsOutputConfiguration) {
            this.modelDiagnosticsOutputConfiguration = modelDiagnosticsOutputConfiguration;
            return this;
        }

        public final S3Object.Builder getModelDiagnosticsResultsObject() {
            return this.modelDiagnosticsResultsObject != null ? this.modelDiagnosticsResultsObject.toBuilder() : null;
        }

        public final void setModelDiagnosticsResultsObject(S3Object.BuilderImpl modelDiagnosticsResultsObject) {
            this.modelDiagnosticsResultsObject = modelDiagnosticsResultsObject != null ? modelDiagnosticsResultsObject.build() : null;
        }

        @Override
        public final Builder modelDiagnosticsResultsObject(S3Object modelDiagnosticsResultsObject) {
            this.modelDiagnosticsResultsObject = modelDiagnosticsResultsObject;
            return this;
        }

        public final String getModelQuality() {
            return this.modelQuality;
        }

        public final void setModelQuality(String modelQuality) {
            this.modelQuality = modelQuality;
        }

        @Override
        public final Builder modelQuality(String modelQuality) {
            this.modelQuality = modelQuality;
            return this;
        }

        @Override
        public final Builder modelQuality(ModelQuality modelQuality) {
            this.modelQuality(modelQuality == null ? null : modelQuality.toString());
            return this;
        }

        @Override
        public DescribeModelVersionResponse build() {
            return new DescribeModelVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutEquipmentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeModelVersionResponse> {
        public Builder modelName(String var1);

        public Builder modelArn(String var1);

        public Builder modelVersion(Long var1);

        public Builder modelVersionArn(String var1);

        public Builder status(String var1);

        public Builder status(ModelVersionStatus var1);

        public Builder sourceType(String var1);

        public Builder sourceType(ModelVersionSourceType var1);

        public Builder datasetName(String var1);

        public Builder datasetArn(String var1);

        public Builder schema(String var1);

        public Builder labelsInputConfiguration(LabelsInputConfiguration var1);

        default public Builder labelsInputConfiguration(Consumer<LabelsInputConfiguration.Builder> labelsInputConfiguration) {
            return this.labelsInputConfiguration((LabelsInputConfiguration)((LabelsInputConfiguration.Builder)LabelsInputConfiguration.builder().applyMutation(labelsInputConfiguration)).build());
        }

        public Builder trainingDataStartTime(Instant var1);

        public Builder trainingDataEndTime(Instant var1);

        public Builder evaluationDataStartTime(Instant var1);

        public Builder evaluationDataEndTime(Instant var1);

        public Builder roleArn(String var1);

        public Builder dataPreProcessingConfiguration(DataPreProcessingConfiguration var1);

        default public Builder dataPreProcessingConfiguration(Consumer<DataPreProcessingConfiguration.Builder> dataPreProcessingConfiguration) {
            return this.dataPreProcessingConfiguration((DataPreProcessingConfiguration)((DataPreProcessingConfiguration.Builder)DataPreProcessingConfiguration.builder().applyMutation(dataPreProcessingConfiguration)).build());
        }

        public Builder trainingExecutionStartTime(Instant var1);

        public Builder trainingExecutionEndTime(Instant var1);

        public Builder failedReason(String var1);

        public Builder modelMetrics(String var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder createdAt(Instant var1);

        public Builder serverSideKmsKeyId(String var1);

        public Builder offCondition(String var1);

        public Builder sourceModelVersionArn(String var1);

        public Builder importJobStartTime(Instant var1);

        public Builder importJobEndTime(Instant var1);

        public Builder importedDataSizeInBytes(Long var1);

        public Builder priorModelMetrics(String var1);

        public Builder retrainingAvailableDataInDays(Integer var1);

        public Builder autoPromotionResult(String var1);

        public Builder autoPromotionResult(AutoPromotionResult var1);

        public Builder autoPromotionResultReason(String var1);

        public Builder modelDiagnosticsOutputConfiguration(ModelDiagnosticsOutputConfiguration var1);

        default public Builder modelDiagnosticsOutputConfiguration(Consumer<ModelDiagnosticsOutputConfiguration.Builder> modelDiagnosticsOutputConfiguration) {
            return this.modelDiagnosticsOutputConfiguration((ModelDiagnosticsOutputConfiguration)((ModelDiagnosticsOutputConfiguration.Builder)ModelDiagnosticsOutputConfiguration.builder().applyMutation(modelDiagnosticsOutputConfiguration)).build());
        }

        public Builder modelDiagnosticsResultsObject(S3Object var1);

        default public Builder modelDiagnosticsResultsObject(Consumer<S3Object.Builder> modelDiagnosticsResultsObject) {
            return this.modelDiagnosticsResultsObject((S3Object)((S3Object.Builder)S3Object.builder().applyMutation(modelDiagnosticsResultsObject)).build());
        }

        public Builder modelQuality(String var1);

        public Builder modelQuality(ModelQuality var1);
    }
}

