/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Entity that comprises aggregated information on sensors having missing data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MissingSensorData implements SdkPojo, Serializable,
        ToCopyableBuilder<MissingSensorData.Builder, MissingSensorData> {
    private static final SdkField<Integer> AFFECTED_SENSOR_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AffectedSensorCount").getter(getter(MissingSensorData::affectedSensorCount))
            .setter(setter(Builder::affectedSensorCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AffectedSensorCount").build())
            .build();

    private static final SdkField<Integer> TOTAL_NUMBER_OF_MISSING_VALUES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalNumberOfMissingValues")
            .getter(getter(MissingSensorData::totalNumberOfMissingValues))
            .setter(setter(Builder::totalNumberOfMissingValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfMissingValues").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFFECTED_SENSOR_COUNT_FIELD,
            TOTAL_NUMBER_OF_MISSING_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer affectedSensorCount;

    private final Integer totalNumberOfMissingValues;

    private MissingSensorData(BuilderImpl builder) {
        this.affectedSensorCount = builder.affectedSensorCount;
        this.totalNumberOfMissingValues = builder.totalNumberOfMissingValues;
    }

    /**
     * <p>
     * Indicates the number of sensors that have atleast some data missing.
     * </p>
     * 
     * @return Indicates the number of sensors that have atleast some data missing.
     */
    public final Integer affectedSensorCount() {
        return affectedSensorCount;
    }

    /**
     * <p>
     * Indicates the total number of missing values across all the sensors.
     * </p>
     * 
     * @return Indicates the total number of missing values across all the sensors.
     */
    public final Integer totalNumberOfMissingValues() {
        return totalNumberOfMissingValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(affectedSensorCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalNumberOfMissingValues());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MissingSensorData)) {
            return false;
        }
        MissingSensorData other = (MissingSensorData) obj;
        return Objects.equals(affectedSensorCount(), other.affectedSensorCount())
                && Objects.equals(totalNumberOfMissingValues(), other.totalNumberOfMissingValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MissingSensorData").add("AffectedSensorCount", affectedSensorCount())
                .add("TotalNumberOfMissingValues", totalNumberOfMissingValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AffectedSensorCount":
            return Optional.ofNullable(clazz.cast(affectedSensorCount()));
        case "TotalNumberOfMissingValues":
            return Optional.ofNullable(clazz.cast(totalNumberOfMissingValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MissingSensorData, T> g) {
        return obj -> g.apply((MissingSensorData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MissingSensorData> {
        /**
         * <p>
         * Indicates the number of sensors that have atleast some data missing.
         * </p>
         * 
         * @param affectedSensorCount
         *        Indicates the number of sensors that have atleast some data missing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder affectedSensorCount(Integer affectedSensorCount);

        /**
         * <p>
         * Indicates the total number of missing values across all the sensors.
         * </p>
         * 
         * @param totalNumberOfMissingValues
         *        Indicates the total number of missing values across all the sensors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNumberOfMissingValues(Integer totalNumberOfMissingValues);
    }

    static final class BuilderImpl implements Builder {
        private Integer affectedSensorCount;

        private Integer totalNumberOfMissingValues;

        private BuilderImpl() {
        }

        private BuilderImpl(MissingSensorData model) {
            affectedSensorCount(model.affectedSensorCount);
            totalNumberOfMissingValues(model.totalNumberOfMissingValues);
        }

        public final Integer getAffectedSensorCount() {
            return affectedSensorCount;
        }

        public final void setAffectedSensorCount(Integer affectedSensorCount) {
            this.affectedSensorCount = affectedSensorCount;
        }

        @Override
        public final Builder affectedSensorCount(Integer affectedSensorCount) {
            this.affectedSensorCount = affectedSensorCount;
            return this;
        }

        public final Integer getTotalNumberOfMissingValues() {
            return totalNumberOfMissingValues;
        }

        public final void setTotalNumberOfMissingValues(Integer totalNumberOfMissingValues) {
            this.totalNumberOfMissingValues = totalNumberOfMissingValues;
        }

        @Override
        public final Builder totalNumberOfMissingValues(Integer totalNumberOfMissingValues) {
            this.totalNumberOfMissingValues = totalNumberOfMissingValues;
            return this;
        }

        @Override
        public MissingSensorData build() {
            return new MissingSensorData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
