/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon S3 location for the pointwise model diagnostics for an Amazon Lookout for Equipment model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelDiagnosticsS3OutputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelDiagnosticsS3OutputConfiguration.Builder, ModelDiagnosticsS3OutputConfiguration> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Bucket")
            .getter(getter(ModelDiagnosticsS3OutputConfiguration::bucket)).setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Prefix")
            .getter(getter(ModelDiagnosticsS3OutputConfiguration::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String bucket;

    private final String prefix;

    private ModelDiagnosticsS3OutputConfiguration(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.prefix = builder.prefix;
    }

    /**
     * <p>
     * The name of the Amazon S3 bucket where the pointwise model diagnostics are located. You must be the owner of the
     * Amazon S3 bucket.
     * </p>
     * 
     * @return The name of the Amazon S3 bucket where the pointwise model diagnostics are located. You must be the owner
     *         of the Amazon S3 bucket.
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The Amazon S3 prefix for the location of the pointwise model diagnostics. The prefix specifies the folder and
     * evaluation result file name. (<code>bucket</code>).
     * </p>
     * <p>
     * When you call <code>CreateModel</code> or <code>UpdateModel</code>, specify the path within the bucket that you
     * want Lookout for Equipment to save the model to. During training, Lookout for Equipment creates the model
     * evaluation model as a compressed JSON file with the name <code>model_diagnostics_results.json.gz</code>.
     * </p>
     * <p>
     * When you call <code>DescribeModel</code> or <code>DescribeModelVersion</code>, <code>prefix</code> contains the
     * file path and filename of the model evaluation file.
     * </p>
     * 
     * @return The Amazon S3 prefix for the location of the pointwise model diagnostics. The prefix specifies the folder
     *         and evaluation result file name. (<code>bucket</code>).</p>
     *         <p>
     *         When you call <code>CreateModel</code> or <code>UpdateModel</code>, specify the path within the bucket
     *         that you want Lookout for Equipment to save the model to. During training, Lookout for Equipment creates
     *         the model evaluation model as a compressed JSON file with the name
     *         <code>model_diagnostics_results.json.gz</code>.
     *         </p>
     *         <p>
     *         When you call <code>DescribeModel</code> or <code>DescribeModelVersion</code>, <code>prefix</code>
     *         contains the file path and filename of the model evaluation file.
     */
    public final String prefix() {
        return prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelDiagnosticsS3OutputConfiguration)) {
            return false;
        }
        ModelDiagnosticsS3OutputConfiguration other = (ModelDiagnosticsS3OutputConfiguration) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(prefix(), other.prefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelDiagnosticsS3OutputConfiguration").add("Bucket", bucket()).add("Prefix", prefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelDiagnosticsS3OutputConfiguration, T> g) {
        return obj -> g.apply((ModelDiagnosticsS3OutputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelDiagnosticsS3OutputConfiguration> {
        /**
         * <p>
         * The name of the Amazon S3 bucket where the pointwise model diagnostics are located. You must be the owner of
         * the Amazon S3 bucket.
         * </p>
         * 
         * @param bucket
         *        The name of the Amazon S3 bucket where the pointwise model diagnostics are located. You must be the
         *        owner of the Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The Amazon S3 prefix for the location of the pointwise model diagnostics. The prefix specifies the folder and
         * evaluation result file name. (<code>bucket</code>).
         * </p>
         * <p>
         * When you call <code>CreateModel</code> or <code>UpdateModel</code>, specify the path within the bucket that
         * you want Lookout for Equipment to save the model to. During training, Lookout for Equipment creates the model
         * evaluation model as a compressed JSON file with the name <code>model_diagnostics_results.json.gz</code>.
         * </p>
         * <p>
         * When you call <code>DescribeModel</code> or <code>DescribeModelVersion</code>, <code>prefix</code> contains
         * the file path and filename of the model evaluation file.
         * </p>
         * 
         * @param prefix
         *        The Amazon S3 prefix for the location of the pointwise model diagnostics. The prefix specifies the
         *        folder and evaluation result file name. (<code>bucket</code>).</p>
         *        <p>
         *        When you call <code>CreateModel</code> or <code>UpdateModel</code>, specify the path within the bucket
         *        that you want Lookout for Equipment to save the model to. During training, Lookout for Equipment
         *        creates the model evaluation model as a compressed JSON file with the name
         *        <code>model_diagnostics_results.json.gz</code>.
         *        </p>
         *        <p>
         *        When you call <code>DescribeModel</code> or <code>DescribeModelVersion</code>, <code>prefix</code>
         *        contains the file path and filename of the model evaluation file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelDiagnosticsS3OutputConfiguration model) {
            bucket(model.bucket);
            prefix(model.prefix);
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public ModelDiagnosticsS3OutputConfiguration build() {
            return new ModelDiagnosticsS3OutputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
