/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionSummariesCopier;
import software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionSummary;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInferenceExecutionsResponse
extends LookoutEquipmentResponse
implements ToCopyableBuilder<Builder, ListInferenceExecutionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInferenceExecutionsResponse.getter(ListInferenceExecutionsResponse::nextToken)).setter(ListInferenceExecutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<InferenceExecutionSummary>> INFERENCE_EXECUTION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InferenceExecutionSummaries").getter(ListInferenceExecutionsResponse.getter(ListInferenceExecutionsResponse::inferenceExecutionSummaries)).setter(ListInferenceExecutionsResponse.setter(Builder::inferenceExecutionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceExecutionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InferenceExecutionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, INFERENCE_EXECUTION_SUMMARIES_FIELD));
    private final String nextToken;
    private final List<InferenceExecutionSummary> inferenceExecutionSummaries;

    private ListInferenceExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.inferenceExecutionSummaries = builder.inferenceExecutionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasInferenceExecutionSummaries() {
        return this.inferenceExecutionSummaries != null && !(this.inferenceExecutionSummaries instanceof SdkAutoConstructList);
    }

    public final List<InferenceExecutionSummary> inferenceExecutionSummaries() {
        return this.inferenceExecutionSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInferenceExecutionSummaries() ? this.inferenceExecutionSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInferenceExecutionsResponse)) {
            return false;
        }
        ListInferenceExecutionsResponse other = (ListInferenceExecutionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasInferenceExecutionSummaries() == other.hasInferenceExecutionSummaries() && Objects.equals(this.inferenceExecutionSummaries(), other.inferenceExecutionSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListInferenceExecutionsResponse").add("NextToken", (Object)this.nextToken()).add("InferenceExecutionSummaries", this.hasInferenceExecutionSummaries() ? this.inferenceExecutionSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "InferenceExecutionSummaries": {
                return Optional.ofNullable(clazz.cast(this.inferenceExecutionSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInferenceExecutionsResponse, T> g) {
        return obj -> g.apply((ListInferenceExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<InferenceExecutionSummary> inferenceExecutionSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListInferenceExecutionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.inferenceExecutionSummaries(model.inferenceExecutionSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<InferenceExecutionSummary.Builder> getInferenceExecutionSummaries() {
            List<InferenceExecutionSummary.Builder> result = InferenceExecutionSummariesCopier.copyToBuilder(this.inferenceExecutionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInferenceExecutionSummaries(Collection<InferenceExecutionSummary.BuilderImpl> inferenceExecutionSummaries) {
            this.inferenceExecutionSummaries = InferenceExecutionSummariesCopier.copyFromBuilder(inferenceExecutionSummaries);
        }

        @Override
        public final Builder inferenceExecutionSummaries(Collection<InferenceExecutionSummary> inferenceExecutionSummaries) {
            this.inferenceExecutionSummaries = InferenceExecutionSummariesCopier.copy(inferenceExecutionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceExecutionSummaries(InferenceExecutionSummary ... inferenceExecutionSummaries) {
            this.inferenceExecutionSummaries(Arrays.asList(inferenceExecutionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceExecutionSummaries(Consumer<InferenceExecutionSummary.Builder> ... inferenceExecutionSummaries) {
            this.inferenceExecutionSummaries(Stream.of(inferenceExecutionSummaries).map(c -> (InferenceExecutionSummary)((InferenceExecutionSummary.Builder)InferenceExecutionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListInferenceExecutionsResponse build() {
            return new ListInferenceExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutEquipmentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInferenceExecutionsResponse> {
        public Builder nextToken(String var1);

        public Builder inferenceExecutionSummaries(Collection<InferenceExecutionSummary> var1);

        public Builder inferenceExecutionSummaries(InferenceExecutionSummary ... var1);

        public Builder inferenceExecutionSummaries(Consumer<InferenceExecutionSummary.Builder> ... var1);
    }
}

