/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.DataUploadFrequency;
import software.amazon.awssdk.services.lookoutequipment.model.InferenceInputConfiguration;
import software.amazon.awssdk.services.lookoutequipment.model.InferenceOutputConfiguration;
import software.amazon.awssdk.services.lookoutequipment.model.InferenceSchedulerStatus;
import software.amazon.awssdk.services.lookoutequipment.model.LatestInferenceResult;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInferenceSchedulerResponse
extends LookoutEquipmentResponse
implements ToCopyableBuilder<Builder, DescribeInferenceSchedulerResponse> {
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelArn").getter(DescribeInferenceSchedulerResponse.getter(DescribeInferenceSchedulerResponse::modelArn)).setter(DescribeInferenceSchedulerResponse.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()}).build();
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(DescribeInferenceSchedulerResponse.getter(DescribeInferenceSchedulerResponse::modelName)).setter(DescribeInferenceSchedulerResponse.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> INFERENCE_SCHEDULER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceSchedulerName").getter(DescribeInferenceSchedulerResponse.getter(DescribeInferenceSchedulerResponse::inferenceSchedulerName)).setter(DescribeInferenceSchedulerResponse.setter(Builder::inferenceSchedulerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerName").build()}).build();
    private static final SdkField<String> INFERENCE_SCHEDULER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceSchedulerArn").getter(DescribeInferenceSchedulerResponse.getter(DescribeInferenceSchedulerResponse::inferenceSchedulerArn)).setter(DescribeInferenceSchedulerResponse.setter(Builder::inferenceSchedulerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeInferenceSchedulerResponse.getter(DescribeInferenceSchedulerResponse::statusAsString)).setter(DescribeInferenceSchedulerResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Long> DATA_DELAY_OFFSET_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DataDelayOffsetInMinutes").getter(DescribeInferenceSchedulerResponse.getter(DescribeInferenceSchedulerResponse::dataDelayOffsetInMinutes)).setter(DescribeInferenceSchedulerResponse.setter(Builder::dataDelayOffsetInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataDelayOffsetInMinutes").build()}).build();
    private static final SdkField<String> DATA_UPLOAD_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataUploadFrequency").getter(DescribeInferenceSchedulerResponse.getter(DescribeInferenceSchedulerResponse::dataUploadFrequencyAsString)).setter(DescribeInferenceSchedulerResponse.setter(Builder::dataUploadFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataUploadFrequency").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(DescribeInferenceSchedulerResponse.getter(DescribeInferenceSchedulerResponse::createdAt)).setter(DescribeInferenceSchedulerResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(DescribeInferenceSchedulerResponse.getter(DescribeInferenceSchedulerResponse::updatedAt)).setter(DescribeInferenceSchedulerResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<InferenceInputConfiguration> DATA_INPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataInputConfiguration").getter(DescribeInferenceSchedulerResponse.getter(DescribeInferenceSchedulerResponse::dataInputConfiguration)).setter(DescribeInferenceSchedulerResponse.setter(Builder::dataInputConfiguration)).constructor(InferenceInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataInputConfiguration").build()}).build();
    private static final SdkField<InferenceOutputConfiguration> DATA_OUTPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataOutputConfiguration").getter(DescribeInferenceSchedulerResponse.getter(DescribeInferenceSchedulerResponse::dataOutputConfiguration)).setter(DescribeInferenceSchedulerResponse.setter(Builder::dataOutputConfiguration)).constructor(InferenceOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataOutputConfiguration").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeInferenceSchedulerResponse.getter(DescribeInferenceSchedulerResponse::roleArn)).setter(DescribeInferenceSchedulerResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> SERVER_SIDE_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerSideKmsKeyId").getter(DescribeInferenceSchedulerResponse.getter(DescribeInferenceSchedulerResponse::serverSideKmsKeyId)).setter(DescribeInferenceSchedulerResponse.setter(Builder::serverSideKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideKmsKeyId").build()}).build();
    private static final SdkField<String> LATEST_INFERENCE_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestInferenceResult").getter(DescribeInferenceSchedulerResponse.getter(DescribeInferenceSchedulerResponse::latestInferenceResultAsString)).setter(DescribeInferenceSchedulerResponse.setter(Builder::latestInferenceResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestInferenceResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ARN_FIELD, MODEL_NAME_FIELD, INFERENCE_SCHEDULER_NAME_FIELD, INFERENCE_SCHEDULER_ARN_FIELD, STATUS_FIELD, DATA_DELAY_OFFSET_IN_MINUTES_FIELD, DATA_UPLOAD_FREQUENCY_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, DATA_INPUT_CONFIGURATION_FIELD, DATA_OUTPUT_CONFIGURATION_FIELD, ROLE_ARN_FIELD, SERVER_SIDE_KMS_KEY_ID_FIELD, LATEST_INFERENCE_RESULT_FIELD));
    private final String modelArn;
    private final String modelName;
    private final String inferenceSchedulerName;
    private final String inferenceSchedulerArn;
    private final String status;
    private final Long dataDelayOffsetInMinutes;
    private final String dataUploadFrequency;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final InferenceInputConfiguration dataInputConfiguration;
    private final InferenceOutputConfiguration dataOutputConfiguration;
    private final String roleArn;
    private final String serverSideKmsKeyId;
    private final String latestInferenceResult;

    private DescribeInferenceSchedulerResponse(BuilderImpl builder) {
        super(builder);
        this.modelArn = builder.modelArn;
        this.modelName = builder.modelName;
        this.inferenceSchedulerName = builder.inferenceSchedulerName;
        this.inferenceSchedulerArn = builder.inferenceSchedulerArn;
        this.status = builder.status;
        this.dataDelayOffsetInMinutes = builder.dataDelayOffsetInMinutes;
        this.dataUploadFrequency = builder.dataUploadFrequency;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.dataInputConfiguration = builder.dataInputConfiguration;
        this.dataOutputConfiguration = builder.dataOutputConfiguration;
        this.roleArn = builder.roleArn;
        this.serverSideKmsKeyId = builder.serverSideKmsKeyId;
        this.latestInferenceResult = builder.latestInferenceResult;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String inferenceSchedulerName() {
        return this.inferenceSchedulerName;
    }

    public final String inferenceSchedulerArn() {
        return this.inferenceSchedulerArn;
    }

    public final InferenceSchedulerStatus status() {
        return InferenceSchedulerStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Long dataDelayOffsetInMinutes() {
        return this.dataDelayOffsetInMinutes;
    }

    public final DataUploadFrequency dataUploadFrequency() {
        return DataUploadFrequency.fromValue(this.dataUploadFrequency);
    }

    public final String dataUploadFrequencyAsString() {
        return this.dataUploadFrequency;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final InferenceInputConfiguration dataInputConfiguration() {
        return this.dataInputConfiguration;
    }

    public final InferenceOutputConfiguration dataOutputConfiguration() {
        return this.dataOutputConfiguration;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String serverSideKmsKeyId() {
        return this.serverSideKmsKeyId;
    }

    public final LatestInferenceResult latestInferenceResult() {
        return LatestInferenceResult.fromValue(this.latestInferenceResult);
    }

    public final String latestInferenceResultAsString() {
        return this.latestInferenceResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSchedulerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSchedulerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataDelayOffsetInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataUploadFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataOutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestInferenceResultAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInferenceSchedulerResponse)) {
            return false;
        }
        DescribeInferenceSchedulerResponse other = (DescribeInferenceSchedulerResponse)((Object)obj);
        return Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.inferenceSchedulerName(), other.inferenceSchedulerName()) && Objects.equals(this.inferenceSchedulerArn(), other.inferenceSchedulerArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.dataDelayOffsetInMinutes(), other.dataDelayOffsetInMinutes()) && Objects.equals(this.dataUploadFrequencyAsString(), other.dataUploadFrequencyAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.dataInputConfiguration(), other.dataInputConfiguration()) && Objects.equals(this.dataOutputConfiguration(), other.dataOutputConfiguration()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.serverSideKmsKeyId(), other.serverSideKmsKeyId()) && Objects.equals(this.latestInferenceResultAsString(), other.latestInferenceResultAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInferenceSchedulerResponse").add("ModelArn", (Object)this.modelArn()).add("ModelName", (Object)this.modelName()).add("InferenceSchedulerName", (Object)this.inferenceSchedulerName()).add("InferenceSchedulerArn", (Object)this.inferenceSchedulerArn()).add("Status", (Object)this.statusAsString()).add("DataDelayOffsetInMinutes", (Object)this.dataDelayOffsetInMinutes()).add("DataUploadFrequency", (Object)this.dataUploadFrequencyAsString()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("DataInputConfiguration", (Object)this.dataInputConfiguration()).add("DataOutputConfiguration", (Object)this.dataOutputConfiguration()).add("RoleArn", (Object)this.roleArn()).add("ServerSideKmsKeyId", (Object)this.serverSideKmsKeyId()).add("LatestInferenceResult", (Object)this.latestInferenceResultAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "InferenceSchedulerName": {
                return Optional.ofNullable(clazz.cast(this.inferenceSchedulerName()));
            }
            case "InferenceSchedulerArn": {
                return Optional.ofNullable(clazz.cast(this.inferenceSchedulerArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "DataDelayOffsetInMinutes": {
                return Optional.ofNullable(clazz.cast(this.dataDelayOffsetInMinutes()));
            }
            case "DataUploadFrequency": {
                return Optional.ofNullable(clazz.cast(this.dataUploadFrequencyAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "DataInputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataInputConfiguration()));
            }
            case "DataOutputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataOutputConfiguration()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "ServerSideKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.serverSideKmsKeyId()));
            }
            case "LatestInferenceResult": {
                return Optional.ofNullable(clazz.cast(this.latestInferenceResultAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInferenceSchedulerResponse, T> g) {
        return obj -> g.apply((DescribeInferenceSchedulerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentResponse.BuilderImpl
    implements Builder {
        private String modelArn;
        private String modelName;
        private String inferenceSchedulerName;
        private String inferenceSchedulerArn;
        private String status;
        private Long dataDelayOffsetInMinutes;
        private String dataUploadFrequency;
        private Instant createdAt;
        private Instant updatedAt;
        private InferenceInputConfiguration dataInputConfiguration;
        private InferenceOutputConfiguration dataOutputConfiguration;
        private String roleArn;
        private String serverSideKmsKeyId;
        private String latestInferenceResult;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInferenceSchedulerResponse model) {
            super(model);
            this.modelArn(model.modelArn);
            this.modelName(model.modelName);
            this.inferenceSchedulerName(model.inferenceSchedulerName);
            this.inferenceSchedulerArn(model.inferenceSchedulerArn);
            this.status(model.status);
            this.dataDelayOffsetInMinutes(model.dataDelayOffsetInMinutes);
            this.dataUploadFrequency(model.dataUploadFrequency);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.dataInputConfiguration(model.dataInputConfiguration);
            this.dataOutputConfiguration(model.dataOutputConfiguration);
            this.roleArn(model.roleArn);
            this.serverSideKmsKeyId(model.serverSideKmsKeyId);
            this.latestInferenceResult(model.latestInferenceResult);
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getInferenceSchedulerName() {
            return this.inferenceSchedulerName;
        }

        public final void setInferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
        }

        @Override
        public final Builder inferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
            return this;
        }

        public final String getInferenceSchedulerArn() {
            return this.inferenceSchedulerArn;
        }

        public final void setInferenceSchedulerArn(String inferenceSchedulerArn) {
            this.inferenceSchedulerArn = inferenceSchedulerArn;
        }

        @Override
        public final Builder inferenceSchedulerArn(String inferenceSchedulerArn) {
            this.inferenceSchedulerArn = inferenceSchedulerArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InferenceSchedulerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Long getDataDelayOffsetInMinutes() {
            return this.dataDelayOffsetInMinutes;
        }

        public final void setDataDelayOffsetInMinutes(Long dataDelayOffsetInMinutes) {
            this.dataDelayOffsetInMinutes = dataDelayOffsetInMinutes;
        }

        @Override
        public final Builder dataDelayOffsetInMinutes(Long dataDelayOffsetInMinutes) {
            this.dataDelayOffsetInMinutes = dataDelayOffsetInMinutes;
            return this;
        }

        public final String getDataUploadFrequency() {
            return this.dataUploadFrequency;
        }

        public final void setDataUploadFrequency(String dataUploadFrequency) {
            this.dataUploadFrequency = dataUploadFrequency;
        }

        @Override
        public final Builder dataUploadFrequency(String dataUploadFrequency) {
            this.dataUploadFrequency = dataUploadFrequency;
            return this;
        }

        @Override
        public final Builder dataUploadFrequency(DataUploadFrequency dataUploadFrequency) {
            this.dataUploadFrequency(dataUploadFrequency == null ? null : dataUploadFrequency.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final InferenceInputConfiguration.Builder getDataInputConfiguration() {
            return this.dataInputConfiguration != null ? this.dataInputConfiguration.toBuilder() : null;
        }

        public final void setDataInputConfiguration(InferenceInputConfiguration.BuilderImpl dataInputConfiguration) {
            this.dataInputConfiguration = dataInputConfiguration != null ? dataInputConfiguration.build() : null;
        }

        @Override
        public final Builder dataInputConfiguration(InferenceInputConfiguration dataInputConfiguration) {
            this.dataInputConfiguration = dataInputConfiguration;
            return this;
        }

        public final InferenceOutputConfiguration.Builder getDataOutputConfiguration() {
            return this.dataOutputConfiguration != null ? this.dataOutputConfiguration.toBuilder() : null;
        }

        public final void setDataOutputConfiguration(InferenceOutputConfiguration.BuilderImpl dataOutputConfiguration) {
            this.dataOutputConfiguration = dataOutputConfiguration != null ? dataOutputConfiguration.build() : null;
        }

        @Override
        public final Builder dataOutputConfiguration(InferenceOutputConfiguration dataOutputConfiguration) {
            this.dataOutputConfiguration = dataOutputConfiguration;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getServerSideKmsKeyId() {
            return this.serverSideKmsKeyId;
        }

        public final void setServerSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
        }

        @Override
        public final Builder serverSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
            return this;
        }

        public final String getLatestInferenceResult() {
            return this.latestInferenceResult;
        }

        public final void setLatestInferenceResult(String latestInferenceResult) {
            this.latestInferenceResult = latestInferenceResult;
        }

        @Override
        public final Builder latestInferenceResult(String latestInferenceResult) {
            this.latestInferenceResult = latestInferenceResult;
            return this;
        }

        @Override
        public final Builder latestInferenceResult(LatestInferenceResult latestInferenceResult) {
            this.latestInferenceResult(latestInferenceResult == null ? null : latestInferenceResult.toString());
            return this;
        }

        @Override
        public DescribeInferenceSchedulerResponse build() {
            return new DescribeInferenceSchedulerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutEquipmentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInferenceSchedulerResponse> {
        public Builder modelArn(String var1);

        public Builder modelName(String var1);

        public Builder inferenceSchedulerName(String var1);

        public Builder inferenceSchedulerArn(String var1);

        public Builder status(String var1);

        public Builder status(InferenceSchedulerStatus var1);

        public Builder dataDelayOffsetInMinutes(Long var1);

        public Builder dataUploadFrequency(String var1);

        public Builder dataUploadFrequency(DataUploadFrequency var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder dataInputConfiguration(InferenceInputConfiguration var1);

        default public Builder dataInputConfiguration(Consumer<InferenceInputConfiguration.Builder> dataInputConfiguration) {
            return this.dataInputConfiguration((InferenceInputConfiguration)((InferenceInputConfiguration.Builder)InferenceInputConfiguration.builder().applyMutation(dataInputConfiguration)).build());
        }

        public Builder dataOutputConfiguration(InferenceOutputConfiguration var1);

        default public Builder dataOutputConfiguration(Consumer<InferenceOutputConfiguration.Builder> dataOutputConfiguration) {
            return this.dataOutputConfiguration((InferenceOutputConfiguration)((InferenceOutputConfiguration.Builder)InferenceOutputConfiguration.builder().applyMutation(dataOutputConfiguration)).build());
        }

        public Builder roleArn(String var1);

        public Builder serverSideKmsKeyId(String var1);

        public Builder latestInferenceResult(String var1);

        public Builder latestInferenceResult(LatestInferenceResult var1);
    }
}

