/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies configuration information for the output results from for the inference, including KMS key ID and output S3
 * location.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceOutputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceOutputConfiguration.Builder, InferenceOutputConfiguration> {
    private static final SdkField<InferenceS3OutputConfiguration> S3_OUTPUT_CONFIGURATION_FIELD = SdkField
            .<InferenceS3OutputConfiguration> builder(MarshallingType.SDK_POJO).memberName("S3OutputConfiguration")
            .getter(getter(InferenceOutputConfiguration::s3OutputConfiguration)).setter(setter(Builder::s3OutputConfiguration))
            .constructor(InferenceS3OutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputConfiguration").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(InferenceOutputConfiguration::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OUTPUT_CONFIGURATION_FIELD,
            KMS_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final InferenceS3OutputConfiguration s3OutputConfiguration;

    private final String kmsKeyId;

    private InferenceOutputConfiguration(BuilderImpl builder) {
        this.s3OutputConfiguration = builder.s3OutputConfiguration;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * Specifies configuration information for the output results from for the inference, output S3 location.
     * </p>
     * 
     * @return Specifies configuration information for the output results from for the inference, output S3 location.
     */
    public final InferenceS3OutputConfiguration s3OutputConfiguration() {
        return s3OutputConfiguration;
    }

    /**
     * <p>
     * The ID number for the KMS key key used to encrypt the inference output.
     * </p>
     * 
     * @return The ID number for the KMS key key used to encrypt the inference output.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3OutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceOutputConfiguration)) {
            return false;
        }
        InferenceOutputConfiguration other = (InferenceOutputConfiguration) obj;
        return Objects.equals(s3OutputConfiguration(), other.s3OutputConfiguration())
                && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceOutputConfiguration").add("S3OutputConfiguration", s3OutputConfiguration())
                .add("KmsKeyId", kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3OutputConfiguration":
            return Optional.ofNullable(clazz.cast(s3OutputConfiguration()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferenceOutputConfiguration, T> g) {
        return obj -> g.apply((InferenceOutputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceOutputConfiguration> {
        /**
         * <p>
         * Specifies configuration information for the output results from for the inference, output S3 location.
         * </p>
         * 
         * @param s3OutputConfiguration
         *        Specifies configuration information for the output results from for the inference, output S3 location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OutputConfiguration(InferenceS3OutputConfiguration s3OutputConfiguration);

        /**
         * <p>
         * Specifies configuration information for the output results from for the inference, output S3 location.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceS3OutputConfiguration.Builder}
         * avoiding the need to create one manually via {@link InferenceS3OutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceS3OutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #s3OutputConfiguration(InferenceS3OutputConfiguration)}.
         * 
         * @param s3OutputConfiguration
         *        a consumer that will call methods on {@link InferenceS3OutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3OutputConfiguration(InferenceS3OutputConfiguration)
         */
        default Builder s3OutputConfiguration(Consumer<InferenceS3OutputConfiguration.Builder> s3OutputConfiguration) {
            return s3OutputConfiguration(InferenceS3OutputConfiguration.builder().applyMutation(s3OutputConfiguration).build());
        }

        /**
         * <p>
         * The ID number for the KMS key key used to encrypt the inference output.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID number for the KMS key key used to encrypt the inference output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private InferenceS3OutputConfiguration s3OutputConfiguration;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceOutputConfiguration model) {
            s3OutputConfiguration(model.s3OutputConfiguration);
            kmsKeyId(model.kmsKeyId);
        }

        public final InferenceS3OutputConfiguration.Builder getS3OutputConfiguration() {
            return s3OutputConfiguration != null ? s3OutputConfiguration.toBuilder() : null;
        }

        public final void setS3OutputConfiguration(InferenceS3OutputConfiguration.BuilderImpl s3OutputConfiguration) {
            this.s3OutputConfiguration = s3OutputConfiguration != null ? s3OutputConfiguration.build() : null;
        }

        @Override
        public final Builder s3OutputConfiguration(InferenceS3OutputConfiguration s3OutputConfiguration) {
            this.s3OutputConfiguration = s3OutputConfiguration;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public InferenceOutputConfiguration build() {
            return new InferenceOutputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
