/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Entity that comprises aggregated information on sensors having insufficient data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InsufficientSensorData implements SdkPojo, Serializable,
        ToCopyableBuilder<InsufficientSensorData.Builder, InsufficientSensorData> {
    private static final SdkField<MissingCompleteSensorData> MISSING_COMPLETE_SENSOR_DATA_FIELD = SdkField
            .<MissingCompleteSensorData> builder(MarshallingType.SDK_POJO).memberName("MissingCompleteSensorData")
            .getter(getter(InsufficientSensorData::missingCompleteSensorData)).setter(setter(Builder::missingCompleteSensorData))
            .constructor(MissingCompleteSensorData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingCompleteSensorData").build())
            .build();

    private static final SdkField<SensorsWithShortDateRange> SENSORS_WITH_SHORT_DATE_RANGE_FIELD = SdkField
            .<SensorsWithShortDateRange> builder(MarshallingType.SDK_POJO).memberName("SensorsWithShortDateRange")
            .getter(getter(InsufficientSensorData::sensorsWithShortDateRange)).setter(setter(Builder::sensorsWithShortDateRange))
            .constructor(SensorsWithShortDateRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SensorsWithShortDateRange").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MISSING_COMPLETE_SENSOR_DATA_FIELD, SENSORS_WITH_SHORT_DATE_RANGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final MissingCompleteSensorData missingCompleteSensorData;

    private final SensorsWithShortDateRange sensorsWithShortDateRange;

    private InsufficientSensorData(BuilderImpl builder) {
        this.missingCompleteSensorData = builder.missingCompleteSensorData;
        this.sensorsWithShortDateRange = builder.sensorsWithShortDateRange;
    }

    /**
     * <p>
     * Parameter that describes the total number of sensors that have data completely missing for it.
     * </p>
     * 
     * @return Parameter that describes the total number of sensors that have data completely missing for it.
     */
    public final MissingCompleteSensorData missingCompleteSensorData() {
        return missingCompleteSensorData;
    }

    /**
     * <p>
     * Parameter that describes the total number of sensors that have a short date range of less than 14 days of data
     * overall.
     * </p>
     * 
     * @return Parameter that describes the total number of sensors that have a short date range of less than 14 days of
     *         data overall.
     */
    public final SensorsWithShortDateRange sensorsWithShortDateRange() {
        return sensorsWithShortDateRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(missingCompleteSensorData());
        hashCode = 31 * hashCode + Objects.hashCode(sensorsWithShortDateRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsufficientSensorData)) {
            return false;
        }
        InsufficientSensorData other = (InsufficientSensorData) obj;
        return Objects.equals(missingCompleteSensorData(), other.missingCompleteSensorData())
                && Objects.equals(sensorsWithShortDateRange(), other.sensorsWithShortDateRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InsufficientSensorData").add("MissingCompleteSensorData", missingCompleteSensorData())
                .add("SensorsWithShortDateRange", sensorsWithShortDateRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MissingCompleteSensorData":
            return Optional.ofNullable(clazz.cast(missingCompleteSensorData()));
        case "SensorsWithShortDateRange":
            return Optional.ofNullable(clazz.cast(sensorsWithShortDateRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InsufficientSensorData, T> g) {
        return obj -> g.apply((InsufficientSensorData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InsufficientSensorData> {
        /**
         * <p>
         * Parameter that describes the total number of sensors that have data completely missing for it.
         * </p>
         * 
         * @param missingCompleteSensorData
         *        Parameter that describes the total number of sensors that have data completely missing for it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingCompleteSensorData(MissingCompleteSensorData missingCompleteSensorData);

        /**
         * <p>
         * Parameter that describes the total number of sensors that have data completely missing for it.
         * </p>
         * This is a convenience method that creates an instance of the {@link MissingCompleteSensorData.Builder}
         * avoiding the need to create one manually via {@link MissingCompleteSensorData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MissingCompleteSensorData.Builder#build()} is called immediately
         * and its result is passed to {@link #missingCompleteSensorData(MissingCompleteSensorData)}.
         * 
         * @param missingCompleteSensorData
         *        a consumer that will call methods on {@link MissingCompleteSensorData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #missingCompleteSensorData(MissingCompleteSensorData)
         */
        default Builder missingCompleteSensorData(Consumer<MissingCompleteSensorData.Builder> missingCompleteSensorData) {
            return missingCompleteSensorData(MissingCompleteSensorData.builder().applyMutation(missingCompleteSensorData).build());
        }

        /**
         * <p>
         * Parameter that describes the total number of sensors that have a short date range of less than 14 days of
         * data overall.
         * </p>
         * 
         * @param sensorsWithShortDateRange
         *        Parameter that describes the total number of sensors that have a short date range of less than 14 days
         *        of data overall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensorsWithShortDateRange(SensorsWithShortDateRange sensorsWithShortDateRange);

        /**
         * <p>
         * Parameter that describes the total number of sensors that have a short date range of less than 14 days of
         * data overall.
         * </p>
         * This is a convenience method that creates an instance of the {@link SensorsWithShortDateRange.Builder}
         * avoiding the need to create one manually via {@link SensorsWithShortDateRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SensorsWithShortDateRange.Builder#build()} is called immediately
         * and its result is passed to {@link #sensorsWithShortDateRange(SensorsWithShortDateRange)}.
         * 
         * @param sensorsWithShortDateRange
         *        a consumer that will call methods on {@link SensorsWithShortDateRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sensorsWithShortDateRange(SensorsWithShortDateRange)
         */
        default Builder sensorsWithShortDateRange(Consumer<SensorsWithShortDateRange.Builder> sensorsWithShortDateRange) {
            return sensorsWithShortDateRange(SensorsWithShortDateRange.builder().applyMutation(sensorsWithShortDateRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MissingCompleteSensorData missingCompleteSensorData;

        private SensorsWithShortDateRange sensorsWithShortDateRange;

        private BuilderImpl() {
        }

        private BuilderImpl(InsufficientSensorData model) {
            missingCompleteSensorData(model.missingCompleteSensorData);
            sensorsWithShortDateRange(model.sensorsWithShortDateRange);
        }

        public final MissingCompleteSensorData.Builder getMissingCompleteSensorData() {
            return missingCompleteSensorData != null ? missingCompleteSensorData.toBuilder() : null;
        }

        public final void setMissingCompleteSensorData(MissingCompleteSensorData.BuilderImpl missingCompleteSensorData) {
            this.missingCompleteSensorData = missingCompleteSensorData != null ? missingCompleteSensorData.build() : null;
        }

        @Override
        public final Builder missingCompleteSensorData(MissingCompleteSensorData missingCompleteSensorData) {
            this.missingCompleteSensorData = missingCompleteSensorData;
            return this;
        }

        public final SensorsWithShortDateRange.Builder getSensorsWithShortDateRange() {
            return sensorsWithShortDateRange != null ? sensorsWithShortDateRange.toBuilder() : null;
        }

        public final void setSensorsWithShortDateRange(SensorsWithShortDateRange.BuilderImpl sensorsWithShortDateRange) {
            this.sensorsWithShortDateRange = sensorsWithShortDateRange != null ? sensorsWithShortDateRange.build() : null;
        }

        @Override
        public final Builder sensorsWithShortDateRange(SensorsWithShortDateRange sensorsWithShortDateRange) {
            this.sensorsWithShortDateRange = sensorsWithShortDateRange;
            return this;
        }

        @Override
        public InsufficientSensorData build() {
            return new InsufficientSensorData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
