/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of ingestion statistics like whether data exists, number of missing values, number of invalid values and so
 * on related to the particular sensor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SensorStatisticsSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SensorStatisticsSummary.Builder, SensorStatisticsSummary> {
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComponentName").getter(getter(SensorStatisticsSummary::componentName))
            .setter(setter(Builder::componentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentName").build()).build();

    private static final SdkField<String> SENSOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SensorName").getter(getter(SensorStatisticsSummary::sensorName)).setter(setter(Builder::sensorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SensorName").build()).build();

    private static final SdkField<Boolean> DATA_EXISTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DataExists").getter(getter(SensorStatisticsSummary::dataExists)).setter(setter(Builder::dataExists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataExists").build()).build();

    private static final SdkField<CountPercent> MISSING_VALUES_FIELD = SdkField.<CountPercent> builder(MarshallingType.SDK_POJO)
            .memberName("MissingValues").getter(getter(SensorStatisticsSummary::missingValues))
            .setter(setter(Builder::missingValues)).constructor(CountPercent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingValues").build()).build();

    private static final SdkField<CountPercent> INVALID_VALUES_FIELD = SdkField.<CountPercent> builder(MarshallingType.SDK_POJO)
            .memberName("InvalidValues").getter(getter(SensorStatisticsSummary::invalidValues))
            .setter(setter(Builder::invalidValues)).constructor(CountPercent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidValues").build()).build();

    private static final SdkField<CountPercent> INVALID_DATE_ENTRIES_FIELD = SdkField
            .<CountPercent> builder(MarshallingType.SDK_POJO).memberName("InvalidDateEntries")
            .getter(getter(SensorStatisticsSummary::invalidDateEntries)).setter(setter(Builder::invalidDateEntries))
            .constructor(CountPercent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidDateEntries").build())
            .build();

    private static final SdkField<CountPercent> DUPLICATE_TIMESTAMPS_FIELD = SdkField
            .<CountPercent> builder(MarshallingType.SDK_POJO).memberName("DuplicateTimestamps")
            .getter(getter(SensorStatisticsSummary::duplicateTimestamps)).setter(setter(Builder::duplicateTimestamps))
            .constructor(CountPercent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DuplicateTimestamps").build())
            .build();

    private static final SdkField<CategoricalValues> CATEGORICAL_VALUES_FIELD = SdkField
            .<CategoricalValues> builder(MarshallingType.SDK_POJO).memberName("CategoricalValues")
            .getter(getter(SensorStatisticsSummary::categoricalValues)).setter(setter(Builder::categoricalValues))
            .constructor(CategoricalValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoricalValues").build()).build();

    private static final SdkField<MultipleOperatingModes> MULTIPLE_OPERATING_MODES_FIELD = SdkField
            .<MultipleOperatingModes> builder(MarshallingType.SDK_POJO).memberName("MultipleOperatingModes")
            .getter(getter(SensorStatisticsSummary::multipleOperatingModes)).setter(setter(Builder::multipleOperatingModes))
            .constructor(MultipleOperatingModes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultipleOperatingModes").build())
            .build();

    private static final SdkField<LargeTimestampGaps> LARGE_TIMESTAMP_GAPS_FIELD = SdkField
            .<LargeTimestampGaps> builder(MarshallingType.SDK_POJO).memberName("LargeTimestampGaps")
            .getter(getter(SensorStatisticsSummary::largeTimestampGaps)).setter(setter(Builder::largeTimestampGaps))
            .constructor(LargeTimestampGaps::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LargeTimestampGaps").build())
            .build();

    private static final SdkField<MonotonicValues> MONOTONIC_VALUES_FIELD = SdkField
            .<MonotonicValues> builder(MarshallingType.SDK_POJO).memberName("MonotonicValues")
            .getter(getter(SensorStatisticsSummary::monotonicValues)).setter(setter(Builder::monotonicValues))
            .constructor(MonotonicValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonotonicValues").build()).build();

    private static final SdkField<Instant> DATA_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DataStartTime").getter(getter(SensorStatisticsSummary::dataStartTime))
            .setter(setter(Builder::dataStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStartTime").build()).build();

    private static final SdkField<Instant> DATA_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DataEndTime").getter(getter(SensorStatisticsSummary::dataEndTime)).setter(setter(Builder::dataEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataEndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_NAME_FIELD,
            SENSOR_NAME_FIELD, DATA_EXISTS_FIELD, MISSING_VALUES_FIELD, INVALID_VALUES_FIELD, INVALID_DATE_ENTRIES_FIELD,
            DUPLICATE_TIMESTAMPS_FIELD, CATEGORICAL_VALUES_FIELD, MULTIPLE_OPERATING_MODES_FIELD, LARGE_TIMESTAMP_GAPS_FIELD,
            MONOTONIC_VALUES_FIELD, DATA_START_TIME_FIELD, DATA_END_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String componentName;

    private final String sensorName;

    private final Boolean dataExists;

    private final CountPercent missingValues;

    private final CountPercent invalidValues;

    private final CountPercent invalidDateEntries;

    private final CountPercent duplicateTimestamps;

    private final CategoricalValues categoricalValues;

    private final MultipleOperatingModes multipleOperatingModes;

    private final LargeTimestampGaps largeTimestampGaps;

    private final MonotonicValues monotonicValues;

    private final Instant dataStartTime;

    private final Instant dataEndTime;

    private SensorStatisticsSummary(BuilderImpl builder) {
        this.componentName = builder.componentName;
        this.sensorName = builder.sensorName;
        this.dataExists = builder.dataExists;
        this.missingValues = builder.missingValues;
        this.invalidValues = builder.invalidValues;
        this.invalidDateEntries = builder.invalidDateEntries;
        this.duplicateTimestamps = builder.duplicateTimestamps;
        this.categoricalValues = builder.categoricalValues;
        this.multipleOperatingModes = builder.multipleOperatingModes;
        this.largeTimestampGaps = builder.largeTimestampGaps;
        this.monotonicValues = builder.monotonicValues;
        this.dataStartTime = builder.dataStartTime;
        this.dataEndTime = builder.dataEndTime;
    }

    /**
     * <p>
     * Name of the component to which the particular sensor belongs for which the statistics belong to.
     * </p>
     * 
     * @return Name of the component to which the particular sensor belongs for which the statistics belong to.
     */
    public final String componentName() {
        return componentName;
    }

    /**
     * <p>
     * Name of the sensor that the statistics belong to.
     * </p>
     * 
     * @return Name of the sensor that the statistics belong to.
     */
    public final String sensorName() {
        return sensorName;
    }

    /**
     * <p>
     * Parameter that indicates whether data exists for the sensor that the statistics belong to.
     * </p>
     * 
     * @return Parameter that indicates whether data exists for the sensor that the statistics belong to.
     */
    public final Boolean dataExists() {
        return dataExists;
    }

    /**
     * <p>
     * Parameter that describes the total number of, and percentage of, values that are missing for the sensor that the
     * statistics belong to.
     * </p>
     * 
     * @return Parameter that describes the total number of, and percentage of, values that are missing for the sensor
     *         that the statistics belong to.
     */
    public final CountPercent missingValues() {
        return missingValues;
    }

    /**
     * <p>
     * Parameter that describes the total number of, and percentage of, values that are invalid for the sensor that the
     * statistics belong to.
     * </p>
     * 
     * @return Parameter that describes the total number of, and percentage of, values that are invalid for the sensor
     *         that the statistics belong to.
     */
    public final CountPercent invalidValues() {
        return invalidValues;
    }

    /**
     * <p>
     * Parameter that describes the total number of invalid date entries associated with the sensor that the statistics
     * belong to.
     * </p>
     * 
     * @return Parameter that describes the total number of invalid date entries associated with the sensor that the
     *         statistics belong to.
     */
    public final CountPercent invalidDateEntries() {
        return invalidDateEntries;
    }

    /**
     * <p>
     * Parameter that describes the total number of duplicate timestamp records associated with the sensor that the
     * statistics belong to.
     * </p>
     * 
     * @return Parameter that describes the total number of duplicate timestamp records associated with the sensor that
     *         the statistics belong to.
     */
    public final CountPercent duplicateTimestamps() {
        return duplicateTimestamps;
    }

    /**
     * <p>
     * Parameter that describes potential risk about whether data associated with the sensor is categorical.
     * </p>
     * 
     * @return Parameter that describes potential risk about whether data associated with the sensor is categorical.
     */
    public final CategoricalValues categoricalValues() {
        return categoricalValues;
    }

    /**
     * <p>
     * Parameter that describes potential risk about whether data associated with the sensor has more than one operating
     * mode.
     * </p>
     * 
     * @return Parameter that describes potential risk about whether data associated with the sensor has more than one
     *         operating mode.
     */
    public final MultipleOperatingModes multipleOperatingModes() {
        return multipleOperatingModes;
    }

    /**
     * <p>
     * Parameter that describes potential risk about whether data associated with the sensor contains one or more large
     * gaps between consecutive timestamps.
     * </p>
     * 
     * @return Parameter that describes potential risk about whether data associated with the sensor contains one or
     *         more large gaps between consecutive timestamps.
     */
    public final LargeTimestampGaps largeTimestampGaps() {
        return largeTimestampGaps;
    }

    /**
     * <p>
     * Parameter that describes potential risk about whether data associated with the sensor is mostly monotonic.
     * </p>
     * 
     * @return Parameter that describes potential risk about whether data associated with the sensor is mostly
     *         monotonic.
     */
    public final MonotonicValues monotonicValues() {
        return monotonicValues;
    }

    /**
     * <p>
     * Indicates the time reference to indicate the beginning of valid data associated with the sensor that the
     * statistics belong to.
     * </p>
     * 
     * @return Indicates the time reference to indicate the beginning of valid data associated with the sensor that the
     *         statistics belong to.
     */
    public final Instant dataStartTime() {
        return dataStartTime;
    }

    /**
     * <p>
     * Indicates the time reference to indicate the end of valid data associated with the sensor that the statistics
     * belong to.
     * </p>
     * 
     * @return Indicates the time reference to indicate the end of valid data associated with the sensor that the
     *         statistics belong to.
     */
    public final Instant dataEndTime() {
        return dataEndTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentName());
        hashCode = 31 * hashCode + Objects.hashCode(sensorName());
        hashCode = 31 * hashCode + Objects.hashCode(dataExists());
        hashCode = 31 * hashCode + Objects.hashCode(missingValues());
        hashCode = 31 * hashCode + Objects.hashCode(invalidValues());
        hashCode = 31 * hashCode + Objects.hashCode(invalidDateEntries());
        hashCode = 31 * hashCode + Objects.hashCode(duplicateTimestamps());
        hashCode = 31 * hashCode + Objects.hashCode(categoricalValues());
        hashCode = 31 * hashCode + Objects.hashCode(multipleOperatingModes());
        hashCode = 31 * hashCode + Objects.hashCode(largeTimestampGaps());
        hashCode = 31 * hashCode + Objects.hashCode(monotonicValues());
        hashCode = 31 * hashCode + Objects.hashCode(dataStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(dataEndTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SensorStatisticsSummary)) {
            return false;
        }
        SensorStatisticsSummary other = (SensorStatisticsSummary) obj;
        return Objects.equals(componentName(), other.componentName()) && Objects.equals(sensorName(), other.sensorName())
                && Objects.equals(dataExists(), other.dataExists()) && Objects.equals(missingValues(), other.missingValues())
                && Objects.equals(invalidValues(), other.invalidValues())
                && Objects.equals(invalidDateEntries(), other.invalidDateEntries())
                && Objects.equals(duplicateTimestamps(), other.duplicateTimestamps())
                && Objects.equals(categoricalValues(), other.categoricalValues())
                && Objects.equals(multipleOperatingModes(), other.multipleOperatingModes())
                && Objects.equals(largeTimestampGaps(), other.largeTimestampGaps())
                && Objects.equals(monotonicValues(), other.monotonicValues())
                && Objects.equals(dataStartTime(), other.dataStartTime()) && Objects.equals(dataEndTime(), other.dataEndTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SensorStatisticsSummary").add("ComponentName", componentName()).add("SensorName", sensorName())
                .add("DataExists", dataExists()).add("MissingValues", missingValues()).add("InvalidValues", invalidValues())
                .add("InvalidDateEntries", invalidDateEntries()).add("DuplicateTimestamps", duplicateTimestamps())
                .add("CategoricalValues", categoricalValues()).add("MultipleOperatingModes", multipleOperatingModes())
                .add("LargeTimestampGaps", largeTimestampGaps()).add("MonotonicValues", monotonicValues())
                .add("DataStartTime", dataStartTime()).add("DataEndTime", dataEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComponentName":
            return Optional.ofNullable(clazz.cast(componentName()));
        case "SensorName":
            return Optional.ofNullable(clazz.cast(sensorName()));
        case "DataExists":
            return Optional.ofNullable(clazz.cast(dataExists()));
        case "MissingValues":
            return Optional.ofNullable(clazz.cast(missingValues()));
        case "InvalidValues":
            return Optional.ofNullable(clazz.cast(invalidValues()));
        case "InvalidDateEntries":
            return Optional.ofNullable(clazz.cast(invalidDateEntries()));
        case "DuplicateTimestamps":
            return Optional.ofNullable(clazz.cast(duplicateTimestamps()));
        case "CategoricalValues":
            return Optional.ofNullable(clazz.cast(categoricalValues()));
        case "MultipleOperatingModes":
            return Optional.ofNullable(clazz.cast(multipleOperatingModes()));
        case "LargeTimestampGaps":
            return Optional.ofNullable(clazz.cast(largeTimestampGaps()));
        case "MonotonicValues":
            return Optional.ofNullable(clazz.cast(monotonicValues()));
        case "DataStartTime":
            return Optional.ofNullable(clazz.cast(dataStartTime()));
        case "DataEndTime":
            return Optional.ofNullable(clazz.cast(dataEndTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SensorStatisticsSummary, T> g) {
        return obj -> g.apply((SensorStatisticsSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SensorStatisticsSummary> {
        /**
         * <p>
         * Name of the component to which the particular sensor belongs for which the statistics belong to.
         * </p>
         * 
         * @param componentName
         *        Name of the component to which the particular sensor belongs for which the statistics belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentName(String componentName);

        /**
         * <p>
         * Name of the sensor that the statistics belong to.
         * </p>
         * 
         * @param sensorName
         *        Name of the sensor that the statistics belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensorName(String sensorName);

        /**
         * <p>
         * Parameter that indicates whether data exists for the sensor that the statistics belong to.
         * </p>
         * 
         * @param dataExists
         *        Parameter that indicates whether data exists for the sensor that the statistics belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataExists(Boolean dataExists);

        /**
         * <p>
         * Parameter that describes the total number of, and percentage of, values that are missing for the sensor that
         * the statistics belong to.
         * </p>
         * 
         * @param missingValues
         *        Parameter that describes the total number of, and percentage of, values that are missing for the
         *        sensor that the statistics belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingValues(CountPercent missingValues);

        /**
         * <p>
         * Parameter that describes the total number of, and percentage of, values that are missing for the sensor that
         * the statistics belong to.
         * </p>
         * This is a convenience method that creates an instance of the {@link CountPercent.Builder} avoiding the need
         * to create one manually via {@link CountPercent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CountPercent.Builder#build()} is called immediately and its
         * result is passed to {@link #missingValues(CountPercent)}.
         * 
         * @param missingValues
         *        a consumer that will call methods on {@link CountPercent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #missingValues(CountPercent)
         */
        default Builder missingValues(Consumer<CountPercent.Builder> missingValues) {
            return missingValues(CountPercent.builder().applyMutation(missingValues).build());
        }

        /**
         * <p>
         * Parameter that describes the total number of, and percentage of, values that are invalid for the sensor that
         * the statistics belong to.
         * </p>
         * 
         * @param invalidValues
         *        Parameter that describes the total number of, and percentage of, values that are invalid for the
         *        sensor that the statistics belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidValues(CountPercent invalidValues);

        /**
         * <p>
         * Parameter that describes the total number of, and percentage of, values that are invalid for the sensor that
         * the statistics belong to.
         * </p>
         * This is a convenience method that creates an instance of the {@link CountPercent.Builder} avoiding the need
         * to create one manually via {@link CountPercent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CountPercent.Builder#build()} is called immediately and its
         * result is passed to {@link #invalidValues(CountPercent)}.
         * 
         * @param invalidValues
         *        a consumer that will call methods on {@link CountPercent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invalidValues(CountPercent)
         */
        default Builder invalidValues(Consumer<CountPercent.Builder> invalidValues) {
            return invalidValues(CountPercent.builder().applyMutation(invalidValues).build());
        }

        /**
         * <p>
         * Parameter that describes the total number of invalid date entries associated with the sensor that the
         * statistics belong to.
         * </p>
         * 
         * @param invalidDateEntries
         *        Parameter that describes the total number of invalid date entries associated with the sensor that the
         *        statistics belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidDateEntries(CountPercent invalidDateEntries);

        /**
         * <p>
         * Parameter that describes the total number of invalid date entries associated with the sensor that the
         * statistics belong to.
         * </p>
         * This is a convenience method that creates an instance of the {@link CountPercent.Builder} avoiding the need
         * to create one manually via {@link CountPercent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CountPercent.Builder#build()} is called immediately and its
         * result is passed to {@link #invalidDateEntries(CountPercent)}.
         * 
         * @param invalidDateEntries
         *        a consumer that will call methods on {@link CountPercent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invalidDateEntries(CountPercent)
         */
        default Builder invalidDateEntries(Consumer<CountPercent.Builder> invalidDateEntries) {
            return invalidDateEntries(CountPercent.builder().applyMutation(invalidDateEntries).build());
        }

        /**
         * <p>
         * Parameter that describes the total number of duplicate timestamp records associated with the sensor that the
         * statistics belong to.
         * </p>
         * 
         * @param duplicateTimestamps
         *        Parameter that describes the total number of duplicate timestamp records associated with the sensor
         *        that the statistics belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duplicateTimestamps(CountPercent duplicateTimestamps);

        /**
         * <p>
         * Parameter that describes the total number of duplicate timestamp records associated with the sensor that the
         * statistics belong to.
         * </p>
         * This is a convenience method that creates an instance of the {@link CountPercent.Builder} avoiding the need
         * to create one manually via {@link CountPercent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CountPercent.Builder#build()} is called immediately and its
         * result is passed to {@link #duplicateTimestamps(CountPercent)}.
         * 
         * @param duplicateTimestamps
         *        a consumer that will call methods on {@link CountPercent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #duplicateTimestamps(CountPercent)
         */
        default Builder duplicateTimestamps(Consumer<CountPercent.Builder> duplicateTimestamps) {
            return duplicateTimestamps(CountPercent.builder().applyMutation(duplicateTimestamps).build());
        }

        /**
         * <p>
         * Parameter that describes potential risk about whether data associated with the sensor is categorical.
         * </p>
         * 
         * @param categoricalValues
         *        Parameter that describes potential risk about whether data associated with the sensor is categorical.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoricalValues(CategoricalValues categoricalValues);

        /**
         * <p>
         * Parameter that describes potential risk about whether data associated with the sensor is categorical.
         * </p>
         * This is a convenience method that creates an instance of the {@link CategoricalValues.Builder} avoiding the
         * need to create one manually via {@link CategoricalValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CategoricalValues.Builder#build()} is called immediately and its
         * result is passed to {@link #categoricalValues(CategoricalValues)}.
         * 
         * @param categoricalValues
         *        a consumer that will call methods on {@link CategoricalValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoricalValues(CategoricalValues)
         */
        default Builder categoricalValues(Consumer<CategoricalValues.Builder> categoricalValues) {
            return categoricalValues(CategoricalValues.builder().applyMutation(categoricalValues).build());
        }

        /**
         * <p>
         * Parameter that describes potential risk about whether data associated with the sensor has more than one
         * operating mode.
         * </p>
         * 
         * @param multipleOperatingModes
         *        Parameter that describes potential risk about whether data associated with the sensor has more than
         *        one operating mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multipleOperatingModes(MultipleOperatingModes multipleOperatingModes);

        /**
         * <p>
         * Parameter that describes potential risk about whether data associated with the sensor has more than one
         * operating mode.
         * </p>
         * This is a convenience method that creates an instance of the {@link MultipleOperatingModes.Builder} avoiding
         * the need to create one manually via {@link MultipleOperatingModes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MultipleOperatingModes.Builder#build()} is called immediately and
         * its result is passed to {@link #multipleOperatingModes(MultipleOperatingModes)}.
         * 
         * @param multipleOperatingModes
         *        a consumer that will call methods on {@link MultipleOperatingModes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multipleOperatingModes(MultipleOperatingModes)
         */
        default Builder multipleOperatingModes(Consumer<MultipleOperatingModes.Builder> multipleOperatingModes) {
            return multipleOperatingModes(MultipleOperatingModes.builder().applyMutation(multipleOperatingModes).build());
        }

        /**
         * <p>
         * Parameter that describes potential risk about whether data associated with the sensor contains one or more
         * large gaps between consecutive timestamps.
         * </p>
         * 
         * @param largeTimestampGaps
         *        Parameter that describes potential risk about whether data associated with the sensor contains one or
         *        more large gaps between consecutive timestamps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder largeTimestampGaps(LargeTimestampGaps largeTimestampGaps);

        /**
         * <p>
         * Parameter that describes potential risk about whether data associated with the sensor contains one or more
         * large gaps between consecutive timestamps.
         * </p>
         * This is a convenience method that creates an instance of the {@link LargeTimestampGaps.Builder} avoiding the
         * need to create one manually via {@link LargeTimestampGaps#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LargeTimestampGaps.Builder#build()} is called immediately and its
         * result is passed to {@link #largeTimestampGaps(LargeTimestampGaps)}.
         * 
         * @param largeTimestampGaps
         *        a consumer that will call methods on {@link LargeTimestampGaps.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #largeTimestampGaps(LargeTimestampGaps)
         */
        default Builder largeTimestampGaps(Consumer<LargeTimestampGaps.Builder> largeTimestampGaps) {
            return largeTimestampGaps(LargeTimestampGaps.builder().applyMutation(largeTimestampGaps).build());
        }

        /**
         * <p>
         * Parameter that describes potential risk about whether data associated with the sensor is mostly monotonic.
         * </p>
         * 
         * @param monotonicValues
         *        Parameter that describes potential risk about whether data associated with the sensor is mostly
         *        monotonic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monotonicValues(MonotonicValues monotonicValues);

        /**
         * <p>
         * Parameter that describes potential risk about whether data associated with the sensor is mostly monotonic.
         * </p>
         * This is a convenience method that creates an instance of the {@link MonotonicValues.Builder} avoiding the
         * need to create one manually via {@link MonotonicValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonotonicValues.Builder#build()} is called immediately and its
         * result is passed to {@link #monotonicValues(MonotonicValues)}.
         * 
         * @param monotonicValues
         *        a consumer that will call methods on {@link MonotonicValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monotonicValues(MonotonicValues)
         */
        default Builder monotonicValues(Consumer<MonotonicValues.Builder> monotonicValues) {
            return monotonicValues(MonotonicValues.builder().applyMutation(monotonicValues).build());
        }

        /**
         * <p>
         * Indicates the time reference to indicate the beginning of valid data associated with the sensor that the
         * statistics belong to.
         * </p>
         * 
         * @param dataStartTime
         *        Indicates the time reference to indicate the beginning of valid data associated with the sensor that
         *        the statistics belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataStartTime(Instant dataStartTime);

        /**
         * <p>
         * Indicates the time reference to indicate the end of valid data associated with the sensor that the statistics
         * belong to.
         * </p>
         * 
         * @param dataEndTime
         *        Indicates the time reference to indicate the end of valid data associated with the sensor that the
         *        statistics belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataEndTime(Instant dataEndTime);
    }

    static final class BuilderImpl implements Builder {
        private String componentName;

        private String sensorName;

        private Boolean dataExists;

        private CountPercent missingValues;

        private CountPercent invalidValues;

        private CountPercent invalidDateEntries;

        private CountPercent duplicateTimestamps;

        private CategoricalValues categoricalValues;

        private MultipleOperatingModes multipleOperatingModes;

        private LargeTimestampGaps largeTimestampGaps;

        private MonotonicValues monotonicValues;

        private Instant dataStartTime;

        private Instant dataEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SensorStatisticsSummary model) {
            componentName(model.componentName);
            sensorName(model.sensorName);
            dataExists(model.dataExists);
            missingValues(model.missingValues);
            invalidValues(model.invalidValues);
            invalidDateEntries(model.invalidDateEntries);
            duplicateTimestamps(model.duplicateTimestamps);
            categoricalValues(model.categoricalValues);
            multipleOperatingModes(model.multipleOperatingModes);
            largeTimestampGaps(model.largeTimestampGaps);
            monotonicValues(model.monotonicValues);
            dataStartTime(model.dataStartTime);
            dataEndTime(model.dataEndTime);
        }

        public final String getComponentName() {
            return componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getSensorName() {
            return sensorName;
        }

        public final void setSensorName(String sensorName) {
            this.sensorName = sensorName;
        }

        @Override
        public final Builder sensorName(String sensorName) {
            this.sensorName = sensorName;
            return this;
        }

        public final Boolean getDataExists() {
            return dataExists;
        }

        public final void setDataExists(Boolean dataExists) {
            this.dataExists = dataExists;
        }

        @Override
        public final Builder dataExists(Boolean dataExists) {
            this.dataExists = dataExists;
            return this;
        }

        public final CountPercent.Builder getMissingValues() {
            return missingValues != null ? missingValues.toBuilder() : null;
        }

        public final void setMissingValues(CountPercent.BuilderImpl missingValues) {
            this.missingValues = missingValues != null ? missingValues.build() : null;
        }

        @Override
        public final Builder missingValues(CountPercent missingValues) {
            this.missingValues = missingValues;
            return this;
        }

        public final CountPercent.Builder getInvalidValues() {
            return invalidValues != null ? invalidValues.toBuilder() : null;
        }

        public final void setInvalidValues(CountPercent.BuilderImpl invalidValues) {
            this.invalidValues = invalidValues != null ? invalidValues.build() : null;
        }

        @Override
        public final Builder invalidValues(CountPercent invalidValues) {
            this.invalidValues = invalidValues;
            return this;
        }

        public final CountPercent.Builder getInvalidDateEntries() {
            return invalidDateEntries != null ? invalidDateEntries.toBuilder() : null;
        }

        public final void setInvalidDateEntries(CountPercent.BuilderImpl invalidDateEntries) {
            this.invalidDateEntries = invalidDateEntries != null ? invalidDateEntries.build() : null;
        }

        @Override
        public final Builder invalidDateEntries(CountPercent invalidDateEntries) {
            this.invalidDateEntries = invalidDateEntries;
            return this;
        }

        public final CountPercent.Builder getDuplicateTimestamps() {
            return duplicateTimestamps != null ? duplicateTimestamps.toBuilder() : null;
        }

        public final void setDuplicateTimestamps(CountPercent.BuilderImpl duplicateTimestamps) {
            this.duplicateTimestamps = duplicateTimestamps != null ? duplicateTimestamps.build() : null;
        }

        @Override
        public final Builder duplicateTimestamps(CountPercent duplicateTimestamps) {
            this.duplicateTimestamps = duplicateTimestamps;
            return this;
        }

        public final CategoricalValues.Builder getCategoricalValues() {
            return categoricalValues != null ? categoricalValues.toBuilder() : null;
        }

        public final void setCategoricalValues(CategoricalValues.BuilderImpl categoricalValues) {
            this.categoricalValues = categoricalValues != null ? categoricalValues.build() : null;
        }

        @Override
        public final Builder categoricalValues(CategoricalValues categoricalValues) {
            this.categoricalValues = categoricalValues;
            return this;
        }

        public final MultipleOperatingModes.Builder getMultipleOperatingModes() {
            return multipleOperatingModes != null ? multipleOperatingModes.toBuilder() : null;
        }

        public final void setMultipleOperatingModes(MultipleOperatingModes.BuilderImpl multipleOperatingModes) {
            this.multipleOperatingModes = multipleOperatingModes != null ? multipleOperatingModes.build() : null;
        }

        @Override
        public final Builder multipleOperatingModes(MultipleOperatingModes multipleOperatingModes) {
            this.multipleOperatingModes = multipleOperatingModes;
            return this;
        }

        public final LargeTimestampGaps.Builder getLargeTimestampGaps() {
            return largeTimestampGaps != null ? largeTimestampGaps.toBuilder() : null;
        }

        public final void setLargeTimestampGaps(LargeTimestampGaps.BuilderImpl largeTimestampGaps) {
            this.largeTimestampGaps = largeTimestampGaps != null ? largeTimestampGaps.build() : null;
        }

        @Override
        public final Builder largeTimestampGaps(LargeTimestampGaps largeTimestampGaps) {
            this.largeTimestampGaps = largeTimestampGaps;
            return this;
        }

        public final MonotonicValues.Builder getMonotonicValues() {
            return monotonicValues != null ? monotonicValues.toBuilder() : null;
        }

        public final void setMonotonicValues(MonotonicValues.BuilderImpl monotonicValues) {
            this.monotonicValues = monotonicValues != null ? monotonicValues.build() : null;
        }

        @Override
        public final Builder monotonicValues(MonotonicValues monotonicValues) {
            this.monotonicValues = monotonicValues;
            return this;
        }

        public final Instant getDataStartTime() {
            return dataStartTime;
        }

        public final void setDataStartTime(Instant dataStartTime) {
            this.dataStartTime = dataStartTime;
        }

        @Override
        public final Builder dataStartTime(Instant dataStartTime) {
            this.dataStartTime = dataStartTime;
            return this;
        }

        public final Instant getDataEndTime() {
            return dataEndTime;
        }

        public final void setDataEndTime(Instant dataEndTime) {
            this.dataEndTime = dataEndTime;
        }

        @Override
        public final Builder dataEndTime(Instant dataEndTime) {
            this.dataEndTime = dataEndTime;
            return this;
        }

        @Override
        public SensorStatisticsSummary build() {
            return new SensorStatisticsSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
