/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLabelRequest extends LookoutEquipmentRequest implements
        ToCopyableBuilder<CreateLabelRequest.Builder, CreateLabelRequest> {
    private static final SdkField<String> LABEL_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelGroupName").getter(getter(CreateLabelRequest::labelGroupName))
            .setter(setter(Builder::labelGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelGroupName").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(CreateLabelRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(CreateLabelRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> RATING_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Rating")
            .getter(getter(CreateLabelRequest::ratingAsString)).setter(setter(Builder::rating))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rating").build()).build();

    private static final SdkField<String> FAULT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FaultCode").getter(getter(CreateLabelRequest::faultCode)).setter(setter(Builder::faultCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaultCode").build()).build();

    private static final SdkField<String> NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Notes")
            .getter(getter(CreateLabelRequest::notes)).setter(setter(Builder::notes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()).build();

    private static final SdkField<String> EQUIPMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Equipment").getter(getter(CreateLabelRequest::equipment)).setter(setter(Builder::equipment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Equipment").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateLabelRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_GROUP_NAME_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, RATING_FIELD, FAULT_CODE_FIELD, NOTES_FIELD, EQUIPMENT_FIELD, CLIENT_TOKEN_FIELD));

    private final String labelGroupName;

    private final Instant startTime;

    private final Instant endTime;

    private final String rating;

    private final String faultCode;

    private final String notes;

    private final String equipment;

    private final String clientToken;

    private CreateLabelRequest(BuilderImpl builder) {
        super(builder);
        this.labelGroupName = builder.labelGroupName;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.rating = builder.rating;
        this.faultCode = builder.faultCode;
        this.notes = builder.notes;
        this.equipment = builder.equipment;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of a group of labels.
     * </p>
     * <p>
     * Data in this field will be retained for service usage. Follow best practices for the security of your data.
     * </p>
     * 
     * @return The name of a group of labels. </p>
     *         <p>
     *         Data in this field will be retained for service usage. Follow best practices for the security of your
     *         data.
     */
    public final String labelGroupName() {
        return labelGroupName;
    }

    /**
     * <p>
     * The start time of the labeled event.
     * </p>
     * 
     * @return The start time of the labeled event.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time of the labeled event.
     * </p>
     * 
     * @return The end time of the labeled event.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Indicates whether a labeled event represents an anomaly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rating} will
     * return {@link LabelRating#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ratingAsString}.
     * </p>
     * 
     * @return Indicates whether a labeled event represents an anomaly.
     * @see LabelRating
     */
    public final LabelRating rating() {
        return LabelRating.fromValue(rating);
    }

    /**
     * <p>
     * Indicates whether a labeled event represents an anomaly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rating} will
     * return {@link LabelRating#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ratingAsString}.
     * </p>
     * 
     * @return Indicates whether a labeled event represents an anomaly.
     * @see LabelRating
     */
    public final String ratingAsString() {
        return rating;
    }

    /**
     * <p>
     * Provides additional information about the label. The fault code must be defined in the FaultCodes attribute of
     * the label group.
     * </p>
     * <p>
     * Data in this field will be retained for service usage. Follow best practices for the security of your data.
     * </p>
     * 
     * @return Provides additional information about the label. The fault code must be defined in the FaultCodes
     *         attribute of the label group.</p>
     *         <p>
     *         Data in this field will be retained for service usage. Follow best practices for the security of your
     *         data.
     */
    public final String faultCode() {
        return faultCode;
    }

    /**
     * <p>
     * Metadata providing additional information about the label.
     * </p>
     * <p>
     * Data in this field will be retained for service usage. Follow best practices for the security of your data.
     * </p>
     * 
     * @return Metadata providing additional information about the label. </p>
     *         <p>
     *         Data in this field will be retained for service usage. Follow best practices for the security of your
     *         data.
     */
    public final String notes() {
        return notes;
    }

    /**
     * <p>
     * Indicates that a label pertains to a particular piece of equipment.
     * </p>
     * <p>
     * Data in this field will be retained for service usage. Follow best practices for the security of your data.
     * </p>
     * 
     * @return Indicates that a label pertains to a particular piece of equipment. </p>
     *         <p>
     *         Data in this field will be retained for service usage. Follow best practices for the security of your
     *         data.
     */
    public final String equipment() {
        return equipment;
    }

    /**
     * <p>
     * A unique identifier for the request to create a label. If you do not set the client request token, Lookout for
     * Equipment generates one.
     * </p>
     * 
     * @return A unique identifier for the request to create a label. If you do not set the client request token,
     *         Lookout for Equipment generates one.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(labelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(ratingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(faultCode());
        hashCode = 31 * hashCode + Objects.hashCode(notes());
        hashCode = 31 * hashCode + Objects.hashCode(equipment());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLabelRequest)) {
            return false;
        }
        CreateLabelRequest other = (CreateLabelRequest) obj;
        return Objects.equals(labelGroupName(), other.labelGroupName()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(ratingAsString(), other.ratingAsString())
                && Objects.equals(faultCode(), other.faultCode()) && Objects.equals(notes(), other.notes())
                && Objects.equals(equipment(), other.equipment()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLabelRequest").add("LabelGroupName", labelGroupName()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("Rating", ratingAsString()).add("FaultCode", faultCode()).add("Notes", notes())
                .add("Equipment", equipment()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LabelGroupName":
            return Optional.ofNullable(clazz.cast(labelGroupName()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Rating":
            return Optional.ofNullable(clazz.cast(ratingAsString()));
        case "FaultCode":
            return Optional.ofNullable(clazz.cast(faultCode()));
        case "Notes":
            return Optional.ofNullable(clazz.cast(notes()));
        case "Equipment":
            return Optional.ofNullable(clazz.cast(equipment()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLabelRequest, T> g) {
        return obj -> g.apply((CreateLabelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLabelRequest> {
        /**
         * <p>
         * The name of a group of labels.
         * </p>
         * <p>
         * Data in this field will be retained for service usage. Follow best practices for the security of your data.
         * </p>
         * 
         * @param labelGroupName
         *        The name of a group of labels. </p>
         *        <p>
         *        Data in this field will be retained for service usage. Follow best practices for the security of your
         *        data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelGroupName(String labelGroupName);

        /**
         * <p>
         * The start time of the labeled event.
         * </p>
         * 
         * @param startTime
         *        The start time of the labeled event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time of the labeled event.
         * </p>
         * 
         * @param endTime
         *        The end time of the labeled event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Indicates whether a labeled event represents an anomaly.
         * </p>
         * 
         * @param rating
         *        Indicates whether a labeled event represents an anomaly.
         * @see LabelRating
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LabelRating
         */
        Builder rating(String rating);

        /**
         * <p>
         * Indicates whether a labeled event represents an anomaly.
         * </p>
         * 
         * @param rating
         *        Indicates whether a labeled event represents an anomaly.
         * @see LabelRating
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LabelRating
         */
        Builder rating(LabelRating rating);

        /**
         * <p>
         * Provides additional information about the label. The fault code must be defined in the FaultCodes attribute
         * of the label group.
         * </p>
         * <p>
         * Data in this field will be retained for service usage. Follow best practices for the security of your data.
         * </p>
         * 
         * @param faultCode
         *        Provides additional information about the label. The fault code must be defined in the FaultCodes
         *        attribute of the label group.</p>
         *        <p>
         *        Data in this field will be retained for service usage. Follow best practices for the security of your
         *        data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faultCode(String faultCode);

        /**
         * <p>
         * Metadata providing additional information about the label.
         * </p>
         * <p>
         * Data in this field will be retained for service usage. Follow best practices for the security of your data.
         * </p>
         * 
         * @param notes
         *        Metadata providing additional information about the label. </p>
         *        <p>
         *        Data in this field will be retained for service usage. Follow best practices for the security of your
         *        data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notes(String notes);

        /**
         * <p>
         * Indicates that a label pertains to a particular piece of equipment.
         * </p>
         * <p>
         * Data in this field will be retained for service usage. Follow best practices for the security of your data.
         * </p>
         * 
         * @param equipment
         *        Indicates that a label pertains to a particular piece of equipment. </p>
         *        <p>
         *        Data in this field will be retained for service usage. Follow best practices for the security of your
         *        data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equipment(String equipment);

        /**
         * <p>
         * A unique identifier for the request to create a label. If you do not set the client request token, Lookout
         * for Equipment generates one.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier for the request to create a label. If you do not set the client request token,
         *        Lookout for Equipment generates one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutEquipmentRequest.BuilderImpl implements Builder {
        private String labelGroupName;

        private Instant startTime;

        private Instant endTime;

        private String rating;

        private String faultCode;

        private String notes;

        private String equipment;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLabelRequest model) {
            super(model);
            labelGroupName(model.labelGroupName);
            startTime(model.startTime);
            endTime(model.endTime);
            rating(model.rating);
            faultCode(model.faultCode);
            notes(model.notes);
            equipment(model.equipment);
            clientToken(model.clientToken);
        }

        public final String getLabelGroupName() {
            return labelGroupName;
        }

        public final void setLabelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
        }

        @Override
        public final Builder labelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getRating() {
            return rating;
        }

        public final void setRating(String rating) {
            this.rating = rating;
        }

        @Override
        public final Builder rating(String rating) {
            this.rating = rating;
            return this;
        }

        @Override
        public final Builder rating(LabelRating rating) {
            this.rating(rating == null ? null : rating.toString());
            return this;
        }

        public final String getFaultCode() {
            return faultCode;
        }

        public final void setFaultCode(String faultCode) {
            this.faultCode = faultCode;
        }

        @Override
        public final Builder faultCode(String faultCode) {
            this.faultCode = faultCode;
            return this;
        }

        public final String getNotes() {
            return notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final String getEquipment() {
            return equipment;
        }

        public final void setEquipment(String equipment) {
            this.equipment = equipment;
        }

        @Override
        public final Builder equipment(String equipment) {
            this.equipment = equipment;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLabelRequest build() {
            return new CreateLabelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
