/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentClient;
import software.amazon.awssdk.services.lookoutequipment.internal.UserAgentUtils;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersResponse;

public class ListInferenceSchedulersIterable
implements SdkIterable<ListInferenceSchedulersResponse> {
    private final LookoutEquipmentClient client;
    private final ListInferenceSchedulersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInferenceSchedulersIterable(LookoutEquipmentClient client, ListInferenceSchedulersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInferenceSchedulersResponseFetcher();
    }

    public Iterator<ListInferenceSchedulersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListInferenceSchedulersResponseFetcher
    implements SyncPageFetcher<ListInferenceSchedulersResponse> {
        private ListInferenceSchedulersResponseFetcher() {
        }

        public boolean hasNextPage(ListInferenceSchedulersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInferenceSchedulersResponse nextPage(ListInferenceSchedulersResponse previousPage) {
            if (previousPage == null) {
                return ListInferenceSchedulersIterable.this.client.listInferenceSchedulers(ListInferenceSchedulersIterable.this.firstRequest);
            }
            return ListInferenceSchedulersIterable.this.client.listInferenceSchedulers((ListInferenceSchedulersRequest)((Object)ListInferenceSchedulersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

