/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLabelsRequest extends LookoutEquipmentRequest implements
        ToCopyableBuilder<ListLabelsRequest.Builder, ListLabelsRequest> {
    private static final SdkField<String> LABEL_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelGroupName").getter(getter(ListLabelsRequest::labelGroupName))
            .setter(setter(Builder::labelGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelGroupName").build()).build();

    private static final SdkField<Instant> INTERVAL_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("IntervalStartTime").getter(getter(ListLabelsRequest::intervalStartTime))
            .setter(setter(Builder::intervalStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntervalStartTime").build()).build();

    private static final SdkField<Instant> INTERVAL_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("IntervalEndTime").getter(getter(ListLabelsRequest::intervalEndTime))
            .setter(setter(Builder::intervalEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntervalEndTime").build()).build();

    private static final SdkField<String> FAULT_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FaultCode").getter(getter(ListLabelsRequest::faultCode)).setter(setter(Builder::faultCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaultCode").build()).build();

    private static final SdkField<String> EQUIPMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Equipment").getter(getter(ListLabelsRequest::equipment)).setter(setter(Builder::equipment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Equipment").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLabelsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListLabelsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_GROUP_NAME_FIELD,
            INTERVAL_START_TIME_FIELD, INTERVAL_END_TIME_FIELD, FAULT_CODE_FIELD, EQUIPMENT_FIELD, NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD));

    private final String labelGroupName;

    private final Instant intervalStartTime;

    private final Instant intervalEndTime;

    private final String faultCode;

    private final String equipment;

    private final String nextToken;

    private final Integer maxResults;

    private ListLabelsRequest(BuilderImpl builder) {
        super(builder);
        this.labelGroupName = builder.labelGroupName;
        this.intervalStartTime = builder.intervalStartTime;
        this.intervalEndTime = builder.intervalEndTime;
        this.faultCode = builder.faultCode;
        this.equipment = builder.equipment;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Returns the name of the label group.
     * </p>
     * 
     * @return Returns the name of the label group.
     */
    public final String labelGroupName() {
        return labelGroupName;
    }

    /**
     * <p>
     * Returns all the labels with a end time equal to or later than the start time given.
     * </p>
     * 
     * @return Returns all the labels with a end time equal to or later than the start time given.
     */
    public final Instant intervalStartTime() {
        return intervalStartTime;
    }

    /**
     * <p>
     * Returns all labels with a start time earlier than the end time given.
     * </p>
     * 
     * @return Returns all labels with a start time earlier than the end time given.
     */
    public final Instant intervalEndTime() {
        return intervalEndTime;
    }

    /**
     * <p>
     * Returns labels with a particular fault code.
     * </p>
     * 
     * @return Returns labels with a particular fault code.
     */
    public final String faultCode() {
        return faultCode;
    }

    /**
     * <p>
     * Lists the labels that pertain to a particular piece of equipment.
     * </p>
     * 
     * @return Lists the labels that pertain to a particular piece of equipment.
     */
    public final String equipment() {
        return equipment;
    }

    /**
     * <p>
     * An opaque pagination token indicating where to continue the listing of label groups.
     * </p>
     * 
     * @return An opaque pagination token indicating where to continue the listing of label groups.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the maximum number of labels to list.
     * </p>
     * 
     * @return Specifies the maximum number of labels to list.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(labelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(intervalStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(intervalEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(faultCode());
        hashCode = 31 * hashCode + Objects.hashCode(equipment());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLabelsRequest)) {
            return false;
        }
        ListLabelsRequest other = (ListLabelsRequest) obj;
        return Objects.equals(labelGroupName(), other.labelGroupName())
                && Objects.equals(intervalStartTime(), other.intervalStartTime())
                && Objects.equals(intervalEndTime(), other.intervalEndTime()) && Objects.equals(faultCode(), other.faultCode())
                && Objects.equals(equipment(), other.equipment()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLabelsRequest").add("LabelGroupName", labelGroupName())
                .add("IntervalStartTime", intervalStartTime()).add("IntervalEndTime", intervalEndTime())
                .add("FaultCode", faultCode()).add("Equipment", equipment()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LabelGroupName":
            return Optional.ofNullable(clazz.cast(labelGroupName()));
        case "IntervalStartTime":
            return Optional.ofNullable(clazz.cast(intervalStartTime()));
        case "IntervalEndTime":
            return Optional.ofNullable(clazz.cast(intervalEndTime()));
        case "FaultCode":
            return Optional.ofNullable(clazz.cast(faultCode()));
        case "Equipment":
            return Optional.ofNullable(clazz.cast(equipment()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLabelsRequest, T> g) {
        return obj -> g.apply((ListLabelsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListLabelsRequest> {
        /**
         * <p>
         * Returns the name of the label group.
         * </p>
         * 
         * @param labelGroupName
         *        Returns the name of the label group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelGroupName(String labelGroupName);

        /**
         * <p>
         * Returns all the labels with a end time equal to or later than the start time given.
         * </p>
         * 
         * @param intervalStartTime
         *        Returns all the labels with a end time equal to or later than the start time given.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intervalStartTime(Instant intervalStartTime);

        /**
         * <p>
         * Returns all labels with a start time earlier than the end time given.
         * </p>
         * 
         * @param intervalEndTime
         *        Returns all labels with a start time earlier than the end time given.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intervalEndTime(Instant intervalEndTime);

        /**
         * <p>
         * Returns labels with a particular fault code.
         * </p>
         * 
         * @param faultCode
         *        Returns labels with a particular fault code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faultCode(String faultCode);

        /**
         * <p>
         * Lists the labels that pertain to a particular piece of equipment.
         * </p>
         * 
         * @param equipment
         *        Lists the labels that pertain to a particular piece of equipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equipment(String equipment);

        /**
         * <p>
         * An opaque pagination token indicating where to continue the listing of label groups.
         * </p>
         * 
         * @param nextToken
         *        An opaque pagination token indicating where to continue the listing of label groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the maximum number of labels to list.
         * </p>
         * 
         * @param maxResults
         *        Specifies the maximum number of labels to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutEquipmentRequest.BuilderImpl implements Builder {
        private String labelGroupName;

        private Instant intervalStartTime;

        private Instant intervalEndTime;

        private String faultCode;

        private String equipment;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLabelsRequest model) {
            super(model);
            labelGroupName(model.labelGroupName);
            intervalStartTime(model.intervalStartTime);
            intervalEndTime(model.intervalEndTime);
            faultCode(model.faultCode);
            equipment(model.equipment);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getLabelGroupName() {
            return labelGroupName;
        }

        public final void setLabelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
        }

        @Override
        public final Builder labelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
            return this;
        }

        public final Instant getIntervalStartTime() {
            return intervalStartTime;
        }

        public final void setIntervalStartTime(Instant intervalStartTime) {
            this.intervalStartTime = intervalStartTime;
        }

        @Override
        public final Builder intervalStartTime(Instant intervalStartTime) {
            this.intervalStartTime = intervalStartTime;
            return this;
        }

        public final Instant getIntervalEndTime() {
            return intervalEndTime;
        }

        public final void setIntervalEndTime(Instant intervalEndTime) {
            this.intervalEndTime = intervalEndTime;
        }

        @Override
        public final Builder intervalEndTime(Instant intervalEndTime) {
            this.intervalEndTime = intervalEndTime;
            return this;
        }

        public final String getFaultCode() {
            return faultCode;
        }

        public final void setFaultCode(String faultCode) {
            this.faultCode = faultCode;
        }

        @Override
        public final Builder faultCode(String faultCode) {
            this.faultCode = faultCode;
            return this;
        }

        public final String getEquipment() {
            return equipment;
        }

        public final void setEquipment(String equipment) {
            this.equipment = equipment;
        }

        @Override
        public final Builder equipment(String equipment) {
            this.equipment = equipment;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLabelsRequest build() {
            return new ListLabelsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
