/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionStatus;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInferenceExecutionsRequest
extends LookoutEquipmentRequest
implements ToCopyableBuilder<Builder, ListInferenceExecutionsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInferenceExecutionsRequest.getter(ListInferenceExecutionsRequest::nextToken)).setter(ListInferenceExecutionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListInferenceExecutionsRequest.getter(ListInferenceExecutionsRequest::maxResults)).setter(ListInferenceExecutionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> INFERENCE_SCHEDULER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceSchedulerName").getter(ListInferenceExecutionsRequest.getter(ListInferenceExecutionsRequest::inferenceSchedulerName)).setter(ListInferenceExecutionsRequest.setter(Builder::inferenceSchedulerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerName").build()}).build();
    private static final SdkField<Instant> DATA_START_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DataStartTimeAfter").getter(ListInferenceExecutionsRequest.getter(ListInferenceExecutionsRequest::dataStartTimeAfter)).setter(ListInferenceExecutionsRequest.setter(Builder::dataStartTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataStartTimeAfter").build()}).build();
    private static final SdkField<Instant> DATA_END_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DataEndTimeBefore").getter(ListInferenceExecutionsRequest.getter(ListInferenceExecutionsRequest::dataEndTimeBefore)).setter(ListInferenceExecutionsRequest.setter(Builder::dataEndTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataEndTimeBefore").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListInferenceExecutionsRequest.getter(ListInferenceExecutionsRequest::statusAsString)).setter(ListInferenceExecutionsRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, INFERENCE_SCHEDULER_NAME_FIELD, DATA_START_TIME_AFTER_FIELD, DATA_END_TIME_BEFORE_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("InferenceSchedulerName", INFERENCE_SCHEDULER_NAME_FIELD);
            this.put("DataStartTimeAfter", DATA_START_TIME_AFTER_FIELD);
            this.put("DataEndTimeBefore", DATA_END_TIME_BEFORE_FIELD);
            this.put("Status", STATUS_FIELD);
        }
    });
    private final String nextToken;
    private final Integer maxResults;
    private final String inferenceSchedulerName;
    private final Instant dataStartTimeAfter;
    private final Instant dataEndTimeBefore;
    private final String status;

    private ListInferenceExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.inferenceSchedulerName = builder.inferenceSchedulerName;
        this.dataStartTimeAfter = builder.dataStartTimeAfter;
        this.dataEndTimeBefore = builder.dataEndTimeBefore;
        this.status = builder.status;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String inferenceSchedulerName() {
        return this.inferenceSchedulerName;
    }

    public final Instant dataStartTimeAfter() {
        return this.dataStartTimeAfter;
    }

    public final Instant dataEndTimeBefore() {
        return this.dataEndTimeBefore;
    }

    public final InferenceExecutionStatus status() {
        return InferenceExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSchedulerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStartTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataEndTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInferenceExecutionsRequest)) {
            return false;
        }
        ListInferenceExecutionsRequest other = (ListInferenceExecutionsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.inferenceSchedulerName(), other.inferenceSchedulerName()) && Objects.equals(this.dataStartTimeAfter(), other.dataStartTimeAfter()) && Objects.equals(this.dataEndTimeBefore(), other.dataEndTimeBefore()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListInferenceExecutionsRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("InferenceSchedulerName", (Object)this.inferenceSchedulerName()).add("DataStartTimeAfter", (Object)this.dataStartTimeAfter()).add("DataEndTimeBefore", (Object)this.dataEndTimeBefore()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "InferenceSchedulerName": {
                return Optional.ofNullable(clazz.cast(this.inferenceSchedulerName()));
            }
            case "DataStartTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.dataStartTimeAfter()));
            }
            case "DataEndTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.dataEndTimeBefore()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListInferenceExecutionsRequest, T> g) {
        return obj -> g.apply((ListInferenceExecutionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String inferenceSchedulerName;
        private Instant dataStartTimeAfter;
        private Instant dataEndTimeBefore;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInferenceExecutionsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.inferenceSchedulerName(model.inferenceSchedulerName);
            this.dataStartTimeAfter(model.dataStartTimeAfter);
            this.dataEndTimeBefore(model.dataEndTimeBefore);
            this.status(model.status);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getInferenceSchedulerName() {
            return this.inferenceSchedulerName;
        }

        public final void setInferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
        }

        @Override
        public final Builder inferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
            return this;
        }

        public final Instant getDataStartTimeAfter() {
            return this.dataStartTimeAfter;
        }

        public final void setDataStartTimeAfter(Instant dataStartTimeAfter) {
            this.dataStartTimeAfter = dataStartTimeAfter;
        }

        @Override
        public final Builder dataStartTimeAfter(Instant dataStartTimeAfter) {
            this.dataStartTimeAfter = dataStartTimeAfter;
            return this;
        }

        public final Instant getDataEndTimeBefore() {
            return this.dataEndTimeBefore;
        }

        public final void setDataEndTimeBefore(Instant dataEndTimeBefore) {
            this.dataEndTimeBefore = dataEndTimeBefore;
        }

        @Override
        public final Builder dataEndTimeBefore(Instant dataEndTimeBefore) {
            this.dataEndTimeBefore = dataEndTimeBefore;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InferenceExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInferenceExecutionsRequest build() {
            return new ListInferenceExecutionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LookoutEquipmentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInferenceExecutionsRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder inferenceSchedulerName(String var1);

        public Builder dataStartTimeAfter(Instant var1);

        public Builder dataEndTimeBefore(Instant var1);

        public Builder status(String var1);

        public Builder status(InferenceExecutionStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

