/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportModelVersionRequest extends LookoutEquipmentRequest implements
        ToCopyableBuilder<ImportModelVersionRequest.Builder, ImportModelVersionRequest> {
    private static final SdkField<String> SOURCE_MODEL_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceModelVersionArn").getter(getter(ImportModelVersionRequest::sourceModelVersionArn))
            .setter(setter(Builder::sourceModelVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceModelVersionArn").build())
            .build();

    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(ImportModelVersionRequest::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetName").getter(getter(ImportModelVersionRequest::datasetName))
            .setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()).build();

    private static final SdkField<LabelsInputConfiguration> LABELS_INPUT_CONFIGURATION_FIELD = SdkField
            .<LabelsInputConfiguration> builder(MarshallingType.SDK_POJO).memberName("LabelsInputConfiguration")
            .getter(getter(ImportModelVersionRequest::labelsInputConfiguration))
            .setter(setter(Builder::labelsInputConfiguration)).constructor(LabelsInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelsInputConfiguration").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(ImportModelVersionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(ImportModelVersionRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> SERVER_SIDE_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerSideKmsKeyId").getter(getter(ImportModelVersionRequest::serverSideKmsKeyId))
            .setter(setter(Builder::serverSideKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideKmsKeyId").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ImportModelVersionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INFERENCE_DATA_IMPORT_STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InferenceDataImportStrategy")
            .getter(getter(ImportModelVersionRequest::inferenceDataImportStrategyAsString))
            .setter(setter(Builder::inferenceDataImportStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceDataImportStrategy")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SOURCE_MODEL_VERSION_ARN_FIELD, MODEL_NAME_FIELD, DATASET_NAME_FIELD, LABELS_INPUT_CONFIGURATION_FIELD,
            CLIENT_TOKEN_FIELD, ROLE_ARN_FIELD, SERVER_SIDE_KMS_KEY_ID_FIELD, TAGS_FIELD, INFERENCE_DATA_IMPORT_STRATEGY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sourceModelVersionArn;

    private final String modelName;

    private final String datasetName;

    private final LabelsInputConfiguration labelsInputConfiguration;

    private final String clientToken;

    private final String roleArn;

    private final String serverSideKmsKeyId;

    private final List<Tag> tags;

    private final String inferenceDataImportStrategy;

    private ImportModelVersionRequest(BuilderImpl builder) {
        super(builder);
        this.sourceModelVersionArn = builder.sourceModelVersionArn;
        this.modelName = builder.modelName;
        this.datasetName = builder.datasetName;
        this.labelsInputConfiguration = builder.labelsInputConfiguration;
        this.clientToken = builder.clientToken;
        this.roleArn = builder.roleArn;
        this.serverSideKmsKeyId = builder.serverSideKmsKeyId;
        this.tags = builder.tags;
        this.inferenceDataImportStrategy = builder.inferenceDataImportStrategy;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model version to import.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model version to import.
     */
    public final String sourceModelVersionArn() {
        return sourceModelVersionArn;
    }

    /**
     * <p>
     * The name for the machine learning model to be created. If the model already exists, Amazon Lookout for Equipment
     * creates a new version. If you do not specify this field, it is filled with the name of the source model.
     * </p>
     * 
     * @return The name for the machine learning model to be created. If the model already exists, Amazon Lookout for
     *         Equipment creates a new version. If you do not specify this field, it is filled with the name of the
     *         source model.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The name of the dataset for the machine learning model being imported.
     * </p>
     * 
     * @return The name of the dataset for the machine learning model being imported.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * Returns the value of the LabelsInputConfiguration property for this object.
     * 
     * @return The value of the LabelsInputConfiguration property for this object.
     */
    public final LabelsInputConfiguration labelsInputConfiguration() {
        return labelsInputConfiguration;
    }

    /**
     * <p>
     * A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment
     * generates one.
     * </p>
     * 
     * @return A unique identifier for the request. If you do not set the client request token, Amazon Lookout for
     *         Equipment generates one.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a role with permission to access the data source being used to create the
     * machine learning model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a role with permission to access the data source being used to create
     *         the machine learning model.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Provides the identifier of the KMS key key used to encrypt model data by Amazon Lookout for Equipment.
     * </p>
     * 
     * @return Provides the identifier of the KMS key key used to encrypt model data by Amazon Lookout for Equipment.
     */
    public final String serverSideKmsKeyId() {
        return serverSideKmsKeyId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with the machine learning model to be created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the machine learning model to be created.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Indicates how to import the accumulated inference data when a model version is imported. The possible values are
     * as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * NO_IMPORT – Don't import the data.
     * </p>
     * </li>
     * <li>
     * <p>
     * ADD_WHEN_EMPTY – Only import the data from the source model if there is no existing data in the target model.
     * </p>
     * </li>
     * <li>
     * <p>
     * OVERWRITE – Import the data from the source model and overwrite the existing data in the target model.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inferenceDataImportStrategy} will return {@link InferenceDataImportStrategy#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #inferenceDataImportStrategyAsString}.
     * </p>
     * 
     * @return Indicates how to import the accumulated inference data when a model version is imported. The possible
     *         values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         NO_IMPORT – Don't import the data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ADD_WHEN_EMPTY – Only import the data from the source model if there is no existing data in the target
     *         model.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OVERWRITE – Import the data from the source model and overwrite the existing data in the target model.
     *         </p>
     *         </li>
     * @see InferenceDataImportStrategy
     */
    public final InferenceDataImportStrategy inferenceDataImportStrategy() {
        return InferenceDataImportStrategy.fromValue(inferenceDataImportStrategy);
    }

    /**
     * <p>
     * Indicates how to import the accumulated inference data when a model version is imported. The possible values are
     * as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * NO_IMPORT – Don't import the data.
     * </p>
     * </li>
     * <li>
     * <p>
     * ADD_WHEN_EMPTY – Only import the data from the source model if there is no existing data in the target model.
     * </p>
     * </li>
     * <li>
     * <p>
     * OVERWRITE – Import the data from the source model and overwrite the existing data in the target model.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inferenceDataImportStrategy} will return {@link InferenceDataImportStrategy#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #inferenceDataImportStrategyAsString}.
     * </p>
     * 
     * @return Indicates how to import the accumulated inference data when a model version is imported. The possible
     *         values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         NO_IMPORT – Don't import the data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ADD_WHEN_EMPTY – Only import the data from the source model if there is no existing data in the target
     *         model.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OVERWRITE – Import the data from the source model and overwrite the existing data in the target model.
     *         </p>
     *         </li>
     * @see InferenceDataImportStrategy
     */
    public final String inferenceDataImportStrategyAsString() {
        return inferenceDataImportStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceModelVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(labelsInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inferenceDataImportStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportModelVersionRequest)) {
            return false;
        }
        ImportModelVersionRequest other = (ImportModelVersionRequest) obj;
        return Objects.equals(sourceModelVersionArn(), other.sourceModelVersionArn())
                && Objects.equals(modelName(), other.modelName()) && Objects.equals(datasetName(), other.datasetName())
                && Objects.equals(labelsInputConfiguration(), other.labelsInputConfiguration())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(serverSideKmsKeyId(), other.serverSideKmsKeyId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(inferenceDataImportStrategyAsString(), other.inferenceDataImportStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportModelVersionRequest").add("SourceModelVersionArn", sourceModelVersionArn())
                .add("ModelName", modelName()).add("DatasetName", datasetName())
                .add("LabelsInputConfiguration", labelsInputConfiguration()).add("ClientToken", clientToken())
                .add("RoleArn", roleArn()).add("ServerSideKmsKeyId", serverSideKmsKeyId()).add("Tags", hasTags() ? tags() : null)
                .add("InferenceDataImportStrategy", inferenceDataImportStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceModelVersionArn":
            return Optional.ofNullable(clazz.cast(sourceModelVersionArn()));
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "LabelsInputConfiguration":
            return Optional.ofNullable(clazz.cast(labelsInputConfiguration()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "ServerSideKmsKeyId":
            return Optional.ofNullable(clazz.cast(serverSideKmsKeyId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "InferenceDataImportStrategy":
            return Optional.ofNullable(clazz.cast(inferenceDataImportStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceModelVersionArn", SOURCE_MODEL_VERSION_ARN_FIELD);
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("DatasetName", DATASET_NAME_FIELD);
        map.put("LabelsInputConfiguration", LABELS_INPUT_CONFIGURATION_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("ServerSideKmsKeyId", SERVER_SIDE_KMS_KEY_ID_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("InferenceDataImportStrategy", INFERENCE_DATA_IMPORT_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportModelVersionRequest, T> g) {
        return obj -> g.apply((ImportModelVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ImportModelVersionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model version to import.
         * </p>
         * 
         * @param sourceModelVersionArn
         *        The Amazon Resource Name (ARN) of the model version to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceModelVersionArn(String sourceModelVersionArn);

        /**
         * <p>
         * The name for the machine learning model to be created. If the model already exists, Amazon Lookout for
         * Equipment creates a new version. If you do not specify this field, it is filled with the name of the source
         * model.
         * </p>
         * 
         * @param modelName
         *        The name for the machine learning model to be created. If the model already exists, Amazon Lookout for
         *        Equipment creates a new version. If you do not specify this field, it is filled with the name of the
         *        source model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The name of the dataset for the machine learning model being imported.
         * </p>
         * 
         * @param datasetName
         *        The name of the dataset for the machine learning model being imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * Sets the value of the LabelsInputConfiguration property for this object.
         *
         * @param labelsInputConfiguration
         *        The new value for the LabelsInputConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelsInputConfiguration(LabelsInputConfiguration labelsInputConfiguration);

        /**
         * Sets the value of the LabelsInputConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LabelsInputConfiguration.Builder}
         * avoiding the need to create one manually via {@link LabelsInputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LabelsInputConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #labelsInputConfiguration(LabelsInputConfiguration)}.
         * 
         * @param labelsInputConfiguration
         *        a consumer that will call methods on {@link LabelsInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelsInputConfiguration(LabelsInputConfiguration)
         */
        default Builder labelsInputConfiguration(Consumer<LabelsInputConfiguration.Builder> labelsInputConfiguration) {
            return labelsInputConfiguration(LabelsInputConfiguration.builder().applyMutation(labelsInputConfiguration).build());
        }

        /**
         * <p>
         * A unique identifier for the request. If you do not set the client request token, Amazon Lookout for Equipment
         * generates one.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier for the request. If you do not set the client request token, Amazon Lookout for
         *        Equipment generates one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a role with permission to access the data source being used to create the
         * machine learning model.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of a role with permission to access the data source being used to
         *        create the machine learning model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Provides the identifier of the KMS key key used to encrypt model data by Amazon Lookout for Equipment.
         * </p>
         * 
         * @param serverSideKmsKeyId
         *        Provides the identifier of the KMS key key used to encrypt model data by Amazon Lookout for Equipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideKmsKeyId(String serverSideKmsKeyId);

        /**
         * <p>
         * The tags associated with the machine learning model to be created.
         * </p>
         * 
         * @param tags
         *        The tags associated with the machine learning model to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags associated with the machine learning model to be created.
         * </p>
         * 
         * @param tags
         *        The tags associated with the machine learning model to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags associated with the machine learning model to be created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lookoutequipment.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lookoutequipment.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lookoutequipment.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lookoutequipment.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Indicates how to import the accumulated inference data when a model version is imported. The possible values
         * are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * NO_IMPORT – Don't import the data.
         * </p>
         * </li>
         * <li>
         * <p>
         * ADD_WHEN_EMPTY – Only import the data from the source model if there is no existing data in the target model.
         * </p>
         * </li>
         * <li>
         * <p>
         * OVERWRITE – Import the data from the source model and overwrite the existing data in the target model.
         * </p>
         * </li>
         * </ul>
         * 
         * @param inferenceDataImportStrategy
         *        Indicates how to import the accumulated inference data when a model version is imported. The possible
         *        values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        NO_IMPORT – Don't import the data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ADD_WHEN_EMPTY – Only import the data from the source model if there is no existing data in the target
         *        model.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OVERWRITE – Import the data from the source model and overwrite the existing data in the target model.
         *        </p>
         *        </li>
         * @see InferenceDataImportStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceDataImportStrategy
         */
        Builder inferenceDataImportStrategy(String inferenceDataImportStrategy);

        /**
         * <p>
         * Indicates how to import the accumulated inference data when a model version is imported. The possible values
         * are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * NO_IMPORT – Don't import the data.
         * </p>
         * </li>
         * <li>
         * <p>
         * ADD_WHEN_EMPTY – Only import the data from the source model if there is no existing data in the target model.
         * </p>
         * </li>
         * <li>
         * <p>
         * OVERWRITE – Import the data from the source model and overwrite the existing data in the target model.
         * </p>
         * </li>
         * </ul>
         * 
         * @param inferenceDataImportStrategy
         *        Indicates how to import the accumulated inference data when a model version is imported. The possible
         *        values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        NO_IMPORT – Don't import the data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ADD_WHEN_EMPTY – Only import the data from the source model if there is no existing data in the target
         *        model.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OVERWRITE – Import the data from the source model and overwrite the existing data in the target model.
         *        </p>
         *        </li>
         * @see InferenceDataImportStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceDataImportStrategy
         */
        Builder inferenceDataImportStrategy(InferenceDataImportStrategy inferenceDataImportStrategy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutEquipmentRequest.BuilderImpl implements Builder {
        private String sourceModelVersionArn;

        private String modelName;

        private String datasetName;

        private LabelsInputConfiguration labelsInputConfiguration;

        private String clientToken;

        private String roleArn;

        private String serverSideKmsKeyId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String inferenceDataImportStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportModelVersionRequest model) {
            super(model);
            sourceModelVersionArn(model.sourceModelVersionArn);
            modelName(model.modelName);
            datasetName(model.datasetName);
            labelsInputConfiguration(model.labelsInputConfiguration);
            clientToken(model.clientToken);
            roleArn(model.roleArn);
            serverSideKmsKeyId(model.serverSideKmsKeyId);
            tags(model.tags);
            inferenceDataImportStrategy(model.inferenceDataImportStrategy);
        }

        public final String getSourceModelVersionArn() {
            return sourceModelVersionArn;
        }

        public final void setSourceModelVersionArn(String sourceModelVersionArn) {
            this.sourceModelVersionArn = sourceModelVersionArn;
        }

        @Override
        public final Builder sourceModelVersionArn(String sourceModelVersionArn) {
            this.sourceModelVersionArn = sourceModelVersionArn;
            return this;
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getDatasetName() {
            return datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final LabelsInputConfiguration.Builder getLabelsInputConfiguration() {
            return labelsInputConfiguration != null ? labelsInputConfiguration.toBuilder() : null;
        }

        public final void setLabelsInputConfiguration(LabelsInputConfiguration.BuilderImpl labelsInputConfiguration) {
            this.labelsInputConfiguration = labelsInputConfiguration != null ? labelsInputConfiguration.build() : null;
        }

        @Override
        public final Builder labelsInputConfiguration(LabelsInputConfiguration labelsInputConfiguration) {
            this.labelsInputConfiguration = labelsInputConfiguration;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getServerSideKmsKeyId() {
            return serverSideKmsKeyId;
        }

        public final void setServerSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
        }

        @Override
        public final Builder serverSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInferenceDataImportStrategy() {
            return inferenceDataImportStrategy;
        }

        public final void setInferenceDataImportStrategy(String inferenceDataImportStrategy) {
            this.inferenceDataImportStrategy = inferenceDataImportStrategy;
        }

        @Override
        public final Builder inferenceDataImportStrategy(String inferenceDataImportStrategy) {
            this.inferenceDataImportStrategy = inferenceDataImportStrategy;
            return this;
        }

        @Override
        public final Builder inferenceDataImportStrategy(InferenceDataImportStrategy inferenceDataImportStrategy) {
            this.inferenceDataImportStrategy(inferenceDataImportStrategy == null ? null : inferenceDataImportStrategy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportModelVersionRequest build() {
            return new ImportModelVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
