/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the specific inference event, including start and end time, diagnostics information, event
 * duration and so on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceEventSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceEventSummary.Builder, InferenceEventSummary> {
    private static final SdkField<String> INFERENCE_SCHEDULER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceSchedulerArn").getter(getter(InferenceEventSummary::inferenceSchedulerArn))
            .setter(setter(Builder::inferenceSchedulerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerArn").build())
            .build();

    private static final SdkField<String> INFERENCE_SCHEDULER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceSchedulerName").getter(getter(InferenceEventSummary::inferenceSchedulerName))
            .setter(setter(Builder::inferenceSchedulerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerName").build())
            .build();

    private static final SdkField<Instant> EVENT_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EventStartTime").getter(getter(InferenceEventSummary::eventStartTime))
            .setter(setter(Builder::eventStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventStartTime").build()).build();

    private static final SdkField<Instant> EVENT_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EventEndTime").getter(getter(InferenceEventSummary::eventEndTime)).setter(setter(Builder::eventEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventEndTime").build()).build();

    private static final SdkField<String> DIAGNOSTICS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Diagnostics").getter(getter(InferenceEventSummary::diagnostics)).setter(setter(Builder::diagnostics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Diagnostics").build()).build();

    private static final SdkField<Long> EVENT_DURATION_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("EventDurationInSeconds").getter(getter(InferenceEventSummary::eventDurationInSeconds))
            .setter(setter(Builder::eventDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDurationInSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_SCHEDULER_ARN_FIELD,
            INFERENCE_SCHEDULER_NAME_FIELD, EVENT_START_TIME_FIELD, EVENT_END_TIME_FIELD, DIAGNOSTICS_FIELD,
            EVENT_DURATION_IN_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String inferenceSchedulerArn;

    private final String inferenceSchedulerName;

    private final Instant eventStartTime;

    private final Instant eventEndTime;

    private final String diagnostics;

    private final Long eventDurationInSeconds;

    private InferenceEventSummary(BuilderImpl builder) {
        this.inferenceSchedulerArn = builder.inferenceSchedulerArn;
        this.inferenceSchedulerName = builder.inferenceSchedulerName;
        this.eventStartTime = builder.eventStartTime;
        this.eventEndTime = builder.eventEndTime;
        this.diagnostics = builder.diagnostics;
        this.eventDurationInSeconds = builder.eventDurationInSeconds;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the inference scheduler being used for the inference event.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the inference scheduler being used for the inference event.
     */
    public final String inferenceSchedulerArn() {
        return inferenceSchedulerArn;
    }

    /**
     * <p>
     * The name of the inference scheduler being used for the inference events.
     * </p>
     * 
     * @return The name of the inference scheduler being used for the inference events.
     */
    public final String inferenceSchedulerName() {
        return inferenceSchedulerName;
    }

    /**
     * <p>
     * Indicates the starting time of an inference event.
     * </p>
     * 
     * @return Indicates the starting time of an inference event.
     */
    public final Instant eventStartTime() {
        return eventStartTime;
    }

    /**
     * <p>
     * Indicates the ending time of an inference event.
     * </p>
     * 
     * @return Indicates the ending time of an inference event.
     */
    public final Instant eventEndTime() {
        return eventEndTime;
    }

    /**
     * <p>
     * An array which specifies the names and values of all sensors contributing to an inference event.
     * </p>
     * 
     * @return An array which specifies the names and values of all sensors contributing to an inference event.
     */
    public final String diagnostics() {
        return diagnostics;
    }

    /**
     * <p>
     * Indicates the size of an inference event in seconds.
     * </p>
     * 
     * @return Indicates the size of an inference event in seconds.
     */
    public final Long eventDurationInSeconds() {
        return eventDurationInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSchedulerArn());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSchedulerName());
        hashCode = 31 * hashCode + Objects.hashCode(eventStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(eventEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(diagnostics());
        hashCode = 31 * hashCode + Objects.hashCode(eventDurationInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceEventSummary)) {
            return false;
        }
        InferenceEventSummary other = (InferenceEventSummary) obj;
        return Objects.equals(inferenceSchedulerArn(), other.inferenceSchedulerArn())
                && Objects.equals(inferenceSchedulerName(), other.inferenceSchedulerName())
                && Objects.equals(eventStartTime(), other.eventStartTime())
                && Objects.equals(eventEndTime(), other.eventEndTime()) && Objects.equals(diagnostics(), other.diagnostics())
                && Objects.equals(eventDurationInSeconds(), other.eventDurationInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceEventSummary").add("InferenceSchedulerArn", inferenceSchedulerArn())
                .add("InferenceSchedulerName", inferenceSchedulerName()).add("EventStartTime", eventStartTime())
                .add("EventEndTime", eventEndTime()).add("Diagnostics", diagnostics())
                .add("EventDurationInSeconds", eventDurationInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InferenceSchedulerArn":
            return Optional.ofNullable(clazz.cast(inferenceSchedulerArn()));
        case "InferenceSchedulerName":
            return Optional.ofNullable(clazz.cast(inferenceSchedulerName()));
        case "EventStartTime":
            return Optional.ofNullable(clazz.cast(eventStartTime()));
        case "EventEndTime":
            return Optional.ofNullable(clazz.cast(eventEndTime()));
        case "Diagnostics":
            return Optional.ofNullable(clazz.cast(diagnostics()));
        case "EventDurationInSeconds":
            return Optional.ofNullable(clazz.cast(eventDurationInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InferenceSchedulerArn", INFERENCE_SCHEDULER_ARN_FIELD);
        map.put("InferenceSchedulerName", INFERENCE_SCHEDULER_NAME_FIELD);
        map.put("EventStartTime", EVENT_START_TIME_FIELD);
        map.put("EventEndTime", EVENT_END_TIME_FIELD);
        map.put("Diagnostics", DIAGNOSTICS_FIELD);
        map.put("EventDurationInSeconds", EVENT_DURATION_IN_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceEventSummary, T> g) {
        return obj -> g.apply((InferenceEventSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceEventSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the inference scheduler being used for the inference event.
         * </p>
         * 
         * @param inferenceSchedulerArn
         *        The Amazon Resource Name (ARN) of the inference scheduler being used for the inference event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSchedulerArn(String inferenceSchedulerArn);

        /**
         * <p>
         * The name of the inference scheduler being used for the inference events.
         * </p>
         * 
         * @param inferenceSchedulerName
         *        The name of the inference scheduler being used for the inference events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSchedulerName(String inferenceSchedulerName);

        /**
         * <p>
         * Indicates the starting time of an inference event.
         * </p>
         * 
         * @param eventStartTime
         *        Indicates the starting time of an inference event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventStartTime(Instant eventStartTime);

        /**
         * <p>
         * Indicates the ending time of an inference event.
         * </p>
         * 
         * @param eventEndTime
         *        Indicates the ending time of an inference event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventEndTime(Instant eventEndTime);

        /**
         * <p>
         * An array which specifies the names and values of all sensors contributing to an inference event.
         * </p>
         * 
         * @param diagnostics
         *        An array which specifies the names and values of all sensors contributing to an inference event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diagnostics(String diagnostics);

        /**
         * <p>
         * Indicates the size of an inference event in seconds.
         * </p>
         * 
         * @param eventDurationInSeconds
         *        Indicates the size of an inference event in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDurationInSeconds(Long eventDurationInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private String inferenceSchedulerArn;

        private String inferenceSchedulerName;

        private Instant eventStartTime;

        private Instant eventEndTime;

        private String diagnostics;

        private Long eventDurationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceEventSummary model) {
            inferenceSchedulerArn(model.inferenceSchedulerArn);
            inferenceSchedulerName(model.inferenceSchedulerName);
            eventStartTime(model.eventStartTime);
            eventEndTime(model.eventEndTime);
            diagnostics(model.diagnostics);
            eventDurationInSeconds(model.eventDurationInSeconds);
        }

        public final String getInferenceSchedulerArn() {
            return inferenceSchedulerArn;
        }

        public final void setInferenceSchedulerArn(String inferenceSchedulerArn) {
            this.inferenceSchedulerArn = inferenceSchedulerArn;
        }

        @Override
        public final Builder inferenceSchedulerArn(String inferenceSchedulerArn) {
            this.inferenceSchedulerArn = inferenceSchedulerArn;
            return this;
        }

        public final String getInferenceSchedulerName() {
            return inferenceSchedulerName;
        }

        public final void setInferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
        }

        @Override
        public final Builder inferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
            return this;
        }

        public final Instant getEventStartTime() {
            return eventStartTime;
        }

        public final void setEventStartTime(Instant eventStartTime) {
            this.eventStartTime = eventStartTime;
        }

        @Override
        public final Builder eventStartTime(Instant eventStartTime) {
            this.eventStartTime = eventStartTime;
            return this;
        }

        public final Instant getEventEndTime() {
            return eventEndTime;
        }

        public final void setEventEndTime(Instant eventEndTime) {
            this.eventEndTime = eventEndTime;
        }

        @Override
        public final Builder eventEndTime(Instant eventEndTime) {
            this.eventEndTime = eventEndTime;
            return this;
        }

        public final String getDiagnostics() {
            return diagnostics;
        }

        public final void setDiagnostics(String diagnostics) {
            this.diagnostics = diagnostics;
        }

        @Override
        public final Builder diagnostics(String diagnostics) {
            this.diagnostics = diagnostics;
            return this;
        }

        public final Long getEventDurationInSeconds() {
            return eventDurationInSeconds;
        }

        public final void setEventDurationInSeconds(Long eventDurationInSeconds) {
            this.eventDurationInSeconds = eventDurationInSeconds;
        }

        @Override
        public final Builder eventDurationInSeconds(Long eventDurationInSeconds) {
            this.eventDurationInSeconds = eventDurationInSeconds;
            return this;
        }

        @Override
        public InferenceEventSummary build() {
            return new InferenceEventSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
